/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingWorker;

class WorkerChain {
    private final List<SwingWorker> synchronizedWorkerChain = Collections.synchronizedList(new ArrayList());
    private SwingWorker unchainedWorker;
    private boolean workerIsRunning = false;

    WorkerChain() {
    }

    synchronized void setOrExecuteNextWorker(SwingWorker w, boolean chained) {
        if (w == null) {
            return;
        }
        if (this.workerIsRunning) {
            if (chained) {
                this.synchronizedWorkerChain.add(w);
            } else {
                this.unchainedWorker = w;
            }
        } else {
            if (chained) {
                this.synchronizedWorkerChain.add(w);
                this.executeFirstWorkerInChain();
            } else {
                this.unchainedWorker = w;
                w.execute();
            }
            this.workerIsRunning = true;
        }
    }

    synchronized void removeCurrentWorkerAndExecuteNext(SwingWorker currentWorker) {
        this.synchronizedWorkerChain.remove(currentWorker);
        if (this.unchainedWorker == currentWorker) {
            this.unchainedWorker = null;
        }
        if (this.synchronizedWorkerChain.size() > 0) {
            this.executeFirstWorkerInChain();
            return;
        }
        if (this.unchainedWorker != null) {
            this.unchainedWorker.execute();
            return;
        }
        this.workerIsRunning = false;
    }

    private void executeFirstWorkerInChain() {
        this.synchronizedWorkerChain.get(0).execute();
    }
}

