/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.insitu.csv.InsituRecord;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.ui.graph.TimeSeriesType;
import org.esa.snap.util.ProductUtils;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

class TimeSeriesGraphUpdater
extends SwingWorker<List<TimeSeries>, Void> {
    private final WorkerChainSupport workerChainSupport;
    private final Position cursorPosition;
    private final PositionSupport positionSupport;
    private final TimeSeriesType type;
    private final boolean showCursorTimeSeries;
    private final int version;
    private final AbstractTimeSeries timeSeries;
    private final TimeSeriesDataHandler dataHandler;
    private final VersionSafeDataSources dataSources;
    private final AxisMapping displayAxisMapping;

    TimeSeriesGraphUpdater(AbstractTimeSeries timeSeries, VersionSafeDataSources dataSources, TimeSeriesDataHandler dataHandler, AxisMapping displayAxisMapping, WorkerChainSupport workerChainSupport, Position cursorPosition, PositionSupport positionSupport, TimeSeriesType type, boolean showCursorTimeSeries, int version) {
        this.timeSeries = timeSeries;
        this.dataHandler = dataHandler;
        this.dataSources = dataSources;
        this.displayAxisMapping = displayAxisMapping;
        this.workerChainSupport = workerChainSupport;
        this.cursorPosition = cursorPosition;
        this.positionSupport = positionSupport;
        this.type = type;
        this.showCursorTimeSeries = showCursorTimeSeries;
        this.version = version;
    }

    @Override
    protected List<TimeSeries> doInBackground() throws Exception {
        if (this.dataSources.getCurrentVersion() != this.version) {
            return Collections.emptyList();
        }
        if (this.type == TimeSeriesType.INSITU) {
            return this.computeInsituTimeSeries();
        }
        return this.computeRasterTimeSeries();
    }

    @Override
    protected void done() {
        try {
            if (this.dataSources.getCurrentVersion() != this.version) {
                return;
            }
            this.dataHandler.addTimeSeries((List)this.get(), this.type);
        }
        catch (InterruptedException | ExecutionException ignore) {
            ignore.printStackTrace();
        }
        finally {
            this.workerChainSupport.removeWorkerAndStartNext(this);
        }
    }

    private List<TimeSeries> computeRasterTimeSeries() {
        ArrayList<Position> positionsToDisplay = new ArrayList<Position>();
        ArrayList<String> positionNames = new ArrayList<String>();
        if (this.type.equals((Object)TimeSeriesType.PIN)) {
            Placemark[] pinPositionsToDisplay;
            for (Placemark namedGeoPos : pinPositionsToDisplay = this.dataSources.getPinPositionsToDisplay()) {
                positionsToDisplay.add(this.positionSupport.transformGeoPos(namedGeoPos.getGeoPos()));
                positionNames.add(namedGeoPos.getLabel());
            }
        } else if (this.showCursorTimeSeries && this.cursorPosition != null) {
            positionsToDisplay.add(this.cursorPosition);
            positionNames.add("");
        }
        Set<String> aliasNames = this.displayAxisMapping.getAliasNames();
        ArrayList<TimeSeries> rasterTimeSeries = new ArrayList<TimeSeries>();
        int positionsToDisplaySize = positionsToDisplay.size();
        for (int i = 0; i < positionsToDisplaySize; ++i) {
            Position position = (Position)positionsToDisplay.get(i);
            String positionName = (String)positionNames.get(i);
            for (String aliasName : aliasNames) {
                List<String> rasterNames = this.displayAxisMapping.getRasterNames(aliasName);
                for (String rasterName : rasterNames) {
                    List<Band> bandsForVariable = this.timeSeries.getBandsForVariable(rasterName);
                    TimeSeries timeSeries = this.computeSingleTimeSeries(bandsForVariable, position.pixelX, position.pixelY, position.currentLevel, positionName);
                    rasterTimeSeries.add(this.dataHandler.getValidatedTimeSeries(timeSeries, rasterName, this.type));
                }
            }
        }
        return rasterTimeSeries;
    }

    private List<TimeSeries> computeInsituTimeSeries() {
        Placemark[] pinPositionsToDisplay;
        InsituSource insituSource = this.timeSeries.getInsituSource();
        ArrayList<TimeSeries> insituTimeSeries = new ArrayList<TimeSeries>();
        Set<String> aliasNames = this.displayAxisMapping.getAliasNames();
        for (Placemark insituPin : pinPositionsToDisplay = this.dataSources.getPinPositionsToDisplay()) {
            for (String aliasName : aliasNames) {
                List<String> insituNames = this.displayAxisMapping.getInsituNames(aliasName);
                for (String insituName : insituNames) {
                    GeoPos insituGeoposFor = this.timeSeries.getInsituGeoposFor(insituPin);
                    if (insituGeoposFor == null) continue;
                    InsituRecord[] insituRecords = insituSource.getValuesFor(insituName, insituGeoposFor);
                    TimeSeries timeSeries = this.computeSingleTimeSeries(insituRecords, insituName + "_" + insituPin.getLabel());
                    insituTimeSeries.add(this.dataHandler.getValidatedTimeSeries(timeSeries, insituName, this.type));
                }
            }
        }
        return insituTimeSeries;
    }

    private TimeSeries computeSingleTimeSeries(InsituRecord[] insituRecords, String insituName) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)insituName));
        for (InsituRecord insituRecord : insituRecords) {
            ProductData.UTC startTime = ProductData.UTC.create((Date)insituRecord.time, (long)0L);
            Millisecond timePeriod = new Millisecond(startTime.getAsDate(), ProductData.UTC.UTC_TIME_ZONE, Locale.getDefault());
            timeSeries.addOrUpdate((RegularTimePeriod)timePeriod, insituRecord.value);
        }
        return timeSeries;
    }

    private TimeSeries computeSingleTimeSeries(List<Band> bandList, int pixelX, int pixelY, int currentLevel, String positionName) {
        Band firstBand = bandList.get(0);
        String firstBandName = firstBand.getName();
        int lastUnderscore = firstBandName.lastIndexOf("_");
        String suffix = positionName.isEmpty() ? positionName : "_" + positionName;
        String timeSeriesName = firstBandName.substring(0, lastUnderscore);
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)(timeSeriesName + suffix)));
        for (Band band : bandList) {
            TimeCoding timeCoding = this.timeSeries.getRasterTimeMap().get(band);
            if (timeCoding == null) continue;
            ProductData.UTC startTime = timeCoding.getStartTime();
            Millisecond timePeriod = new Millisecond(startTime.getAsDate(), ProductData.UTC.UTC_TIME_ZONE, Locale.getDefault());
            double value = TimeSeriesGraphUpdater.getValue(band, pixelX, pixelY, currentLevel);
            timeSeries.add(new TimeSeriesDataItem((RegularTimePeriod)timePeriod, value));
        }
        return timeSeries;
    }

    private static double getValue(Band band, int pixelX, int pixelY, int currentLevel) {
        Rectangle pixelRect = new Rectangle(pixelX, pixelY, 1, 1);
        if (band.getValidMaskImage() != null) {
            RenderedImage validMask = band.getValidMaskImage().getImage(currentLevel);
            Raster validMaskData = validMask.getData(pixelRect);
            if (validMaskData.getSample(pixelX, pixelY, 0) > 0) {
                return ProductUtils.getGeophysicalSampleDouble((Band)band, (int)pixelX, (int)pixelY, (int)currentLevel);
            }
            return band.getNoDataValue();
        }
        return ProductUtils.getGeophysicalSampleDouble((Band)band, (int)pixelX, (int)pixelY, (int)currentLevel);
    }

    static interface PositionSupport {
        public Position transformGeoPos(GeoPos var1);
    }

    static abstract class VersionSafeDataSources {
        private final Placemark[] pinPositionsToDisplay;
        private final int version;

        protected VersionSafeDataSources(Placemark[] pinPositionsToDisplay, int version) {
            this.pinPositionsToDisplay = pinPositionsToDisplay;
            this.version = version;
        }

        public Placemark[] getPinPositionsToDisplay() {
            if (this.canReturnValues()) {
                return this.pinPositionsToDisplay;
            }
            return new Placemark[0];
        }

        protected abstract int getCurrentVersion();

        private boolean canReturnValues() {
            return this.getCurrentVersion() == this.version;
        }
    }

    static interface WorkerChainSupport {
        public void removeWorkerAndStartNext(TimeSeriesGraphUpdater var1);
    }

    static interface TimeSeriesDataHandler {
        public void addTimeSeries(List<TimeSeries> var1, TimeSeriesType var2);

        public TimeSeries getValidatedTimeSeries(TimeSeries var1, String var2, TimeSeriesType var3);
    }

    static class Position {
        private final int pixelX;
        private final int pixelY;
        private final int currentLevel;

        Position(int pixelX, int pixelY, int currentLevel) {
            this.currentLevel = currentLevel;
            this.pixelY = pixelY;
            this.pixelX = pixelX;
        }
    }
}

