/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.ProductNodeEvent;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.ui.PixelPositionListener;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.timeseries.ui.graph.Bundle;
import org.esa.snap.timeseries.ui.graph.TimeSeriesGraphForm;
import org.esa.snap.timeseries.ui.graph.TimeSeriesGraphModel;
import org.esa.snap.timeseries.ui.graph.TimeSeriesGraphUpdater;
import org.esa.snap.timeseries.ui.graph.TimeSeriesType;
import org.esa.snap.timeseries.ui.graph.TimeSeriesValidator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="TimeSeriesGraphTopComponent", iconBase="org/esa/snap/timeseries/ui/icons/timeseries-plot.png", persistenceType=0)
public class TimeSeriesGraphTopComponent
extends TopComponent {
    private static final String HELP_ID = "timeSeriesGraph";
    private static final String DEFAULT_RANGE_LABEL = "Value";
    private static final String DEFAULT_DOMAIN_LABEL = "Time";
    private final TimeSeriesPPL pixelPosListener = new TimeSeriesPPL();
    private final PropertyChangeListener pinSelectionListener = new PinSelectionListener();
    private final PropertyChangeListener sliderListener = new SliderListener();
    private final TimeSeriesListener timeSeriesGraphTSL = new TimeSeriesGraphTSL();
    private JFreeChart chart;
    private TimeSeriesGraphForm graphForm;
    private TimeSeriesGraphModel graphModel;
    private ProductSceneView currentView;
    private final TimeSeriesValidator validator = new TimeSeriesValidator();

    public TimeSeriesGraphTopComponent() {
        this.initUI();
    }

    private void initUI() {
        boolean displayLegend = true;
        boolean showTooltips = true;
        boolean showUrls = false;
        this.chart = ChartFactory.createTimeSeriesChart(null, (String)DEFAULT_DOMAIN_LABEL, (String)DEFAULT_RANGE_LABEL, null, (boolean)true, (boolean)true, (boolean)false);
        this.graphModel = new TimeSeriesGraphModel(this.chart.getXYPlot(), this.validator);
        this.graphForm = new TimeSeriesGraphForm(this.graphModel, this.chart, this.validator, HELP_ID);
        this.setDisplayName(Bundle.CTL_TimeSeriesGraphTopComponentName());
        this.setLayout(new BorderLayout());
        this.add(this.graphForm.getControl(), "Center");
        ProductSceneView selectedView = SnapApp.getDefault().getSelectedProductSceneView();
        if (selectedView != null) {
            this.maySetCurrentView(selectedView);
        }
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler((oldValue, newValue) -> {
            if (oldValue != null) {
                this.maySetCurrentView(null);
            }
            if (newValue != null) {
                this.maySetCurrentView((ProductSceneView)newValue);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void maySetCurrentView(ProductSceneView view) {
        String viewProductType = view.getProduct().getProductType();
        if (view != this.currentView && !view.isRGB() && viewProductType.equals("org.esa.snap.glob.timeseries") && TimeSeriesMapper.getInstance().getTimeSeries(view.getProduct()) != null) {
            this.setCurrentView(view);
        }
    }

    private void setCurrentView(ProductSceneView newView) {
        if (this.currentView == newView) {
            return;
        }
        if (this.currentView != null) {
            AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(this.currentView.getProduct());
            timeSeries.removeTimeSeriesListener(this.timeSeriesGraphTSL);
            this.currentView.removePixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.currentView.removePropertyChangeListener("selectedPin", this.pinSelectionListener);
            this.currentView.removePropertyChangeListener("timeProperty", this.sliderListener);
        }
        this.currentView = newView;
        this.graphForm.setButtonsEnabled(this.currentView != null);
        if (this.currentView != null) {
            Product currentProduct = this.currentView.getProduct();
            AbstractTimeSeries timeSeries = TimeSeriesMapper.getInstance().getTimeSeries(currentProduct);
            timeSeries.addTimeSeriesListener(this.timeSeriesGraphTSL);
            this.currentView.addPixelPositionListener((PixelPositionListener)this.pixelPosListener);
            this.currentView.addPropertyChangeListener("selectedPin", this.pinSelectionListener);
            this.currentView.addPropertyChangeListener("timeProperty", this.sliderListener);
            RasterDataNode raster = this.currentView.getRaster();
            this.graphModel.adaptToTimeSeries(timeSeries);
            this.graphModel.updateAnnotation(raster);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            String variableName = AbstractTimeSeries.rasterToVariableName(raster.getName());
            this.setDisplayName(String.format("%s - %s", Bundle.CTL_TimeSeriesGraphTopComponentName(), variableName));
        } else {
            this.graphModel.removeAnnotation();
            this.graphModel.adaptToTimeSeries(null);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            this.setDisplayName(Bundle.CTL_TimeSeriesGraphTopComponentName());
        }
    }

    private void updateTimeSeries(AbstractTimeSeries timeSeries) {
        this.graphModel.adaptToTimeSeries(timeSeries);
        this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
        this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
    }

    private class SliderListener
    implements PropertyChangeListener {
        private SliderListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TimeSeriesGraphTopComponent.this.graphModel.updateAnnotation(TimeSeriesGraphTopComponent.this.currentView.getRaster());
        }
    }

    private class TimeSeriesGraphTSL
    extends TimeSeriesListener {
        private TimeSeriesGraphTSL() {
        }

        @Override
        public void timeSeriesChanged(TimeSeriesChangeEvent event) {
            int type = event.getType();
            if (type == 8 || type == 16) {
                TimeSeriesGraphTopComponent.this.graphModel.updateAnnotation(TimeSeriesGraphTopComponent.this.currentView.getRaster());
                TimeSeriesGraphTopComponent.this.updateTimeSeries(event.getTimeSeries());
            } else if (type == 64 || type == 128 || type == 2 || type == 4) {
                TimeSeriesGraphTopComponent.this.updateTimeSeries(event.getTimeSeries());
            }
        }

        public void nodeChanged(ProductNodeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("pixelPos") || propertyName.equals("label")) {
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node instanceof Placemark) {
                this.handlePlacemarkChanged();
            } else if (node instanceof RasterDataNode && TimeSeriesGraphTopComponent.this.currentView != null) {
                TimeSeriesGraphTopComponent.this.graphModel.adaptToTimeSeries(this.getTimeSeries());
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            }
        }

        public void nodeRemoved(ProductNodeEvent event) {
            ProductNode node = event.getSourceNode();
            if (node instanceof Placemark) {
                this.handlePlacemarkChanged();
            } else if (node instanceof RasterDataNode && TimeSeriesGraphTopComponent.this.currentView != null) {
                TimeSeriesGraphTopComponent.this.graphModel.adaptToTimeSeries(this.getTimeSeries());
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
            }
        }

        private AbstractTimeSeries getTimeSeries() {
            Product product = TimeSeriesGraphTopComponent.this.currentView.getProduct();
            return TimeSeriesMapper.getInstance().getTimeSeries(product);
        }

        private void handlePlacemarkChanged() {
            boolean placemarksSet = TimeSeriesGraphTopComponent.this.currentView.getProduct().getPinGroup().getNodeCount() > 0;
            TimeSeriesGraphTopComponent.this.graphForm.setExportEnabled(placemarksSet);
            TimeSeriesGraphTopComponent.this.updateTimeSeries(this.getTimeSeries());
        }
    }

    private class PinSelectionListener
    implements PropertyChangeListener {
        private PinSelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TimeSeriesGraphTopComponent.this.graphModel.isShowingSelectedPins()) {
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.PIN);
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.INSITU);
            }
        }
    }

    private class TimeSeriesPPL
    implements PixelPositionListener {
        private TimeSeriesPPL() {
        }

        public void pixelPosChanged(ImageLayer imageLayer, int pixelX, int pixelY, int currentLevel, boolean pixelPosValid, MouseEvent e) {
            if (!TimeSeriesGraphTopComponent.this.graphModel.isShowCursorTimeSeries()) {
                return;
            }
            if (pixelPosValid && TimeSeriesGraphTopComponent.this.isVisible() && TimeSeriesGraphTopComponent.this.currentView != null) {
                TimeSeriesGraphUpdater.Position position = new TimeSeriesGraphUpdater.Position(pixelX, pixelY, currentLevel);
                TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(position, TimeSeriesType.CURSOR);
            }
            boolean autorange = e.isShiftDown();
            XYPlot xyPlot = TimeSeriesGraphTopComponent.this.chart.getXYPlot();
            for (int i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                xyPlot.getRangeAxis(i).setAutoRange(autorange);
            }
            if (TimeSeriesGraphTopComponent.this.currentView != null) {
                TimeSeriesGraphTopComponent.this.graphModel.updateAnnotation(TimeSeriesGraphTopComponent.this.currentView.getRaster());
            }
        }

        public void pixelPosNotAvailable() {
            if (!TimeSeriesGraphTopComponent.this.graphModel.isShowCursorTimeSeries()) {
                return;
            }
            TimeSeriesGraphTopComponent.this.graphModel.updateTimeSeries(null, TimeSeriesType.CURSOR);
        }
    }
}

