/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.esa.snap.framework.ui.UIUtils;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.framework.ui.tool.ToolButtonFactory;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.ui.graph.TimeSeriesGraphModel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.openide.util.HelpCtx;

class TimeSeriesGraphForm {
    private JComponent mainPanel;
    private AbstractButton showTimeSeriesForSelectedPinsButton;
    private AbstractButton showTimeSeriesForAllPinsButton;
    private AbstractButton exportTimeSeriesButton;
    private AbstractButton showCursorTimeSeriesButton;
    private TimeSeriesGraphModel graphModel;
    private final ValidatorUI validatorUI;

    TimeSeriesGraphForm(TimeSeriesGraphModel graphModel, JFreeChart chart, ValidatorUI validatorUI, String helpID) {
        this.graphModel = graphModel;
        this.validatorUI = validatorUI;
        this.createUI(chart, helpID);
    }

    private void createUI(JFreeChart chart, String helpID) {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableWeightY(Double.valueOf(1.0));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        tableLayout.setRowWeightY(0, Double.valueOf(1.0));
        tableLayout.setRowWeightY(1, Double.valueOf(0.0));
        tableLayout.setCellRowspan(0, 1, Integer.valueOf(2));
        tableLayout.setCellFill(1, 0, TableLayout.Fill.HORIZONTAL);
        tableLayout.setCellPadding(1, 0, new Insets(5, 5, 5, 5));
        this.mainPanel = new JPanel((LayoutManager)tableLayout);
        this.mainPanel.setPreferredSize(new Dimension(320, 200));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.mainPanel.add((Component)chartPanel);
        this.mainPanel.add(this.createButtonPanel(helpID));
        this.mainPanel.add(this.validatorUI.createUI());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private JPanel createButtonPanel(String helpID) {
        this.showTimeSeriesForSelectedPinsButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/SelectedPinSpectra24.gif"), (boolean)true);
        this.showTimeSeriesForSelectedPinsButton.addActionListener(e -> {
            if (this.graphModel.isShowingAllPins()) {
                this.showTimeSeriesForAllPinsButton.setSelected(false);
                this.graphModel.setIsShowingAllPins(false);
            }
            this.graphModel.setIsShowingSelectedPins(this.showTimeSeriesForSelectedPinsButton.isSelected());
        });
        this.showTimeSeriesForSelectedPinsButton.setName("showTimeSeriesForSelectedPinsButton");
        this.showTimeSeriesForSelectedPinsButton.setToolTipText("Show time series for selected pin");
        this.showTimeSeriesForAllPinsButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/PinSpectra24.gif"), (boolean)true);
        this.showTimeSeriesForAllPinsButton.addActionListener(e -> {
            if (this.graphModel.isShowingSelectedPins()) {
                this.showTimeSeriesForSelectedPinsButton.setSelected(false);
                this.graphModel.setIsShowingSelectedPins(false);
            }
            this.graphModel.setIsShowingAllPins(this.showTimeSeriesForAllPinsButton.isSelected());
        });
        this.showTimeSeriesForAllPinsButton.setName("showTimeSeriesForAllPinsButton");
        this.showTimeSeriesForAllPinsButton.setToolTipText("Show time series for all pins");
        this.showCursorTimeSeriesButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/CursorSpectrum24.gif"), (boolean)true);
        this.showCursorTimeSeriesButton.addActionListener(e -> this.graphModel.setIsShowingCursorTimeSeries(this.showCursorTimeSeriesButton.isSelected()));
        this.showCursorTimeSeriesButton.setToolTipText("Show time series for cursor");
        this.showCursorTimeSeriesButton.setSelected(true);
        this.exportTimeSeriesButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Export24.gif"), (boolean)false);
        this.exportTimeSeriesButton.addActionListener(e -> {
            ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
            JOptionPane.showMessageDialog((Component)view, "Not available in the current version.", "Export data", 1);
        });
        this.exportTimeSeriesButton.setToolTipText("Export raster data time series of all pins");
        this.exportTimeSeriesButton.setName("exportTimeSeriesButton");
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null) {
            this.exportTimeSeriesButton.setEnabled(sceneView.getProduct().getPinGroup().getNodeCount() > 0);
        } else {
            this.exportTimeSeriesButton.setEnabled(false);
        }
        AbstractButton helpButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"icons/Help22.png"), (boolean)false);
        helpButton.addActionListener(e -> new HelpCtx(helpID).display());
        helpButton.setToolTipText("Help");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTableWeightY(Double.valueOf(0.0));
        JPanel buttonPanel = new JPanel((LayoutManager)tableLayout);
        buttonPanel.add(this.showTimeSeriesForSelectedPinsButton);
        buttonPanel.add(this.showTimeSeriesForAllPinsButton);
        buttonPanel.add(this.showCursorTimeSeriesButton);
        buttonPanel.add(this.exportTimeSeriesButton);
        buttonPanel.add(tableLayout.createVerticalSpacer());
        buttonPanel.add(helpButton);
        return buttonPanel;
    }

    JComponent getControl() {
        return this.mainPanel;
    }

    void setButtonsEnabled(boolean enabled) {
        this.showTimeSeriesForSelectedPinsButton.setEnabled(enabled);
        this.showTimeSeriesForAllPinsButton.setEnabled(enabled);
    }

    public void setExportEnabled(boolean placemarksSet) {
        this.exportTimeSeriesButton.setEnabled(placemarksSet);
    }

    static interface ValidatorUI {
        public JComponent createUI();
    }
}

