/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.PlacemarkGroup;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;

class TimeSeriesGraphDisplayController {
    private static final Color[] COLORS = new Color[]{Color.blue, Color.red.darker(), Color.green.darker(), Color.orange, Color.gray, Color.blue, Color.magenta.darker(), Color.pink, Color.cyan.darker(), Color.yellow.darker(), Color.green.darker().darker(), Color.red, Color.magenta, Color.orange.darker()};
    private static final AffineTransform ROTATION_45 = AffineTransform.getRotateInstance(Math.toRadians(45.0));
    private static final AffineTransform ROTATION_180 = AffineTransform.getRotateInstance(Math.toRadians(180.0));
    private static final AffineTransform SCALE = AffineTransform.getScaleInstance(1.0, 1.0);
    private static final Shape[] SHAPES = new Shape[]{new Rectangle(-5, -5, 10, 10), new Ellipse2D.Float(-5.0f, -5.0f, 10.0f, 10.0f), TimeSeriesGraphDisplayController.createTriangle(), ROTATION_180.createTransformedShape(TimeSeriesGraphDisplayController.createTriangle()), TimeSeriesGraphDisplayController.createDiamond(), TimeSeriesGraphDisplayController.createPlus(), TimeSeriesGraphDisplayController.createStar(), new Rectangle(-2, -5, 4, 10), new Rectangle(-5, -2, 10, 4), ROTATION_45.createTransformedShape(new Rectangle(-2, -5, 4, 10)), ROTATION_45.createTransformedShape(new Rectangle(-5, -2, 10, 4))};
    public static final Shape CURSOR_SHAPE = ROTATION_45.createTransformedShape(TimeSeriesGraphDisplayController.createPlus());
    private final List<String> eoVariablesToDisplay;
    private final List<String> insituVariablesToDisplay;
    private final PinSupport pinSupport;
    private AbstractTimeSeries timeSeries;

    private static Shape createTriangle() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-5.0f, -5.0f);
        generalPath.lineTo(5.0f, -5.0f);
        generalPath.lineTo(0.0f, 5.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createPlus() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-5.0f, -1.0f);
        generalPath.lineTo(-1.0f, -1.0f);
        generalPath.lineTo(-1.0f, -5.0f);
        generalPath.lineTo(1.0f, -5.0f);
        generalPath.lineTo(1.0f, -1.0f);
        generalPath.lineTo(5.0f, -1.0f);
        generalPath.lineTo(5.0f, 1.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(1.0f, 5.0f);
        generalPath.lineTo(-1.0f, 5.0f);
        generalPath.lineTo(-1.0f, 1.0f);
        generalPath.lineTo(-5.0f, 1.0f);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createStar() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -5.0f);
        generalPath.lineTo(1.5, -2.5);
        generalPath.lineTo(4.5, -2.5);
        generalPath.lineTo(3.0f, 0.0f);
        generalPath.lineTo(4.5, 2.5);
        generalPath.lineTo(1.5, 2.5);
        generalPath.lineTo(0.0f, 5.0f);
        generalPath.lineTo(-1.5, 2.5);
        generalPath.lineTo(-4.5, 2.5);
        generalPath.lineTo(-3.0f, 0.0f);
        generalPath.lineTo(-4.5, -2.5);
        generalPath.lineTo(-1.5, -2.5);
        generalPath.closePath();
        return generalPath;
    }

    private static Shape createDiamond() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -5.0f);
        generalPath.lineTo(5.0f, 0.0f);
        generalPath.lineTo(0.0f, 5.0f);
        generalPath.lineTo(-5.0f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    TimeSeriesGraphDisplayController(PinSupport pinSupport) {
        this.pinSupport = pinSupport;
        this.eoVariablesToDisplay = new ArrayList<String>();
        this.insituVariablesToDisplay = new ArrayList<String>();
    }

    public Paint getPaint(int i) {
        return COLORS[i % COLORS.length];
    }

    public List<String> getEoVariablesToDisplay() {
        return Collections.unmodifiableList(this.eoVariablesToDisplay);
    }

    public List<String> getInsituVariablesToDisplay() {
        return Collections.unmodifiableList(this.insituVariablesToDisplay);
    }

    public void adaptTo(AbstractTimeSeries timeSeries) {
        this.timeSeries = timeSeries;
        for (String eoVariableName : timeSeries.getEoVariables()) {
            if (timeSeries.isEoVariableSelected(eoVariableName)) {
                if (this.eoVariablesToDisplay.contains(eoVariableName)) continue;
                this.eoVariablesToDisplay.add(eoVariableName);
                continue;
            }
            this.eoVariablesToDisplay.remove(eoVariableName);
        }
        if (timeSeries.hasInsituData()) {
            for (String insituVariableName : timeSeries.getInsituSource().getParameterNames()) {
                if (timeSeries.isInsituVariableSelected(insituVariableName)) {
                    if (this.insituVariablesToDisplay.contains(insituVariableName)) continue;
                    this.insituVariablesToDisplay.add(insituVariableName);
                    continue;
                }
                this.insituVariablesToDisplay.remove(insituVariableName);
            }
        }
    }

    public Placemark[] getPinPositionsToDisplay() {
        if (this.pinSupport.isShowingAllPins()) {
            PlacemarkGroup pinGroup = this.timeSeries.getTsProduct().getPinGroup();
            return (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()]);
        }
        if (this.pinSupport.isShowingSelectedPins()) {
            return this.pinSupport.getSelectedPins();
        }
        return new Placemark[0];
    }

    public Shape getShape(int posIdx) {
        Shape shape = SHAPES[posIdx % SHAPES.length];
        return SCALE.createTransformedShape(shape);
    }

    static interface PinSupport {
        public boolean isShowingAllPins();

        public boolean isShowingSelectedPins();

        public Placemark[] getSelectedPins();
    }
}

