/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.assistant;

import java.awt.Component;
import org.esa.snap.framework.ui.assistant.AssistantPage;
import org.esa.snap.timeseries.ui.Variable;
import org.esa.snap.timeseries.ui.VariableSelectionPane;
import org.esa.snap.timeseries.ui.VariableSelectionPaneModel;
import org.esa.snap.timeseries.ui.assistant.AbstractTimeSeriesAssistantPage;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantModel;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantPage_TimeSeriesName;

class TimeSeriesAssistantPage_VariableSelection
extends AbstractTimeSeriesAssistantPage {
    TimeSeriesAssistantPage_VariableSelection(TimeSeriesAssistantModel assistantModel) {
        super("Select Variables", assistantModel);
    }

    protected Component createPageComponent() {
        return new VariableSelectionPane(this.getAssistantModel().getVariableSelectionModel());
    }

    public boolean validatePage() {
        if (super.validatePage()) {
            VariableSelectionPaneModel variableModel = this.getAssistantModel().getVariableSelectionModel();
            for (int i = 0; i < variableModel.getSize(); ++i) {
                Variable variable = variableModel.getElementAt(i);
                if (!variable.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canFinish() {
        return false;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AssistantPage getNextPage() {
        this.removeModeListener();
        TimeSeriesAssistantModel model = this.getAssistantModel();
        VariableSelectionPaneModel variableModel = model.getVariableSelectionModel();
        for (int i = 0; i < variableModel.getSize(); ++i) {
            Variable variable = variableModel.getElementAt(i);
            if (!variable.isSelected()) continue;
            model.setTimeSeriesName("TimeSeries_" + variable.getName());
            break;
        }
        return new TimeSeriesAssistantPage_TimeSeriesName(model);
    }
}

