/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.assistant;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.ui.assistant.AssistantPage;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.ui.ProductLocationsPane;
import org.esa.snap.timeseries.ui.ProductLocationsPaneModel;
import org.esa.snap.timeseries.ui.Variable;
import org.esa.snap.timeseries.ui.assistant.AbstractTimeSeriesAssistantPage;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantModel;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantPage_ReprojectingSources;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantPage_VariableSelection;

class TimeSeriesAssistantPage_SourceProducts
extends AbstractTimeSeriesAssistantPage {
    TimeSeriesAssistantPage_SourceProducts(TimeSeriesAssistantModel model) {
        super("Define Time Series Sources", model);
    }

    protected Component createPageComponent() {
        ProductLocationsPaneModel locationsModel = this.getAssistantModel().getProductLocationsModel();
        return new ProductLocationsPane(locationsModel);
    }

    public boolean validatePage() {
        ProductLocationsPaneModel locationsModel;
        return super.validatePage() && (locationsModel = this.getAssistantModel().getProductLocationsModel()).getSize() > 0;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AssistantPage getNextPage() {
        this.removeModeListener();
        TimeSeriesAssistantModel model = this.getAssistantModel();
        MyProgressMonitorSwingWorker worker = new MyProgressMonitorSwingWorker(model);
        worker.executeWithBlocking();
        if (this.allProductsOnSameGrid()) {
            return new TimeSeriesAssistantPage_VariableSelection(model);
        }
        return new TimeSeriesAssistantPage_ReprojectingSources(model);
    }

    private boolean allProductsOnSameGrid() {
        Product refProduct = null;
        List<ProductLocation> productLocations = this.getAssistantModel().getProductLocationsModel().getProductLocations();
        for (ProductLocation productLocation : productLocations) {
            for (Product product : productLocation.getProducts(ProgressMonitor.NULL).values()) {
                if (refProduct != null) {
                    if (product == null || refProduct.isCompatibleProduct(product, 1.0E-5f)) continue;
                    return false;
                }
                if (product == null) continue;
                refProduct = product;
            }
        }
        return true;
    }

    public boolean canFinish() {
        return false;
    }

    private class MyProgressMonitorSwingWorker
    extends ProgressMonitorSwingWorker<Variable[], Object> {
        private final TimeSeriesAssistantModel model;

        private MyProgressMonitorSwingWorker(TimeSeriesAssistantModel model) {
            super(TimeSeriesAssistantPage_SourceProducts.this.getContext().getCurrentPage().getPageComponent(), "Scanning for products");
            this.model = model;
        }

        protected Variable[] doInBackground(ProgressMonitor pm) throws Exception {
            return this.getVariables(TimeSeriesAssistantPage_SourceProducts.this.getAssistantModel().getProductLocationsModel(), pm);
        }

        protected void done() {
            try {
                this.model.getVariableSelectionModel().set((Variable[])this.get());
            }
            catch (InterruptedException ignored) {
            }
            catch (ExecutionException e) {
                TimeSeriesAssistantPage_SourceProducts.this.getContext().showErrorDialog("Failed to scan for products: \n" + e.getMessage());
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Variable[] getVariables(ProductLocationsPaneModel locationsModel, ProgressMonitor pm) {
            try {
                pm.beginTask("Scanning product locations...", locationsModel.getSize());
                for (int i = 0; i < locationsModel.getSize(); ++i) {
                    ProductLocation location = locationsModel.getElementAt(i);
                    location.loadProducts((ProgressMonitor)new SubProgressMonitor(pm, 1));
                    Collection<Product> products = location.getProducts(ProgressMonitor.NULL).values();
                    if (!products.isEmpty()) {
                        Product product = products.iterator().next();
                        String[] bandNames = product.getBandNames();
                        Variable[] variables = new Variable[bandNames.length];
                        for (int j = 0; j < bandNames.length; ++j) {
                            variables[j] = new Variable(bandNames[j]);
                        }
                        location.closeProducts();
                        Variable[] variableArray = variables;
                        return variableArray;
                    }
                    location.closeProducts();
                }
            }
            finally {
                pm.done();
            }
            return new Variable[0];
        }
    }
}

