/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.assistant;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.esa.snap.framework.datamodel.CrsGeoCoding;
import org.esa.snap.framework.datamodel.GeoCoding;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.MapGeoCoding;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductFilter;
import org.esa.snap.framework.gpf.GPF;
import org.esa.snap.framework.gpf.ui.CollocationCrsForm;
import org.esa.snap.framework.gpf.ui.SourceProductSelector;
import org.esa.snap.framework.ui.AppContext;
import org.esa.snap.framework.ui.assistant.AssistantPage;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.ui.ProductLocationsPaneModel;
import org.esa.snap.timeseries.ui.assistant.AbstractTimeSeriesAssistantPage;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantModel;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantPage_VariableSelection;
import org.esa.snap.util.ProductUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class TimeSeriesAssistantPage_ReprojectingSources
extends AbstractTimeSeriesAssistantPage {
    private MyCollocationCrsForm collocationCrsForm;
    private JTextArea errorText;

    TimeSeriesAssistantPage_ReprojectingSources(TimeSeriesAssistantModel model) {
        super("Reproject Source Products", model);
    }

    public boolean canFinish() {
        return false;
    }

    public boolean canHelp() {
        return false;
    }

    public boolean validatePage() {
        return this.collocationCrsForm.getCollocationProduct() != null;
    }

    public boolean hasNextPage() {
        return true;
    }

    public AssistantPage getNextPage() {
        Reprojector reprojector = new Reprojector(this.getPageComponent());
        reprojector.executeWithBlocking();
        return new TimeSeriesAssistantPage_VariableSelection(this.getAssistantModel());
    }

    protected Component createPageComponent() {
        PropertyChangeListener listener = evt -> this.getContext().updateState();
        this.collocationCrsForm = new MyCollocationCrsForm((AppContext)new SnapApp.SnapContext(), listener, this.getAssistantModel());
        this.collocationCrsForm.addMyChangeListener();
        JPanel pagePanel = new JPanel(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)new JLabel("Use CRS of "), "West");
        northPanel.add(this.collocationCrsForm.getCrsUI());
        pagePanel.add((Component)northPanel, "North");
        JPanel southPanel = new JPanel(new FlowLayout());
        this.errorText = new JTextArea();
        this.errorText.setBackground(southPanel.getBackground());
        JPanel jPanel = new JPanel();
        jPanel.add(this.errorText);
        southPanel.add(this.errorText);
        pagePanel.add((Component)southPanel, "South");
        return pagePanel;
    }

    private void setErrorMessage(String message) {
        SwingUtilities.invokeLater(() -> this.errorText.setText(message));
    }

    private class Reprojector
    extends ProgressMonitorSwingWorker<Void, TimeSeriesAssistantModel> {
        protected Reprojector(Component parentComponent) {
            super(parentComponent, "Reprojecting source products ...");
        }

        protected Void doInBackground(ProgressMonitor pm) throws Exception {
            this.reprojectSourceProducts(pm);
            return null;
        }

        private void reprojectSourceProducts(ProgressMonitor pm) {
            ProductLocationsPaneModel productLocationsModel = TimeSeriesAssistantPage_ReprojectingSources.this.getAssistantModel().getProductLocationsModel();
            List<ProductLocation> productLocations = productLocationsModel.getProductLocations();
            pm.beginTask("Reprojecting...", productLocations.size());
            for (ProductLocation productLocation : productLocations) {
                Map<String, Product> products = productLocation.getProducts(ProgressMonitor.NULL);
                Product crsReferenceProduct = this.getCrsReferenceProduct();
                for (Map.Entry<String, Product> productEntry : products.entrySet()) {
                    Product product = productEntry.getValue();
                    if (product.isCompatibleProduct(crsReferenceProduct, 1.0E-5f)) continue;
                    Product reprojectedProduct = this.createProjectedProduct(product, crsReferenceProduct);
                    productEntry.setValue(reprojectedProduct);
                }
                pm.worked(1);
            }
            pm.done();
        }

        private Product createProjectedProduct(Product toReproject, Product crsReference) {
            Map<String, Product> productMap = this.getProductMap(toReproject, crsReference);
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("resamplingName", "Nearest");
            parameterMap.put("includeTiePointGrids", false);
            parameterMap.put("addDeltaBands", false);
            Product reprojectedProduct = GPF.createProduct((String)"Reproject", parameterMap, productMap);
            reprojectedProduct.setStartTime(toReproject.getStartTime());
            reprojectedProduct.setEndTime(toReproject.getEndTime());
            return reprojectedProduct;
        }

        private Map<String, Product> getProductMap(Product product, Product crsReference) {
            HashMap<String, Product> productMap = new HashMap<String, Product>(2);
            productMap.put("source", product);
            productMap.put("collocateWith", crsReference);
            return productMap;
        }

        private Product getCrsReferenceProduct() {
            return TimeSeriesAssistantPage_ReprojectingSources.this.collocationCrsForm.getCollocationProduct();
        }
    }

    private class CollocateProductFilter
    implements ProductFilter {
        private final List<Product> products;

        public CollocateProductFilter(List<Product> products) {
            this.products = products;
        }

        public boolean accept(Product collocationProduct) {
            for (Product timeSeriesSourceProduct : this.products) {
                if (!this.productsIntersect(timeSeriesSourceProduct, collocationProduct)) continue;
                this.resetErrorMessage();
                return true;
            }
            TimeSeriesAssistantPage_ReprojectingSources.this.setErrorMessage("You need to specify a projected product as collocation product.\nAt least one product within the time series needs to intersect the collocation product.");
            return false;
        }

        private void resetErrorMessage() {
            TimeSeriesAssistantPage_ReprojectingSources.this.setErrorMessage("");
        }

        private boolean productsIntersect(Product timeSeriesSourceProduct, Product collocationProduct) {
            if (collocationProduct.getGeoCoding() == null) {
                return false;
            }
            GeoCoding geoCoding = collocationProduct.getGeoCoding();
            if (geoCoding.canGetGeoPos() && geoCoding.canGetPixelPos() && (geoCoding instanceof CrsGeoCoding || geoCoding instanceof MapGeoCoding)) {
                GeneralPath[] sourcePaths = ProductUtils.createGeoBoundaryPaths((Product)timeSeriesSourceProduct);
                GeneralPath[] collocationPaths = ProductUtils.createGeoBoundaryPaths((Product)collocationProduct);
                for (GeneralPath sourcePath : sourcePaths) {
                    for (GeneralPath collocationPath : collocationPaths) {
                        Area sourceArea = new Area(sourcePath);
                        Area collocationArea = new Area(collocationPath);
                        collocationArea.intersect(sourceArea);
                        if (collocationArea.isEmpty()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class MyCollocationCrsForm
    extends CollocationCrsForm {
        private SourceProductSelector collocateProductSelector;
        private final PropertyChangeListener listener;
        private final TimeSeriesAssistantModel assistantModel;

        public MyCollocationCrsForm(AppContext appContext, PropertyChangeListener listener, TimeSeriesAssistantModel assistantModel) {
            super(appContext);
            this.listener = listener;
            this.assistantModel = assistantModel;
        }

        void addMyChangeListener() {
            super.addCrsChangeListener(this.listener);
        }

        public CoordinateReferenceSystem getCRS(GeoPos referencePos) {
            Product collocationProduct = this.collocateProductSelector.getSelectedProduct();
            if (collocationProduct != null) {
                return collocationProduct.getGeoCoding().getMapCRS();
            }
            return null;
        }

        public void prepareShow() {
            this.collocateProductSelector.initProducts();
        }

        public void prepareHide() {
            this.collocateProductSelector.releaseProducts();
        }

        protected JComponent createCrsComponent() {
            this.collocateProductSelector = new SourceProductSelector((AppContext)new SnapApp.SnapContext(), "Product:");
            ArrayList<Product> products = new ArrayList<Product>();
            for (ProductLocation productLocation : this.assistantModel.getProductLocationsModel().getProductLocations()) {
                for (Product product : productLocation.getProducts(ProgressMonitor.NULL).values()) {
                    products.add(product);
                }
            }
            this.collocateProductSelector.setProductFilter((ProductFilter)new CollocateProductFilter(products));
            this.collocateProductSelector.addSelectionChangeListener((SelectionChangeListener)new AbstractSelectionChangeListener(){

                public void selectionChanged(SelectionChangeEvent event) {
                    MyCollocationCrsForm.this.fireCrsChanged();
                }
            });
            JPanel panel = new JPanel(new BorderLayout(2, 2));
            panel.add((Component)this.collocateProductSelector.getProductNameComboBox(), "Center");
            panel.add((Component)this.collocateProductSelector.getProductFileChooserButton(), "East");
            panel.addPropertyChangeListener("enabled", evt -> {
                this.collocateProductSelector.getProductNameComboBox().setEnabled(panel.isEnabled());
                this.collocateProductSelector.getProductFileChooserButton().setEnabled(panel.isEnabled());
                boolean collocate = this.getRadioButton().isSelected();
                this.getCrsUI().firePropertyChange("collocate", !collocate, collocate);
            });
            return panel;
        }

        public Product getCollocationProduct() {
            return this.collocateProductSelector.getSelectedProduct();
        }

        public void setReferenceProduct(Product referenceProduct) {
        }
    }
}

