/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.assistant;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductManager;
import org.esa.snap.framework.ui.assistant.AbstractAssistantPage;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesFactory;
import org.esa.snap.timeseries.ui.ProductLocationsPaneModel;
import org.esa.snap.timeseries.ui.VariableSelectionPaneModel;
import org.esa.snap.timeseries.ui.assistant.TimeSeriesAssistantModel;
import org.esa.snap.util.Debug;

abstract class AbstractTimeSeriesAssistantPage
extends AbstractAssistantPage {
    private final TimeSeriesAssistantModel assistantModel;
    private final MyChangeListener changeListener;

    AbstractTimeSeriesAssistantPage(String pageTitle, TimeSeriesAssistantModel model) {
        super(pageTitle);
        this.assistantModel = model;
        this.changeListener = new MyChangeListener();
        this.assistantModel.addChangeListener(this.changeListener);
    }

    protected TimeSeriesAssistantModel getAssistantModel() {
        return this.assistantModel;
    }

    public boolean performFinish() {
        TimeSeriesAssistantModel model = this.getAssistantModel();
        TimeSeriesCreator creator = new TimeSeriesCreator(model, this.getPageComponent());
        creator.executeWithBlocking();
        this.removeModeListener();
        return true;
    }

    public void performCancel() {
        this.removeModeListener();
    }

    protected void removeModeListener() {
        this.assistantModel.removeChangeListener(this.changeListener);
    }

    private void addTimeSeriesProductToVisat(TimeSeriesAssistantModel assistantModel, ProgressMonitor pm) {
        pm.beginTask("Creating Time Series", 50);
        ProductLocationsPaneModel locationsModel = assistantModel.getProductLocationsModel();
        pm.worked(1);
        VariableSelectionPaneModel variablesModel = assistantModel.getVariableSelectionModel();
        pm.worked(1);
        AbstractTimeSeries timeSeries = TimeSeriesFactory.create(assistantModel.getTimeSeriesName(), locationsModel.getProductLocations(), variablesModel.getSelectedVariableNames());
        pm.worked(42);
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        Product tsProduct = timeSeries.getTsProduct();
        productManager.addProduct(tsProduct);
        pm.worked(6);
    }

    private class TimeSeriesCreator
    extends ProgressMonitorSwingWorker<Void, TimeSeriesAssistantModel> {
        private final TimeSeriesAssistantModel model;

        private TimeSeriesCreator(TimeSeriesAssistantModel model, Component parentComponent) {
            super(parentComponent, "Creating Time Series...");
            this.model = model;
        }

        protected Void doInBackground(ProgressMonitor pm) throws Exception {
            AbstractTimeSeriesAssistantPage.this.addTimeSeriesProductToVisat(this.model, pm);
            return null;
        }

        protected void done() {
            try {
                this.get();
            }
            catch (Exception e) {
                Debug.trace((Throwable)e);
                AbstractTimeSeriesAssistantPage.this.getContext().showErrorDialog(e.getMessage());
            }
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractTimeSeriesAssistantPage.this.getContext().updateState();
        }
    }
}

