/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.export.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.SnapDialogs;
import org.esa.snap.util.SystemUtils;
import org.esa.snap.util.io.BeamFileChooser;
import org.esa.snap.util.io.BeamFileFilter;
import org.openide.util.HelpCtx;

public class TimeSeriesExportHelper {
    public static FileWithLevel getOutputFileWithLevelOption(RasterDataNode raster, String title, String fileNamePrefix, String dirPreferencesKey, BeamFileFilter fileFilter, String helpId) {
        SnapApp snapApp = SnapApp.getDefault();
        String lastDir = snapApp.getPreferences().get(dirPreferencesKey, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        BeamFileChooser fileChooser = new BeamFileChooser();
        if (helpId != null) {
            HelpCtx.setHelpIDString((JComponent)fileChooser, (String)helpId);
        }
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)fileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(snapApp.getInstanceName() + " - " + title);
        fileChooser.setCurrentFilename(fileNamePrefix + raster.getName());
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int maxLevel = raster.getSourceImage().getModel().getLevelCount() - 1;
        maxLevel = maxLevel > 10 ? 10 : maxLevel;
        JPanel levelPanel = new JPanel(new GridLayout(maxLevel, 1));
        levelPanel.setBorder(BorderFactory.createTitledBorder("Resolution Level"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < maxLevel; ++i) {
            String buttonText = Integer.toString(i);
            if (i == 0) {
                buttonText = buttonText + " (high, very slow)";
            } else if (i == maxLevel - 1) {
                buttonText = buttonText + " (low, fast)";
            }
            JRadioButton button = new JRadioButton(buttonText, true);
            buttonGroup.add(button);
            levelPanel.add(button);
            button.setSelected(true);
        }
        JPanel accessory = new JPanel();
        accessory.setLayout(new BoxLayout(accessory, 1));
        accessory.add(levelPanel);
        fileChooser.setAccessory((JComponent)accessory);
        int result = fileChooser.showSaveDialog((Component)snapApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            snapApp.getPreferences().get(dirPreferencesKey, currentDirectory.getPath());
        }
        if (result != 0) {
            return null;
        }
        if (file == null || file.getName().isEmpty()) {
            return null;
        }
        if (!TimeSeriesExportHelper.promptForOverwrite(file)) {
            return null;
        }
        int level = TimeSeriesExportHelper.parseLevel(buttonGroup);
        return new FileWithLevel(file, level);
    }

    public static boolean promptForOverwrite(File file) {
        return !file.exists() || SnapDialogs.Answer.YES == SnapDialogs.requestDecision((String)"File Exists", (String)("The file\n'" + file.getPath() + "'\n" + "already exists.\n\n" + "Do you really want to overwrite it?\n"), (boolean)false, null);
    }

    private static int parseLevel(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> buttonEnumeration = buttonGroup.getElements();
        while (buttonEnumeration.hasMoreElements()) {
            AbstractButton abstractButton = buttonEnumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            String buttonText = abstractButton.getText();
            int index = buttonText.indexOf(" (");
            if (index != -1) {
                buttonText = buttonText.substring(0, index);
            }
            return Integer.parseInt(buttonText);
        }
        return -1;
    }

    public static class FileWithLevel {
        public File file;
        public int level;

        public FileWithLevel(File file, int level) {
            this.file = file;
            this.level = level;
        }
    }
}

