/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.export.kmz;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.CrsGeoCoding;
import org.esa.snap.framework.datamodel.GeoCoding;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.ImageInfo;
import org.esa.snap.framework.datamodel.MapGeoCoding;
import org.esa.snap.framework.datamodel.PixelPos;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.framework.ui.product.ProductSceneView;
import org.esa.snap.jai.ImageManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.SnapDialogs;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.export.kmz.Bundle;
import org.esa.snap.timeseries.export.util.TimeSeriesExportHelper;
import org.esa.snap.util.io.BeamFileFilter;
import org.esa.snap.util.kmz.KmlFeature;
import org.esa.snap.util.kmz.KmlFolder;
import org.esa.snap.util.kmz.KmlGroundOverlay;
import org.esa.snap.util.kmz.KmzExporter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportTimeBasedKmz
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String HELP_ID = "exportTimeBasedKmz";
    private static final String IMAGE_EXPORT_DIR_PREFERENCES_KEY = "user.image.export.dir";
    private final BeamFileFilter kmzFileFilter = new BeamFileFilter("KMZ", "kmz", "KMZ - Google Earth File Format");
    private int level = 2;
    private ProductSceneView view;

    public ExportTimeBasedKmz() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportTimeBasedKmz(Lookup lkp) {
        super(Bundle.CTL_ExportTimeBasedKmzName());
        Lookup.Result result = lkp.lookupResult(ProductSceneViewTopComponent.class);
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)result));
        this.setEnabled(false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ExportTimeBasedKmz(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabled(SnapApp.getDefault().getSelectedProductSceneView() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.view = SnapApp.getDefault().getSelectedProductSceneView();
        GeoCoding geoCoding = this.view.getProduct().getGeoCoding();
        boolean isGeographic = false;
        if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
            MapTransformDescriptor transformDescriptor = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform().getDescriptor();
            String typeID = transformDescriptor.getTypeID();
            if (typeID.equals("Identity")) {
                isGeographic = true;
            }
        } else if (geoCoding instanceof CrsGeoCoding) {
            isGeographic = CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
        }
        if (isGeographic) {
            File output = this.fetchOutputFile(this.view);
            if (output == null) {
                return;
            }
            String title = "KMZ Export";
            KmzSwingWorker worker = new KmzSwingWorker("KMZ Export", output);
            worker.executeWithBlocking();
        } else {
            String message = "Product must be in ''Geographic Lat/Lon'' projection.";
            SnapDialogs.showInformation((String)message, null);
        }
    }

    protected File fetchOutputFile(ProductSceneView sceneView) {
        TimeSeriesExportHelper.FileWithLevel fileWithLevel = TimeSeriesExportHelper.getOutputFileWithLevelOption(sceneView.getRaster(), "Export time series as time based KMZ", "time_series_", IMAGE_EXPORT_DIR_PREFERENCES_KEY, this.kmzFileFilter, HELP_ID);
        this.level = fileWithLevel.level;
        return fileWithLevel.file;
    }

    private KmlFeature createKmlFeature() {
        if (this.view.isRGB()) {
            return null;
        }
        TimeSeriesMapper timeSeriesMapper = TimeSeriesMapper.getInstance();
        AbstractTimeSeries timeSeries = timeSeriesMapper.getTimeSeries(this.view.getProduct());
        List<Band> bands = timeSeries.getBandsForVariable(AbstractTimeSeries.rasterToVariableName(this.view.getRaster().getName()));
        if (bands.isEmpty()) {
            return null;
        }
        RasterDataNode refRaster = (RasterDataNode)bands.get(0);
        KmlFolder folder = new KmlFolder(refRaster.getName(), refRaster.getDescription());
        for (RasterDataNode rasterDataNode : bands) {
            GeoCoding geoCoding = rasterDataNode.getGeoCoding();
            PixelPos upperLeftPP = new PixelPos(0.0, 0.0);
            PixelPos lowerRightPP = new PixelPos((double)rasterDataNode.getSceneRasterWidth(), (double)rasterDataNode.getSceneRasterHeight());
            GeoPos upperLeftGP = geoCoding.getGeoPos(upperLeftPP, null);
            GeoPos lowerRightGP = geoCoding.getGeoPos(lowerRightPP, null);
            double north = upperLeftGP.getLat();
            double south = lowerRightGP.getLat();
            double east = lowerRightGP.getLon();
            double west = upperLeftGP.getLon();
            if (geoCoding.isCrossingMeridianAt180()) {
                east += 360.0;
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(west, east, north, south, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            TimeCoding timeCoding = timeSeries.getRasterTimeMap().get(rasterDataNode);
            if (timeCoding == null) continue;
            ProductData.UTC startTime = timeCoding.getStartTime();
            ProductData.UTC endTime = timeCoding.getEndTime();
            ImageManager imageManager = ImageManager.getInstance();
            ImageInfo imageInfo = rasterDataNode.getImageInfo(ProgressMonitor.NULL);
            RenderedImage levelImage = imageManager.createColoredBandImage(new RasterDataNode[]{rasterDataNode}, imageInfo, this.level);
            String name = rasterDataNode.getName();
            KmlGroundOverlay groundOverlay = new KmlGroundOverlay(name, levelImage, (BoundingBox)referencedEnvelope, startTime, endTime);
            groundOverlay.setIconName(name + rasterDataNode.getProduct().getRefNo());
            folder.addChild((KmlFeature)groundOverlay);
        }
        return folder;
    }

    private class KmzSwingWorker
    extends ProgressMonitorSwingWorker {
        private final String title;
        private final File output;
        private static final int ONE_MEGABYTE = 1036288;

        KmzSwingWorker(String title, File output) {
            super((Component)ExportTimeBasedKmz.this.view, title);
            this.title = title;
            this.output = output;
        }

        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            KmlFeature kmlFeature = ExportTimeBasedKmz.this.createKmlFeature();
            FileOutputStream fileOutputStream = new FileOutputStream(this.output);
            try (ZipOutputStream zipStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream, 5181440));){
                KmzExporter exporter = new KmzExporter();
                exporter.export(kmlFeature, zipStream, pm);
            }
            return null;
        }

        protected void done() {
            Throwable exception = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                exception = e;
            }
            catch (ExecutionException e) {
                exception = e.getCause();
            }
            if (exception != null) {
                String message = String.format("Error occurred while exporting to KMZ.%n%s", exception.getMessage());
                SnapDialogs.showError((String)this.title, (String)message);
            }
        }
    }
}

