/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.export.animations;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.timeseries.export.util.TimeSeriesExportHelper;
import org.esa.snap.util.io.BeamFileFilter;
import org.w3c.dom.Node;

public class AnimatedGifExport
extends ProgressMonitorSwingWorker<Void, Void> {
    private final File outputFile;
    private static final String EXPORT_DIR_PREFERENCES_KEY = "user.export.dir";
    private RenderedImage[] frames;
    private int level;

    public AnimatedGifExport(Component parentComponent, String title) {
        super(parentComponent, title);
        TimeSeriesExportHelper.FileWithLevel fileWithLevel = this.fetchOutputFile();
        this.outputFile = fileWithLevel.file;
        this.level = fileWithLevel.level;
    }

    protected Void doInBackground(ProgressMonitor pm) throws Exception {
        this.exportAnimation("50", this.outputFile, pm);
        return null;
    }

    public void createFrames(List<Band> bandsForVariable) {
        ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
        for (Band band : bandsForVariable) {
            images.add(band.getGeophysicalImage().getImage(this.level));
        }
        this.frames = images.toArray(new RenderedImage[images.size()]);
    }

    private void exportAnimation(String delayTime, File file, ProgressMonitor pm) {
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("gif").next();
        try {
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(outputStream);
            imageWriter.prepareWriteSequence(null);
            pm.beginTask("Exporting time series as animated gif", this.frames.length);
            for (int i = 0; i < this.frames.length; ++i) {
                RenderedImage currentImage = this.frames[i];
                ImageWriteParam writeParameters = imageWriter.getDefaultWriteParam();
                IIOMetadata metadata = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(currentImage), writeParameters);
                AnimatedGifExport.configure(metadata, delayTime, i);
                IIOImage image = new IIOImage(currentImage, null, metadata);
                imageWriter.writeToSequence(image, null);
                pm.worked(1);
            }
            imageWriter.endWriteSequence();
            outputStream.close();
            pm.done();
        }
        catch (IOException e) {
            SnapApp.getDefault().handleError("Unable to create animated gif", (Throwable)e);
        }
    }

    private static void configure(IIOMetadata meta, String delayTime, int imageIndex) {
        String metaFormat = meta.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(metaFormat)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + metaFormat);
        }
        Node root = meta.getAsTree(metaFormat);
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!"GraphicControlExtension".equals(child.getNodeName())) continue;
            IIOMetadataNode gce = (IIOMetadataNode)child;
            gce.setAttribute("userInputFlag", "FALSE");
            gce.setAttribute("delayTime", delayTime);
            break;
        }
        if (imageIndex == 0) {
            IIOMetadataNode parentNode = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode childNode = new IIOMetadataNode("ApplicationExtension");
            childNode.setAttribute("applicationID", "NETSCAPE");
            childNode.setAttribute("authenticationCode", "2.0");
            byte[] userObject = new byte[]{1, 0, 0};
            childNode.setUserObject(userObject);
            parentNode.appendChild(childNode);
            root.appendChild(parentNode);
        }
        try {
            meta.setFromTree(metaFormat, root);
        }
        catch (IIOInvalidTreeException e) {
            SnapApp.getDefault().handleError(e.getMessage(), (Throwable)e);
        }
    }

    private TimeSeriesExportHelper.FileWithLevel fetchOutputFile() {
        RasterDataNode currentRaster = SnapApp.getDefault().getSelectedProductSceneView().getRaster();
        BeamFileFilter gifFilter = new BeamFileFilter("gif", "gif", "Animated GIF");
        return TimeSeriesExportHelper.getOutputFileWithLevelOption(currentRaster, "Export time series as animated GIF", "time_series_", EXPORT_DIR_PREFERENCES_KEY, gifFilter, null);
    }
}

