/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.ImageInfo;
import org.esa.snap.framework.datamodel.MetadataAttribute;
import org.esa.snap.framework.datamodel.MetadataElement;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.PlacemarkGroup;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.ProductNodeEvent;
import org.esa.snap.framework.datamodel.ProductNodeListener;
import org.esa.snap.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.framework.gpf.GPF;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.snap.timeseries.core.timeseries.datamodel.GridTimeCoding;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocationType;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesChangeEvent;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.util.Guardian;
import org.esa.snap.util.ProductUtils;
import org.esa.snap.util.StringUtils;
import org.esa.snap.util.SystemUtils;

final class TimeSeriesImpl
extends AbstractTimeSeries {
    private static final float LAT_LON_EPSILON = 1.0E-7f;
    private final Map<RasterDataNode, TimeCoding> rasterTimeMap = new WeakHashMap<RasterDataNode, TimeCoding>();
    private final List<TimeSeriesListener> listeners = new ArrayList<TimeSeriesListener>();
    private final AxisMapping axisMapping = new AxisMapping();
    private final Map<Placemark, GeoPos> pinRelationMap = new HashMap<Placemark, GeoPos>();
    private Product tsProduct;
    private List<ProductLocation> productLocationList;
    private Map<String, Product> productTimeMap;
    private InsituSource insituSource;
    private Set<String> insituVariablesSelections = new HashSet<String>();
    private volatile boolean isAdjustingImageInfos;

    TimeSeriesImpl(Product tsProduct, ProgressMonitor pm) {
        this.init(tsProduct);
        this.initProductLocations();
        this.storeProductsInMap(pm);
        this.setSourceImages();
        this.fixBandTimeCodings();
        this.updateAutoGrouping();
        this.initImageInfos();
    }

    TimeSeriesImpl(Product tsProduct, List<ProductLocation> productLocations, List<String> variableNames) {
        this.init(tsProduct);
        for (ProductLocation location : productLocations) {
            this.addProductLocation(location);
        }
        this.storeProductsInMap(ProgressMonitor.NULL);
        for (String variable : variableNames) {
            this.setEoVariableSelected(variable, true);
        }
        this.setProductTimeCoding(tsProduct);
        this.initImageInfos();
    }

    @Override
    public Product getTsProduct() {
        return this.tsProduct;
    }

    @Override
    public List<ProductLocation> getProductLocations() {
        return this.productLocationList;
    }

    private void initProductLocations() {
        MetadataElement tsElem = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES");
        MetadataElement productListElem = tsElem.getElement("PRODUCT_LOCATIONS");
        MetadataElement[] productElems = productListElem.getElements();
        this.productLocationList = new ArrayList<ProductLocation>(productElems.length);
        File fileLocation = this.tsProduct.getProduct().getFileLocation();
        for (MetadataElement productElem : productElems) {
            File productFile;
            String path = productElem.getAttributeString("PATH");
            if (fileLocation != null) {
                URI resolvedUri = fileLocation.toURI().resolve(path);
                productFile = new File(resolvedUri);
            } else {
                productFile = new File(path);
            }
            String type = productElem.getAttributeString("TYPE");
            this.productLocationList.add(new ProductLocation(ProductLocationType.valueOf(type), productFile.getAbsolutePath()));
        }
    }

    @Override
    public List<String> getEoVariables() {
        MetadataElement[] variableElems = this.getVariableMetadataElements();
        ArrayList<String> variables = new ArrayList<String>();
        for (MetadataElement varElem : variableElems) {
            variables.add(varElem.getAttributeString("NAME"));
        }
        return variables;
    }

    @Override
    public void addProductLocation(ProductLocation productLocation) {
        if (this.productLocationList == null) {
            this.productLocationList = new ArrayList<ProductLocation>();
        }
        if (!this.productLocationList.contains(productLocation)) {
            Logger logger = SystemUtils.LOG;
            ProductLocationType type = productLocation.getProductLocationType();
            String path = productLocation.getPath();
            logger.log(Level.INFO, "Try to load product location type: '" + (Object)((Object)type) + "' at path: '" + path + "'");
            this.addProductLocationMetadata(productLocation);
            this.productLocationList.add(productLocation);
            List<String> variables = this.getEoVariables();
            Map<String, Product> products = productLocation.getProducts(ProgressMonitor.NULL);
            for (Map.Entry<String, Product> productEntry : products.entrySet()) {
                Product product = productEntry.getValue();
                if (product.getStartTime() != null) {
                    this.addProductMetadata(productEntry);
                    this.addToVariableList(product);
                    for (String variable : variables) {
                        if (!this.isEoVariableSelected(variable)) continue;
                        this.addSpecifiedBandOfGivenProduct(variable, product);
                    }
                    continue;
                }
                String absolutePath = product.getFileLocation().getAbsolutePath();
                logger.log(Level.WARNING, "The product '" + absolutePath + "' does not contain time information.");
            }
            this.fireChangeEvent(new TimeSeriesChangeEvent(8, this.productLocationList, this));
        }
    }

    private void addProductMetadata(Map.Entry<String, Product> productEntry) {
        MetadataElement productElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES").getElement("SOURCE_PRODUCT_PATHS");
        ProductData productPath = ProductData.createInstance((String)productEntry.getKey());
        int length = productElement.getElements().length + 1;
        MetadataElement elem = new MetadataElement(String.format("%s.%s", "SOURCE_PRODUCT_PATHS", Integer.toString(length)));
        elem.addAttribute(new MetadataAttribute("PATH", productPath, true));
        productElement.addElement(elem);
    }

    @Override
    public void removeProductLocation(ProductLocation productLocation) {
        MetadataElement timeSeriesRootElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES");
        MetadataElement productLocationsElement = timeSeriesRootElement.getElement("PRODUCT_LOCATIONS");
        this.removeAttributeWithValue("PATH", productLocation.getPath(), productLocationsElement);
        this.updateAutoGrouping();
        Band[] bands = this.tsProduct.getBands();
        MetadataElement sourceProductPaths = timeSeriesRootElement.getElement("SOURCE_PRODUCT_PATHS");
        for (Map.Entry<String, Product> productEntry : productLocation.getProducts(ProgressMonitor.NULL).entrySet()) {
            Product product = productEntry.getValue();
            this.removeAttributeWithValue("PATH", productEntry.getKey(), sourceProductPaths);
            String timeString = TimeSeriesImpl.formatTimeString(product);
            this.productTimeMap.remove(timeString);
            for (Band band : bands) {
                if (!band.getName().endsWith(timeString)) continue;
                this.tsProduct.removeBand(band);
            }
        }
        productLocation.closeProducts();
        this.productLocationList.remove(productLocation);
        this.fireChangeEvent(new TimeSeriesChangeEvent(8, this.productLocationList, this));
    }

    private void removeAttributeWithValue(String attributeName, String value, MetadataElement parentElement) {
        MetadataElement[] childElements;
        for (MetadataElement elem : childElements = parentElement.getElements()) {
            if (!elem.getAttributeString(attributeName).equals(value)) continue;
            parentElement.removeElement(elem);
            return;
        }
    }

    private Band getSourceBand(String destBandName) {
        int lastUnderscore = destBandName.lastIndexOf("_");
        String normalizedBandName = destBandName.substring(0, lastUnderscore);
        String timePart = destBandName.substring(lastUnderscore + 1);
        Product srcProduct = this.productTimeMap.get(timePart);
        if (srcProduct == null) {
            return null;
        }
        for (Band band : srcProduct.getBands()) {
            if (!normalizedBandName.equals(band.getName())) continue;
            return band;
        }
        return null;
    }

    private void setSourceImages() {
        for (Band destBand : this.tsProduct.getBands()) {
            Band raster = this.getSourceBand(destBand.getName());
            if (raster == null) continue;
            destBand.setSourceImage(raster.getSourceImage());
        }
    }

    private void fixBandTimeCodings() {
        for (Band destBand : this.tsProduct.getBands()) {
            TimeCoding timeCoding;
            String destBandName = destBand.getName();
            Band raster = this.getSourceBand(destBandName);
            if (raster != null) {
                timeCoding = GridTimeCoding.create(raster.getProduct());
            } else {
                ProductData.UTC time = this.extractUtcTime(destBandName);
                timeCoding = new GridTimeCoding(time, time);
            }
            this.rasterTimeMap.put((RasterDataNode)destBand, timeCoding);
        }
    }

    private ProductData.UTC extractUtcTime(String name) {
        String timePart = name.substring(name.length() - "yyyyMMdd.HHmmss.SSS".length());
        try {
            return ProductData.UTC.parse((String)timePart, (String)"yyyyMMdd.HHmmss.SSS".substring(0, "yyyyMMdd.HHmmss.SSS".lastIndexOf(".")));
        }
        catch (ParseException e) {
            throw new IllegalStateException("The raster name '" + name + "' does not contain the time sequence. " + "yyyyMMdd.HHmmss.SSS");
        }
    }

    private void init(Product product) {
        this.tsProduct = product;
        this.productTimeMap = new HashMap<String, Product>();
        TimeSeriesImpl.createTimeSeriesMetadataStructure(product);
        this.tsProduct.addProductNodeListener((ProductNodeListener)new SourceImageReconstructor());
        this.axisMapping.addAxisMappingListener(new AxisMappingListener());
    }

    private void storeProductsInMap(ProgressMonitor pm) {
        pm.beginTask("Loading time series...", 2);
        try {
            List<Product> allProducts = this.getAllProducts((ProgressMonitor)new SubProgressMonitor(pm, 1));
            this.reprojectProducts(allProducts, (ProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reprojectProducts(List<Product> allProducts, ProgressMonitor pm) {
        pm.beginTask("Reprojecting source products...", allProducts.size());
        try {
            for (Product product : allProducts) {
                if (pm.isCanceled()) {
                    return;
                }
                if (!product.isCompatibleProduct(this.tsProduct, 1.0E-7f)) {
                    HashMap<String, Product> productToBeReprojectedMap = new HashMap<String, Product>();
                    productToBeReprojectedMap.put("source", product);
                    productToBeReprojectedMap.put("collocateWith", this.tsProduct);
                    Product collocatedProduct = GPF.createProduct((String)"Reproject", this.createProjectionParameters(), productToBeReprojectedMap);
                    collocatedProduct.setStartTime(product.getStartTime());
                    collocatedProduct.setEndTime(product.getEndTime());
                    product = collocatedProduct;
                }
                this.productTimeMap.put(TimeSeriesImpl.formatTimeString(product), product);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private HashMap<String, Object> createProjectionParameters() {
        HashMap<String, Object> projParameters = new HashMap<String, Object>();
        projParameters.put("resamplingName", "Nearest");
        projParameters.put("includeTiePointGrids", false);
        return projParameters;
    }

    @Override
    public boolean isEoVariableSelected(String variableName) {
        MetadataElement[] variables;
        for (MetadataElement elem : variables = this.getVariableMetadataElements()) {
            if (!elem.getAttributeString("NAME").equals(variableName)) continue;
            return Boolean.parseBoolean(elem.getAttributeString("SELECTION"));
        }
        return false;
    }

    @Override
    public void setEoVariableSelected(String variableName, boolean selected) {
        MetadataElement[] variables = this.getVariableMetadataElements();
        for (MetadataElement elem : variables) {
            if (!elem.getAttributeString("NAME").equals(variableName)) continue;
            elem.setAttributeString("SELECTION", String.valueOf(selected));
        }
        if (selected) {
            for (Product product : this.getAllProducts(ProgressMonitor.NULL)) {
                this.addSpecifiedBandOfGivenProduct(variableName, product);
            }
        } else {
            Band[] bands;
            for (Band band : bands = this.tsProduct.getBands()) {
                if (!variableName.equals(TimeSeriesImpl.rasterToVariableName(band.getName()))) continue;
                this.tsProduct.removeBand(band);
            }
        }
        this.fireChangeEvent(new TimeSeriesChangeEvent(16, null, this));
    }

    @Override
    public boolean isInsituVariableSelected(String variableName) {
        return this.insituVariablesSelections.contains(variableName);
    }

    @Override
    public void setInsituVariableSelected(String variableName, boolean selected) {
        boolean hasChanged = selected ? this.insituVariablesSelections.add(variableName) : this.insituVariablesSelections.remove(variableName);
        if (hasChanged) {
            this.fireChangeEvent(new TimeSeriesChangeEvent(64, variableName, this));
        }
    }

    @Override
    public List<Band> getBandsForVariable(String variableName) {
        ArrayList<Band> bands = new ArrayList<Band>();
        for (Band band : this.tsProduct.getBands()) {
            if (!variableName.equals(TimeSeriesImpl.rasterToVariableName(band.getName()))) continue;
            bands.add(band);
        }
        this.sortBands(bands);
        return bands;
    }

    @Override
    public List<Band> getBandsForProductLocation(ProductLocation location) {
        ArrayList<Band> bands = new ArrayList<Band>();
        Map<String, Product> products = location.getProducts(ProgressMonitor.NULL);
        for (Product product : products.values()) {
            String timeString = TimeSeriesImpl.formatTimeString(product);
            for (Band band : this.tsProduct.getBands()) {
                if (!band.getName().endsWith(timeString)) continue;
                bands.add(band);
            }
        }
        return bands;
    }

    @Override
    public Map<RasterDataNode, TimeCoding> getRasterTimeMap() {
        return Collections.unmodifiableMap(this.rasterTimeMap);
    }

    @Override
    public boolean isAutoAdjustingTimeCoding() {
        MetadataElement tsRootElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES");
        if (!tsRootElement.containsAttribute("AUTO_ADJUSTING_TIME_CODING")) {
            this.setAutoAdjustingTimeCoding(true);
        }
        String autoAdjustString = tsRootElement.getAttributeString("AUTO_ADJUSTING_TIME_CODING");
        return Boolean.parseBoolean(autoAdjustString);
    }

    @Override
    public void setAutoAdjustingTimeCoding(boolean autoAdjust) {
        MetadataElement tsRootElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES");
        tsRootElement.setAttributeString("AUTO_ADJUSTING_TIME_CODING", Boolean.toString(autoAdjust));
    }

    @Override
    public boolean isProductCompatible(Product product, String rasterName) {
        return product.containsRasterDataNode(rasterName) && this.tsProduct.isCompatibleProduct(product, 1.0E-7f);
    }

    @Override
    public TimeCoding getTimeCoding() {
        return GridTimeCoding.create(this.tsProduct);
    }

    @Override
    public void setTimeCoding(TimeCoding timeCoding) {
        ProductData.UTC startTime = timeCoding.getStartTime();
        if (this.tsProduct.getStartTime().getAsCalendar().compareTo(startTime.getAsCalendar()) != 0) {
            this.tsProduct.setStartTime(startTime);
            this.fireChangeEvent(new TimeSeriesChangeEvent(2, startTime, this));
        }
        ProductData.UTC endTime = timeCoding.getEndTime();
        if (this.tsProduct.getEndTime().getAsCalendar().compareTo(endTime.getAsCalendar()) != 0) {
            this.tsProduct.setEndTime(endTime);
            this.fireChangeEvent(new TimeSeriesChangeEvent(4, endTime, this));
        }
        List<String> variables = this.getEoVariables();
        for (Product product : this.getAllProducts(ProgressMonitor.NULL)) {
            for (String variable : variables) {
                if (!this.isEoVariableSelected(variable)) continue;
                this.addSpecifiedBandOfGivenProduct(variable, product);
            }
        }
        for (Band band : this.tsProduct.getBands()) {
            TimeCoding bandTimeCoding = this.getRasterTimeMap().get(band);
            if (timeCoding.contains(bandTimeCoding)) continue;
            this.fireChangeEvent(new TimeSeriesChangeEvent(1, band, this));
            this.tsProduct.removeBand(band);
        }
    }

    @Override
    public void addTimeSeriesListener(TimeSeriesListener listener) {
        if (!this.listeners.contains((Object)listener)) {
            this.listeners.add(listener);
            this.tsProduct.addProductNodeListener((ProductNodeListener)listener);
        }
    }

    @Override
    public void removeTimeSeriesListener(TimeSeriesListener listener) {
        this.listeners.remove((Object)listener);
        this.tsProduct.removeProductNodeListener((ProductNodeListener)listener);
    }

    @Override
    public void setInsituSource(InsituSource insituSource) {
        if (this.insituSource != insituSource) {
            this.insituSource = insituSource;
            this.fireChangeEvent(new TimeSeriesChangeEvent(32, this, this));
        }
    }

    @Override
    public InsituSource getInsituSource() {
        return this.insituSource;
    }

    @Override
    public void clearInsituPlacemarks() {
        PlacemarkGroup pinGroup = this.tsProduct.getPinGroup();
        for (Placemark insituPin : this.pinRelationMap.keySet()) {
            pinGroup.remove(insituPin);
        }
        this.pinRelationMap.clear();
    }

    @Override
    public GeoPos getInsituGeoposFor(Placemark placemark) {
        return this.pinRelationMap.get(placemark);
    }

    @Override
    public void registerRelation(Placemark placemark, GeoPos insituGeopos) {
        this.pinRelationMap.put(placemark, insituGeopos);
        this.tsProduct.getPinGroup().add(placemark);
    }

    @Override
    public boolean hasInsituData() {
        return this.insituSource != null && !this.insituVariablesSelections.isEmpty();
    }

    @Override
    public Set<String> getSelectedInsituVariables() {
        return Collections.unmodifiableSet(this.insituVariablesSelections);
    }

    @Override
    public AxisMapping getAxisMapping() {
        return this.axisMapping;
    }

    private MetadataElement[] getVariableMetadataElements() {
        MetadataElement variableListElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES").getElement("VARIABLES");
        return variableListElement.getElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Product> getAllProducts(ProgressMonitor pm) {
        ArrayList<Product> result = new ArrayList<Product>();
        pm.beginTask("Scanning product locations ...", this.productLocationList.size());
        try {
            for (ProductLocation productLocation : this.productLocationList) {
                if (pm.isCanceled()) {
                    break;
                }
                for (Product product : productLocation.getProducts(ProgressMonitor.NULL).values()) {
                    result.add(product);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    private boolean isTimeCodingSet() {
        return this.tsProduct.getStartTime() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustImageInfos(RasterDataNode raster) {
        if (!this.isAdjustingImageInfos) {
            try {
                this.isAdjustingImageInfos = true;
                String variableName = AbstractTimeSeries.rasterToVariableName(raster.getName());
                List<Band> bandList = this.getBandsForVariable(variableName);
                ImageInfo imageInfo = raster.getImageInfo(ProgressMonitor.NULL);
                if (imageInfo != null) {
                    for (Band band : bandList) {
                        if (band == raster) continue;
                        band.setImageInfo(imageInfo.createDeepCopy());
                    }
                }
            }
            finally {
                this.isAdjustingImageInfos = false;
            }
        }
    }

    private void sortBands(List<Band> bandList) {
        Collections.sort(bandList, new Comparator<Band>(){

            @Override
            public int compare(Band band1, Band band2) {
                Date date1 = ((TimeCoding)TimeSeriesImpl.this.rasterTimeMap.get(band1)).getStartTime().getAsDate();
                Date date2 = ((TimeCoding)TimeSeriesImpl.this.rasterTimeMap.get(band2)).getStartTime().getAsDate();
                return date1.compareTo(date2);
            }
        });
    }

    private void updateAutoGrouping() {
        this.tsProduct.setAutoGrouping(StringUtils.join(this.getEoVariables(), (String)":"));
    }

    private void setProductTimeCoding(Product tsProduct) {
        for (Band band : tsProduct.getBands()) {
            ProductData.UTC rasterStartTime = this.getRasterTimeMap().get(band).getStartTime();
            ProductData.UTC rasterEndTime = this.getRasterTimeMap().get(band).getEndTime();
            ProductData.UTC tsStartTime = tsProduct.getStartTime();
            if (tsStartTime == null || rasterStartTime.getAsDate().before(tsStartTime.getAsDate())) {
                tsProduct.setStartTime(rasterStartTime);
            }
            ProductData.UTC tsEndTime = tsProduct.getEndTime();
            if (rasterEndTime == null || tsEndTime != null && !rasterEndTime.getAsDate().after(tsEndTime.getAsDate())) continue;
            tsProduct.setEndTime(rasterEndTime);
        }
    }

    private static void createTimeSeriesMetadataStructure(Product tsProduct) {
        if (!tsProduct.getMetadataRoot().containsElement("TIME_SERIES")) {
            MetadataElement timeSeriesRoot = new MetadataElement("TIME_SERIES");
            MetadataElement productListElement = new MetadataElement("PRODUCT_LOCATIONS");
            MetadataElement sourceProductPathsElement = new MetadataElement("SOURCE_PRODUCT_PATHS");
            MetadataElement variablesListElement = new MetadataElement("VARIABLES");
            timeSeriesRoot.addElement(productListElement);
            timeSeriesRoot.addElement(sourceProductPathsElement);
            timeSeriesRoot.addElement(variablesListElement);
            tsProduct.getMetadataRoot().addElement(timeSeriesRoot);
        }
    }

    private void addProductLocationMetadata(ProductLocation productLocation) {
        MetadataElement productLocationsElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES").getElement("PRODUCT_LOCATIONS");
        ProductData productPath = ProductData.createInstance((String)productLocation.getPath());
        ProductData productType = ProductData.createInstance((String)productLocation.getProductLocationType().toString());
        int length = productLocationsElement.getElements().length + 1;
        MetadataElement elem = new MetadataElement(String.format("%s.%s", "PRODUCT_LOCATIONS", Integer.toString(length)));
        elem.addAttribute(new MetadataAttribute("PATH", productPath, true));
        elem.addAttribute(new MetadataAttribute("TYPE", productType, true));
        productLocationsElement.addElement(elem);
    }

    private static String formatTimeString(Product product) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS", Locale.ENGLISH);
        ProductData.UTC startTime = product.getStartTime();
        return dateFormat.format(startTime.getAsDate());
    }

    private void addToVariableList(Product product) {
        ArrayList<String> newVariables = new ArrayList<String>();
        List<String> variables = this.getEoVariables();
        Band[] bands = product.getBands();
        for (Band band : bands) {
            String bandName = band.getName();
            boolean varExist = false;
            for (String variable : variables) {
                varExist |= variable.equals(bandName);
            }
            if (varExist) continue;
            newVariables.add(bandName);
        }
        for (String variable : newVariables) {
            this.addVariableToMetadata(variable);
        }
        if (!newVariables.isEmpty()) {
            this.updateAutoGrouping();
        }
    }

    private void addVariableToMetadata(String variable) {
        MetadataElement variableListElement = this.tsProduct.getMetadataRoot().getElement("TIME_SERIES").getElement("VARIABLES");
        ProductData variableName = ProductData.createInstance((String)variable);
        ProductData isSelected = ProductData.createInstance((String)Boolean.toString(false));
        int length = variableListElement.getElements().length + 1;
        MetadataElement elem = new MetadataElement(String.format("%s.%s", "VARIABLES", Integer.toString(length)));
        elem.addAttribute(new MetadataAttribute("NAME", variableName, true));
        elem.addAttribute(new MetadataAttribute("SELECTION", isSelected, true));
        variableListElement.addElement(elem);
    }

    private void addSpecifiedBandOfGivenProduct(String nodeName, Product product) {
        if (this.isProductCompatible(product, nodeName)) {
            RasterDataNode raster = product.getRasterDataNode(nodeName);
            TimeCoding rasterTimeCoding = GridTimeCoding.create(product);
            ProductData.UTC rasterStartTime = rasterTimeCoding.getStartTime();
            ProductData.UTC rasterEndTime = rasterTimeCoding.getEndTime();
            Guardian.assertNotNull((String)"rasterStartTime", (Object)rasterStartTime);
            String bandName = TimeSeriesImpl.variableToRasterName(nodeName, rasterTimeCoding);
            if (!this.tsProduct.containsBand(bandName)) {
                if (this.isAutoAdjustingTimeCoding() || !this.isTimeCodingSet()) {
                    this.autoAdjustTimeInformation(rasterStartTime, rasterEndTime);
                }
                if (this.getTimeCoding().contains(rasterTimeCoding)) {
                    Band addedBand = this.addBand(raster, rasterTimeCoding, bandName);
                    List<Band> bandsForVariable = this.getBandsForVariable(nodeName);
                    if (!bandsForVariable.isEmpty()) {
                        ImageInfo imageInfo = bandsForVariable.get(0).getImageInfo(ProgressMonitor.NULL);
                        addedBand.setImageInfo(imageInfo.createDeepCopy());
                    }
                }
            }
        }
    }

    private Band addBand(RasterDataNode raster, TimeCoding rasterTimeCoding, String bandName) {
        Band band = new Band(bandName, raster.getDataType(), this.tsProduct.getSceneRasterWidth(), this.tsProduct.getSceneRasterHeight());
        band.setSourceImage(raster.getSourceImage());
        ProductUtils.copyRasterDataNodeProperties((RasterDataNode)raster, (RasterDataNode)band);
        band.setValidPixelExpression(null);
        this.rasterTimeMap.put((RasterDataNode)band, rasterTimeCoding);
        this.tsProduct.addBand(band);
        return band;
    }

    private void autoAdjustTimeInformation(ProductData.UTC rasterStartTime, ProductData.UTC rasterEndTime) {
        ProductData.UTC tsEndTime;
        ProductData.UTC tsStartTime = this.tsProduct.getStartTime();
        if (tsStartTime == null || rasterStartTime.getAsDate().before(tsStartTime.getAsDate())) {
            this.tsProduct.setStartTime(rasterStartTime);
        }
        if ((tsEndTime = this.tsProduct.getEndTime()) == null || rasterEndTime.getAsDate().after(tsEndTime.getAsDate())) {
            this.tsProduct.setEndTime(rasterEndTime);
        }
    }

    private void initImageInfos() {
        for (String variable : this.getEoVariables()) {
            if (!this.isEoVariableSelected(variable)) continue;
            List<Band> bandList = this.getBandsForVariable(variable);
            this.adjustImageInfos((RasterDataNode)bandList.get(0));
        }
    }

    private void fireChangeEvent(TimeSeriesChangeEvent event) {
        ArrayList<TimeSeriesListener> listenersCopy = new ArrayList<TimeSeriesListener>();
        listenersCopy.addAll(this.listeners);
        for (TimeSeriesListener listener : listenersCopy) {
            listener.timeSeriesChanged(event);
        }
    }

    @Override
    public Product[] getSourceProducts() {
        Collection<Product> values = this.productTimeMap.values();
        return values.toArray(new Product[values.size()]);
    }

    @Override
    public void dispose() {
        this.productTimeMap.clear();
        this.productTimeMap = null;
        this.listeners.clear();
        this.pinRelationMap.clear();
        this.tsProduct = null;
        if (this.productLocationList != null) {
            this.productLocationList.clear();
            this.productLocationList = null;
        }
        this.insituSource = null;
        this.insituVariablesSelections.clear();
        this.insituVariablesSelections = null;
    }

    private class AxisMappingListener
    implements AxisMapping.AxisMappingListener {
        private AxisMappingListener() {
        }

        @Override
        public void hasChanged() {
            TimeSeriesImpl.this.fireChangeEvent(new TimeSeriesChangeEvent(128, null, TimeSeriesImpl.this));
        }
    }

    private class SourceImageReconstructor
    extends ProductNodeListenerAdapter {
        private SourceImageReconstructor() {
        }

        public void nodeChanged(ProductNodeEvent event) {
            Band destBand;
            Band sourceBand;
            ProductNode productNode;
            if ("sourceImage".equals(event.getPropertyName()) && event.getOldValue() != null && event.getNewValue() == null && (productNode = event.getSourceNode()) instanceof Band && (sourceBand = TimeSeriesImpl.this.getSourceBand((destBand = (Band)productNode).getName())) != null) {
                destBand.setSourceImage(sourceBand.getSourceImage());
            }
            if ("imageInfo".equals(event.getPropertyName()) && event.getSourceNode() instanceof RasterDataNode) {
                TimeSeriesImpl.this.adjustImageInfos((RasterDataNode)event.getSourceNode());
            }
        }
    }
}

