/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesImpl;
import org.esa.snap.util.ProductUtils;

public class TimeSeriesFactory {
    private TimeSeriesFactory() {
    }

    public static AbstractTimeSeries create(Product product, ProgressMonitor pm) {
        TimeSeriesImpl timeSeries = new TimeSeriesImpl(product, pm);
        TimeSeriesMapper.getInstance().put(product, timeSeries);
        return timeSeries;
    }

    public static AbstractTimeSeries create(String timeSeriesName, List<ProductLocation> productLocations, List<String> variableNames) {
        try {
            Assert.notNull(productLocations, (String)"productLocations");
            Assert.argument((productLocations.size() > 0 ? 1 : 0) != 0, (String)"productLocations must contain at least one location.");
            Assert.notNull(variableNames, (String)"variableNames");
            Assert.argument((variableNames.size() > 0 ? 1 : 0) != 0, (String)"variableNames must contain at least one variable name.");
            Assert.argument((timeSeriesName != null && timeSeriesName.trim().length() > 0 ? 1 : 0) != 0, (String)"timeSeriesName must not be null or empty.");
            if (TimeSeriesFactory.noSourceProductsAvailable(productLocations)) {
                return null;
            }
            Product referenceProduct = TimeSeriesFactory.getFirstReprojectedSourceProduct(productLocations);
            Product timeSeriesProduct = new Product(timeSeriesName, "org.esa.snap.glob.timeseries", referenceProduct.getSceneRasterWidth(), referenceProduct.getSceneRasterHeight());
            timeSeriesProduct.setDescription("A time series product");
            ProductUtils.copyGeoCoding((Product)referenceProduct, (Product)timeSeriesProduct);
            timeSeriesProduct.setPreferredTileSize(referenceProduct.getPreferredTileSize());
            TimeSeriesImpl timeSeries = new TimeSeriesImpl(timeSeriesProduct, productLocations, variableNames);
            TimeSeriesMapper.getInstance().put(timeSeriesProduct, timeSeries);
            return timeSeries;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Product getFirstReprojectedSourceProduct(List<ProductLocation> productLocations) {
        ProductLocation firstLocation = productLocations.get(0);
        return firstLocation.getProducts(ProgressMonitor.NULL).values().iterator().next();
    }

    private static boolean noSourceProductsAvailable(List<ProductLocation> productLocations) {
        HashMap<String, Product> productList = new HashMap<String, Product>();
        for (ProductLocation productLocation : productLocations) {
            productList.putAll(productLocation.getProducts(ProgressMonitor.NULL));
        }
        return productList.isEmpty();
    }
}

