/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import java.util.Date;
import org.esa.snap.framework.datamodel.PixelPos;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.util.Guardian;

public abstract class TimeCoding {
    private final ProductData.UTC startTime;
    private final ProductData.UTC endTime;

    protected TimeCoding(ProductData.UTC startTime, ProductData.UTC endTime) {
        Guardian.assertNotNull((String)"startTime", (Object)startTime);
        Guardian.assertNotNull((String)"endTime", (Object)endTime);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public abstract ProductData.UTC getTime(PixelPos var1);

    public ProductData.UTC getStartTime() {
        return this.startTime;
    }

    public ProductData.UTC getEndTime() {
        return this.endTime;
    }

    public boolean contains(TimeCoding timeCoding) {
        Date thisStartDate = this.getStartTime().getAsDate();
        Date thisEndDate = this.getEndTime().getAsDate();
        Date otherStartDate = timeCoding.getStartTime().getAsDate();
        Date otherEndDate = timeCoding.getEndTime().getAsDate();
        return !thisStartDate.after(otherStartDate) && !thisEndDate.before(otherEndDate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCoding that = (TimeCoding)o;
        boolean startEqual = this.areEqual(this.startTime, that.startTime);
        boolean endEqual = this.areEqual(this.endTime, that.endTime);
        return startEqual && endEqual;
    }

    private boolean areEqual(ProductData.UTC time1, ProductData.UTC time2) {
        return time1.getAsDate().getTime() == time2.getAsDate().getTime();
    }

    public int hashCode() {
        return 31 * this.startTime.hashCode() + this.endTime.hashCode();
    }
}

