/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.esa.snap.framework.dataio.ProductIO;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.timeseries.datamodel.DateRangeParser;
import org.esa.snap.util.SystemUtils;

public enum ProductLocationType {
    FILE{

        @Override
        public Map<String, Product> findProducts(String path, ProgressMonitor pm) {
            HashMap<String, Product> result = new HashMap<String, Product>();
            ProductLocationType.addProductToResult(result, new File(path));
            return result;
        }
    }
    ,
    DIRECTORY{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Product> findProducts(String path, ProgressMonitor pm) {
            File[] files = ProductLocationType.listFiles(path);
            HashMap<String, Product> result = new HashMap<String, Product>();
            pm.beginTask("Scanning for products...", files.length);
            try {
                for (File file : files) {
                    if (!file.isDirectory()) {
                        ProductLocationType.addProductToResult(result, file);
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
            return result;
        }
    }
    ,
    DIRECTORY_REC{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Product> findProducts(String path, ProgressMonitor pm) {
            File[] files = ProductLocationType.listFiles(path);
            HashMap<String, Product> result = new HashMap<String, Product>();
            pm.beginTask("Scanning for products...", files.length);
            try {
                for (File file : files) {
                    if (file.isDirectory()) {
                        result.putAll(this.findProducts(file.getPath(), (ProgressMonitor)new SubProgressMonitor(pm, 1)));
                        continue;
                    }
                    ProductLocationType.addProductToResult(result, file);
                }
            }
            finally {
                pm.done();
            }
            return result;
        }
    };


    abstract Map<String, Product> findProducts(String var1, ProgressMonitor var2);

    private static void addProductToResult(Map<String, Product> result, File file) {
        try {
            Product product = ProductLocationType.readSingleProduct(file);
            ProductLocationType.putIfNotNull(result, product);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void putIfNotNull(Map<String, Product> result, Product product) {
        if (product != null) {
            result.put(product.getFileLocation().getAbsolutePath(), product);
        }
    }

    private static File[] listFiles(String path) {
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The given path is not a directory: " + path);
        }
        return dir.listFiles();
    }

    private static Product readSingleProduct(File path) throws IOException {
        Product product = ProductIO.readProduct((File)path);
        if (product == null) {
            return null;
        }
        if (product.getStartTime() != null) {
            return product;
        }
        String productName = product.getName();
        try {
            ProductData.UTC[] utcs = DateRangeParser.tryToGetDateRange(productName);
            product.setStartTime(utcs[0]);
            product.setEndTime(utcs[1]);
            return product;
        }
        catch (IllegalArgumentException e) {
            SystemUtils.LOG.log(Level.WARNING, "Product '" + productName + "' does not contain readable time information.", e);
            return null;
        }
    }
}

