/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import java.util.Map;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocationType;

public class ProductLocation {
    private final ProductLocationType productLocationType;
    private final String path;
    private Map<String, Product> products;

    public ProductLocation(ProductLocationType productLocationType, String path) {
        this.productLocationType = productLocationType;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public ProductLocationType getProductLocationType() {
        return this.productLocationType;
    }

    public synchronized void loadProducts(ProgressMonitor pm) {
        this.products = this.productLocationType.findProducts(this.path, pm);
    }

    public Map<String, Product> getProducts(ProgressMonitor pm) {
        if (this.products == null) {
            this.loadProducts(pm);
        }
        return this.products;
    }

    public synchronized void closeProducts() {
        if (this.products != null) {
            for (Product product : this.products.values()) {
                product.dispose();
            }
            this.products = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductLocation that = (ProductLocation)o;
        return this.path.equals(that.path) && this.productLocationType == that.productLocationType;
    }

    public int hashCode() {
        int result = this.productLocationType.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

