/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import org.esa.snap.framework.datamodel.PixelPos;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;

public class GridTimeCoding
extends TimeCoding {
    private GridTimeCoding(ProductData.UTC timePoint) {
        super(timePoint, timePoint);
    }

    public GridTimeCoding(ProductData.UTC startTime, ProductData.UTC endTime) {
        super(startTime, endTime);
    }

    @Override
    public ProductData.UTC getTime(PixelPos pos) {
        ProductData.UTC startTime = this.getStartTime();
        ProductData.UTC endTime = this.getEndTime();
        double dStart = startTime.getMJD();
        double dEnd = endTime.getMJD();
        double dCentral = (dEnd - dStart) / 2.0;
        return new ProductData.UTC(dCentral);
    }

    public static TimeCoding create(Product product) {
        ProductData.UTC startTime = product.getStartTime();
        ProductData.UTC endTime = product.getEndTime();
        if (endTime != null) {
            return new GridTimeCoding(startTime, endTime);
        }
        return new GridTimeCoding(startTime);
    }
}

