/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.framework.datamodel.ProductData;

class DateRangeParser {
    DateRangeParser() {
    }

    static ProductData.UTC[] tryToGetDateRange(String productName) {
        String singleDateMonthPattern = "\\d{6}_.*";
        String startEndPattern = "\\d{8}_\\d{8}_.*";
        String singleDateDayPattern = "\\d{8}_.*";
        String singleDateDayPattern_leadingCharacters = ".*_\\d{8}_.*";
        if (productName.matches("\\d{6}_.*")) {
            return DateRangeParser.parseSingleMonthDate(productName);
        }
        if (productName.matches("\\d{8}_\\d{8}_.*")) {
            return DateRangeParser.parseStartEndDate(productName);
        }
        if (productName.matches("\\d{8}_.*")) {
            return DateRangeParser.parseSingleDayDate(productName);
        }
        if (productName.matches(".*_\\d{8}_.*")) {
            return DateRangeParser.parseSingleDayDate(productName);
        }
        throw new IllegalArgumentException("Unable to derive date from product name '" + productName + "'.");
    }

    private static ProductData.UTC[] parseSingleMonthDate(String productName) {
        return DateRangeParser.parseSingleDayDate(productName, "yyyyMM");
    }

    private static ProductData.UTC[] parseSingleDayDate(String productName) {
        return DateRangeParser.parseSingleDayDate(productName, "yyyyMMdd");
    }

    private static ProductData.UTC[] parseSingleDayDate(String productName, String pattern) {
        int beginIndex = DateRangeParser.findPatternStart(productName, pattern);
        return DateRangeParser.parseSingleDayDate(productName, pattern, beginIndex);
    }

    private static int findPatternStart(String productName, String pattern) {
        String regex = "\\d{" + pattern.length() + "}";
        Matcher matcher = Pattern.compile(regex).matcher(productName);
        matcher.find();
        return matcher.start();
    }

    private static ProductData.UTC[] parseSingleDayDate(String productName, String pattern, int beginIndex) {
        try {
            String dayDate = productName.substring(beginIndex, beginIndex + pattern.length());
            ProductData.UTC startTime = ProductData.UTC.parse((String)dayDate, (String)pattern);
            return new ProductData.UTC[]{startTime, startTime};
        }
        catch (ParseException parseException) {
            return new ProductData.UTC[2];
        }
    }

    private static ProductData.UTC[] parseStartEndDate(String productName) {
        try {
            String startDay = productName.substring(0, 8);
            String endDay = productName.substring(9, 17);
            return new ProductData.UTC[]{ProductData.UTC.parse((String)startDay, (String)"yyyyMMdd"), ProductData.UTC.parse((String)endDay, (String)"yyyyMMdd")};
        }
        catch (ParseException parseException) {
            return new ProductData.UTC[2];
        }
    }
}

