/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.esa.snap.framework.datamodel.Band;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.PixelPos;
import org.esa.snap.framework.datamodel.Placemark;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeCoding;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesListener;
import org.esa.snap.util.Guardian;

public abstract class AbstractTimeSeries {
    static final String DATE_FORMAT = "yyyyMMdd.HHmmss.SSS";
    static final String SEPARATOR = "_";
    public static final String TIME_SERIES_PRODUCT_TYPE = "org.esa.snap.glob.timeseries";
    public static final String TIME_SERIES_ROOT_NAME = "TIME_SERIES";
    public static final String PRODUCT_LOCATIONS = "PRODUCT_LOCATIONS";
    public static final String SOURCE_PRODUCT_PATHS = "SOURCE_PRODUCT_PATHS";
    public static final String VARIABLE_NAME = "NAME";
    public static final String AUTO_ADJUSTING_TIME_CODING = "AUTO_ADJUSTING_TIME_CODING";
    public static final String VARIABLE_SELECTION = "SELECTION";
    public static final String PL_PATH = "PATH";
    public static final String PL_TYPE = "TYPE";
    public static final String VARIABLES = "VARIABLES";

    public static boolean isPixelValid(Product tsProduct, PixelPos pixelPos) {
        return pixelPos.isValid() && pixelPos.x < (double)tsProduct.getSceneRasterWidth() && pixelPos.x >= 0.0 && pixelPos.y < (double)tsProduct.getSceneRasterHeight() && pixelPos.y >= 0.0;
    }

    public abstract List<String> getEoVariables();

    public abstract List<ProductLocation> getProductLocations();

    public abstract void addProductLocation(ProductLocation var1);

    public abstract void removeProductLocation(ProductLocation var1);

    public abstract boolean isEoVariableSelected(String var1);

    public abstract void setEoVariableSelected(String var1, boolean var2);

    public abstract boolean isInsituVariableSelected(String var1);

    public abstract void setInsituVariableSelected(String var1, boolean var2);

    public abstract Product getTsProduct();

    public abstract List<Band> getBandsForVariable(String var1);

    public abstract List<Band> getBandsForProductLocation(ProductLocation var1);

    public abstract Map<RasterDataNode, TimeCoding> getRasterTimeMap();

    public abstract boolean isAutoAdjustingTimeCoding();

    public abstract void setAutoAdjustingTimeCoding(boolean var1);

    public abstract TimeCoding getTimeCoding();

    public abstract void setTimeCoding(TimeCoding var1);

    public abstract void addTimeSeriesListener(TimeSeriesListener var1);

    public abstract void removeTimeSeriesListener(TimeSeriesListener var1);

    public abstract boolean isProductCompatible(Product var1, String var2);

    public abstract void setInsituSource(InsituSource var1);

    public abstract InsituSource getInsituSource();

    public abstract void clearInsituPlacemarks();

    public abstract GeoPos getInsituGeoposFor(Placemark var1);

    public abstract void registerRelation(Placemark var1, GeoPos var2);

    public static String variableToRasterName(String variableName, TimeCoding timeCoding) {
        ProductData.UTC rasterStartTime = timeCoding.getStartTime();
        Guardian.assertNotNull((String)"rasterStartTime", (Object)rasterStartTime);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        return variableName + SEPARATOR + dateFormat.format(rasterStartTime.getAsDate());
    }

    public static String rasterToVariableName(String rasterName) {
        int lastSeparator = rasterName.lastIndexOf(SEPARATOR);
        return rasterName.substring(0, lastSeparator);
    }

    public abstract boolean hasInsituData();

    public abstract Set<String> getSelectedInsituVariables();

    public abstract AxisMapping getAxisMapping();

    public abstract Product[] getSourceProducts();

    public abstract void dispose();
}

