/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.insitu.csv;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.timeseries.core.insitu.Header;
import org.esa.snap.timeseries.core.insitu.Record;
import org.esa.snap.timeseries.core.insitu.RecordSource;
import org.esa.snap.timeseries.core.insitu.csv.DefaultHeader;
import org.esa.snap.timeseries.core.insitu.csv.DefaultRecord;
import org.esa.snap.timeseries.core.insitu.csv.RecordIterator;

public class CsvRecordSource
implements RecordSource {
    private static final String[] LAT_NAMES = new String[]{"lat", "latitude", "northing"};
    private static final String[] LON_NAMES = new String[]{"lon", "long", "longitude", "easting"};
    private static final String[] TIME_NAMES = new String[]{"time", "date"};
    private static final String[] STATION_NAMES = new String[]{"name", "station", "label"};
    private final LineNumberReader reader;
    private final Header header;
    private final int recordLength;
    private final DateFormat dateFormat;
    private final int latIndex;
    private final int lonIndex;
    private final int timeIndex;
    private final int stationNameIndex;
    private final Class<?>[] attributeTypes;
    private Iterable<Record> recordIterable;
    private CsvRecordIterator csvRecordIterator;

    public CsvRecordSource(Reader reader, DateFormat dateFormat) throws IOException {
        this.reader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        this.dateFormat = dateFormat;
        String[] columnNames = this.readTextRecords(-1).get(0);
        this.attributeTypes = new Class[columnNames.length];
        this.latIndex = CsvRecordSource.indexOf(columnNames, LAT_NAMES);
        this.lonIndex = CsvRecordSource.indexOf(columnNames, LON_NAMES);
        this.timeIndex = CsvRecordSource.indexOf(columnNames, TIME_NAMES);
        this.stationNameIndex = CsvRecordSource.indexOf(columnNames, STATION_NAMES);
        String[] parameterNames = this.getParameterNames(columnNames);
        boolean hasLocation = this.latIndex >= 0 && this.lonIndex >= 0;
        boolean hasTime = this.timeIndex >= 0;
        boolean hasStationName = this.stationNameIndex >= 0;
        this.header = new DefaultHeader(hasLocation, hasTime, hasStationName, columnNames, parameterNames);
        this.recordLength = columnNames.length;
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public Iterable<Record> getRecords() {
        if (this.recordIterable == null) {
            this.recordIterable = this.createIterable();
        }
        if (this.csvRecordIterator != null) {
            this.csvRecordIterator.currentRecord = 0;
        }
        return this.recordIterable;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Iterable<Record> createIterable() {
        return () -> {
            if (this.csvRecordIterator == null) {
                try {
                    this.csvRecordIterator = new CsvRecordIterator(this.readTextRecords(this.recordLength));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return this.csvRecordIterator;
        };
    }

    private String[] getParameterNames(String[] columnNames) {
        int[] sortedIndices = new int[]{this.latIndex, this.lonIndex, this.timeIndex, this.stationNameIndex};
        Arrays.sort(sortedIndices);
        ArrayList parameterNames = new ArrayList();
        Collections.addAll(parameterNames, columnNames);
        for (int i = sortedIndices.length - 1; i >= 0; --i) {
            int index = sortedIndices[i];
            if (index <= -1) continue;
            parameterNames.remove(index);
        }
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    private static Object[] toObjects(String[] textValues, Class<?>[] types, DateFormat dateFormat) {
        Object[] values = new Object[textValues.length];
        for (int i = 0; i < textValues.length; ++i) {
            Object value;
            String text = textValues[i];
            if (text == null || text.isEmpty()) continue;
            Class<?> type = types[i];
            if (type != null) {
                value = CsvRecordSource.parse(text, type, dateFormat);
            } else {
                value = CsvRecordSource.parse(text, dateFormat);
                if (value != null) {
                    types[i] = value.getClass();
                }
            }
            values[i] = value;
        }
        return values;
    }

    private static int indexOf(String[] textValues, String[] possibleValues) {
        for (String possibleValue : possibleValues) {
            for (int index = 0; index < textValues.length; ++index) {
                if (!possibleValue.equalsIgnoreCase(textValues[index])) continue;
                return index;
            }
        }
        return -1;
    }

    private static String[] splitRecordLine(String line, int recordLength) {
        int pos2;
        int pos1 = 0;
        ArrayList<String> strings = new ArrayList<String>(256);
        while ((pos2 = line.indexOf(9, pos1)) >= 0) {
            strings.add(line.substring(pos1, pos2).trim());
            if (recordLength > 0 && strings.size() >= recordLength) break;
            pos1 = pos2 + 1;
        }
        strings.add(line.substring(pos1).trim());
        if (recordLength > 0) {
            return strings.toArray(new String[recordLength]);
        }
        return strings.toArray(new String[strings.size()]);
    }

    private List<String[]> readTextRecords(int recordLength) throws IOException {
        String line;
        ArrayList<String[]> result = new ArrayList<String[]>();
        while ((line = this.reader.readLine()) != null) {
            String trimLine = line.trim();
            if (trimLine.startsWith("#") || trimLine.isEmpty()) continue;
            result.add(CsvRecordSource.splitRecordLine(line, recordLength));
            if (recordLength >= 0) continue;
            return result;
        }
        return result;
    }

    private static Object parse(String text, Class<?> type, DateFormat dateFormat) {
        if (type.equals(Double.class)) {
            try {
                return CsvRecordSource.parseDouble(text);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (type.equals(String.class)) {
            return text;
        }
        if (type.equals(Date.class)) {
            try {
                return dateFormat.parse(text);
            }
            catch (ParseException e) {
                return new Date(0L);
            }
        }
        throw new IllegalStateException("Unhandled data type: " + type);
    }

    private static Object parse(String text, DateFormat dateFormat) {
        try {
            return CsvRecordSource.parseDouble(text);
        }
        catch (NumberFormatException e) {
            try {
                return dateFormat.parse(text);
            }
            catch (ParseException e1) {
                return text;
            }
        }
    }

    private static Double parseDouble(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            if (text.equalsIgnoreCase("nan")) {
                return Double.NaN;
            }
            if (text.equalsIgnoreCase("inf") || text.equalsIgnoreCase("infinity")) {
                return Double.POSITIVE_INFINITY;
            }
            if (text.equalsIgnoreCase("-inf") || text.equalsIgnoreCase("-infinity")) {
                return Double.NEGATIVE_INFINITY;
            }
            throw e;
        }
    }

    private class CsvRecordIterator
    extends RecordIterator {
        List<String[]> records;
        private int currentRecord = 0;

        private CsvRecordIterator(List<String[]> records) {
            this.records = records;
        }

        @Override
        protected Record getNextRecord() {
            if (this.records.size() <= this.currentRecord) {
                return null;
            }
            Object[] record = this.records.get(this.currentRecord);
            ++this.currentRecord;
            if (CsvRecordSource.this.getHeader().getColumnNames().length != record.length) {
                System.out.println("too few values " + Arrays.toString(record));
            }
            Object[] values = CsvRecordSource.toObjects((String[])record, CsvRecordSource.this.attributeTypes, CsvRecordSource.this.dateFormat);
            GeoPos location = CsvRecordSource.this.header.hasLocation() && values[CsvRecordSource.this.latIndex] instanceof Number && values[CsvRecordSource.this.lonIndex] instanceof Number ? new GeoPos((double)((Number)values[CsvRecordSource.this.latIndex]).floatValue(), (double)((Number)values[CsvRecordSource.this.lonIndex]).floatValue()) : null;
            Date time = CsvRecordSource.this.header.hasTime() && values[CsvRecordSource.this.timeIndex] instanceof Date ? (values[CsvRecordSource.this.timeIndex] instanceof Date ? (Date)values[CsvRecordSource.this.timeIndex] : null) : null;
            String stationName = CsvRecordSource.this.header.hasStationName() ? (String)values[CsvRecordSource.this.stationNameIndex] : (time != null ? time.toString() : "Unknown");
            return new DefaultRecord(location, time, stationName, values);
        }
    }
}

