/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.insitu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.timeseries.core.insitu.Header;
import org.esa.snap.timeseries.core.insitu.Record;
import org.esa.snap.timeseries.core.insitu.RecordSource;
import org.esa.snap.timeseries.core.insitu.csv.InsituRecord;
import org.esa.snap.util.StringUtils;

public class InsituSource {
    private RecordSource recordSource;

    public InsituSource(RecordSource recordSource) throws IOException {
        this.recordSource = recordSource;
    }

    public Collection<GeoPos> getInsituPositionsFor(String parameterName) {
        HashSet<GeoPos> result = new HashSet<GeoPos>();
        int columnIndex = this.getIndexForParameter(parameterName);
        Iterable<Record> records = this.recordSource.getRecords();
        for (Record record : records) {
            Double value = (Double)record.getAttributeValues()[columnIndex];
            if (value == null) continue;
            result.add(record.getLocation());
        }
        return result;
    }

    public InsituRecord[] getValuesFor(String parameterName, GeoPos position) {
        int columnIndex = this.getIndexForParameter(parameterName);
        Iterable<Record> records = this.recordSource.getRecords();
        ArrayList<InsituRecord> parameterRecords = new ArrayList<InsituRecord>();
        for (Record record : records) {
            GeoPos pos = record.getLocation();
            if (position != null && !pos.equals((Object)position)) continue;
            Date time = record.getTime();
            Double value = (Double)record.getAttributeValues()[columnIndex];
            if (value == null) continue;
            String stationName = record.getStationName() == null ? "" : record.getStationName();
            InsituRecord insituRecord = new InsituRecord(pos, time, stationName, value);
            parameterRecords.add(insituRecord);
        }
        this.sortRecordsAscending(parameterRecords);
        return parameterRecords.toArray(new InsituRecord[parameterRecords.size()]);
    }

    public boolean hasStationNames() {
        return this.recordSource.getHeader().hasStationName();
    }

    public String[] getParameterNames() {
        return this.recordSource.getHeader().getParameterNames();
    }

    public String getNameFor(GeoPos geoPos) {
        Iterable<Record> records = this.recordSource.getRecords();
        for (Record record : records) {
            if (!record.getLocation().equals((Object)geoPos)) continue;
            return record.getStationName();
        }
        return "";
    }

    public void close() {
        this.recordSource.close();
    }

    private int getIndexForParameter(String parameterName) {
        Header header = this.recordSource.getHeader();
        String[] columnNames = header.getColumnNames();
        return StringUtils.indexOf((String[])columnNames, (String)parameterName);
    }

    private void sortRecordsAscending(List<InsituRecord> parameterRecords) {
        Collections.sort(parameterRecords, new Comparator<InsituRecord>(){

            @Override
            public int compare(InsituRecord o1, InsituRecord o2) {
                if (o1.time.equals(o2.time)) {
                    return 0;
                }
                return o1.time.before(o2.time) ? -1 : 1;
            }
        });
    }
}

