/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.esa.snap.dataio.dimap.DimapProductReader;
import org.esa.snap.dataio.dimap.DimapProductReaderPlugIn;
import org.esa.snap.dataio.dimap.DimapProductWriter;
import org.esa.snap.dataio.dimap.DimapProductWriterPlugIn;
import org.esa.snap.framework.dataio.ProductIOPlugInManager;
import org.esa.snap.framework.datamodel.MetadataAttribute;
import org.esa.snap.framework.datamodel.MetadataElement;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.framework.datamodel.ProductManager;
import org.esa.snap.framework.datamodel.ProductNode;
import org.esa.snap.framework.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.SnapDialogs;
import org.esa.snap.timeseries.core.TimeSeriesMapper;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.TimeSeriesFactory;
import org.esa.snap.util.io.FileUtils;

public class TimeSeriesModule {
    public static final String TIME_PROPERTY = "timeProperty";
    private static final ProductManager.Listener productManagerListener = TimeSeriesModule.createProductManagerListener();
    private static final DimapProductWriter.WriterExtender writerExtender = TimeSeriesModule.createWriterExtender();
    private static final DimapProductReader.ReaderExtender readerExtender = TimeSeriesModule.createReaderExtender();

    static void convertAbsolutPathsToRelative(Product product, File outputDir) {
        MetadataElement tsRootElem = product.getMetadataRoot().getElement("TIME_SERIES");
        MetadataElement productLocations = tsRootElem.getElement("PRODUCT_LOCATIONS");
        MetadataElement sourceProductPaths = tsRootElem.getElement("SOURCE_PRODUCT_PATHS");
        TimeSeriesModule.replaceWithRelativePaths(productLocations.getElements(), outputDir);
        TimeSeriesModule.replaceWithRelativePaths(sourceProductPaths.getElements(), outputDir);
    }

    private static ProductManager.Listener createProductManagerListener() {
        return new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
            }

            public void productRemoved(ProductManager.Event event) {
                Product product = event.getProduct();
                if (product.getProductType().equals("org.esa.snap.glob.timeseries")) {
                    TimeSeriesMapper timeSeriesMapper = TimeSeriesMapper.getInstance();
                    AbstractTimeSeries timeSeries = timeSeriesMapper.getTimeSeries(product);
                    Product[] sourceProducts = timeSeries.getSourceProducts();
                    ProductManager productManager = SnapApp.getDefault().getProductManager();
                    for (Product sourceProduct : sourceProducts) {
                        if (productManager.contains(sourceProduct)) continue;
                        sourceProduct.dispose();
                    }
                    timeSeriesMapper.remove(product);
                }
            }
        };
    }

    private static DimapProductWriter.WriterExtender createWriterExtender() {
        return new DimapProductWriter.WriterExtender(){

            public boolean vetoableShouldWrite(ProductNode node) {
                if (!this.isTimeSerisProduct(node.getProduct())) {
                    return true;
                }
                return !(node instanceof RasterDataNode);
            }

            public void intendToWriteDimapHeaderTo(File outputDir, Product product) {
                if (this.isTimeSerisProduct(product)) {
                    TimeSeriesModule.convertAbsolutPathsToRelative(product, outputDir);
                }
            }

            private boolean isTimeSerisProduct(Product product) {
                return product.getProductType().equals("org.esa.snap.glob.timeseries");
            }
        };
    }

    private static void replaceWithRelativePaths(MetadataElement[] elements, File outputDir) {
        for (MetadataElement element : elements) {
            String pathName = element.getAttributeString("PATH");
            URI relativeUri = FileUtils.getRelativeUri((URI)outputDir.toURI(), (File)new File(pathName));
            MetadataAttribute pathAttr = element.getAttribute("PATH");
            MetadataAttribute typeAttr = element.getAttribute("TYPE");
            element.removeAttribute(pathAttr);
            element.removeAttribute(typeAttr);
            pathAttr.dispose();
            MetadataAttribute newPathAttr = new MetadataAttribute("PATH", ProductData.createInstance((String)relativeUri.toString()), true);
            element.addAttribute(newPathAttr);
            element.addAttribute(typeAttr);
        }
    }

    private static DimapProductReader.ReaderExtender createReaderExtender() {
        return new DimapProductReader.ReaderExtender(){

            public void completeProductNodesReading(final Product product) {
                if (product.getProductType().equals("org.esa.snap.glob.timeseries")) {
                    final SnapApp snapApp = SnapApp.getDefault();
                    Frame appWindow = snapApp.getMainFrame();
                    ProgressMonitorSwingWorker<AbstractTimeSeries, Void> pm = new ProgressMonitorSwingWorker<AbstractTimeSeries, Void>((Component)appWindow, "Creating Time Series..."){

                        protected void done() {
                            try {
                                this.get();
                            }
                            catch (InterruptedException e) {
                                this.handleError(e);
                            }
                            catch (ExecutionException e) {
                                this.handleError(e.getCause());
                            }
                            super.done();
                        }

                        private void handleError(Throwable theCause) {
                            snapApp.getLogger().log(Level.SEVERE, theCause.getMessage());
                            SnapDialogs.showError((String)"Could not load time series", (String)theCause.getMessage());
                        }

                        protected AbstractTimeSeries doInBackground(ProgressMonitor pm) throws Exception {
                            return TimeSeriesFactory.create(product, pm);
                        }
                    };
                    pm.executeWithBlocking();
                }
            }
        };
    }

    public static class StopOp
    implements Runnable {
        @Override
        public void run() {
            ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
            Iterator writerPlugIns = ioPlugInManager.getWriterPlugIns("BEAM-DIMAP");
            while (writerPlugIns.hasNext()) {
                DimapProductWriterPlugIn writerPlugIn = (DimapProductWriterPlugIn)writerPlugIns.next();
                writerPlugIn.removeWriterExtender(writerExtender);
            }
            Iterator readerPlugIns = ioPlugInManager.getReaderPlugIns("BEAM-DIMAP");
            while (readerPlugIns.hasNext()) {
                DimapProductReaderPlugIn readerPlugIn = (DimapProductReaderPlugIn)readerPlugIns.next();
                readerPlugIn.removeReaderExtender(readerExtender);
            }
            SnapApp.getDefault().getProductManager().removeListener(productManagerListener);
        }
    }

    public static class StartOp
    implements Runnable {
        @Override
        public void run() {
            ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
            Iterator allWriterPlugIns = ioPlugInManager.getWriterPlugIns("BEAM-DIMAP");
            while (allWriterPlugIns.hasNext()) {
                DimapProductWriterPlugIn writerPlugIn = (DimapProductWriterPlugIn)allWriterPlugIns.next();
                writerPlugIn.addWriterExtender(writerExtender);
            }
            Iterator readerPlugIns = ioPlugInManager.getReaderPlugIns("BEAM-DIMAP");
            while (readerPlugIns.hasNext()) {
                DimapProductReaderPlugIn readerPlugin = (DimapProductReaderPlugIn)readerPlugIns.next();
                readerPlugin.addReaderExtender(readerExtender);
            }
            SnapApp.getDefault().getProductManager().addListener(productManagerListener);
        }
    }
}

