/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.timeseries.core.timeseries.datamodel.AbstractTimeSeries;
import org.esa.snap.timeseries.core.timeseries.datamodel.ProductLocation;

public class TimeSeriesMapper {
    private final Map<Product, AbstractTimeSeries> map = new WeakHashMap<Product, AbstractTimeSeries>();

    private TimeSeriesMapper() {
    }

    public static TimeSeriesMapper getInstance() {
        return Holder.instance;
    }

    public void put(Product product, AbstractTimeSeries timeSeries) {
        this.map.put(product, timeSeries);
    }

    public void remove(Product product) {
        AbstractTimeSeries timeSeries = this.map.remove(product);
        if (timeSeries != null) {
            List<ProductLocation> locationList = timeSeries.getProductLocations();
            for (ProductLocation productLocation : locationList) {
                productLocation.closeProducts();
            }
            timeSeries.dispose();
        }
    }

    public AbstractTimeSeries getTimeSeries(Product product) {
        return this.map.get(product);
    }

    private static class Holder {
        private static final TimeSeriesMapper instance = new TimeSeriesMapper();

        private Holder() {
        }
    }
}

