/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.ui.graph;

import com.bc.jexp.ParseException;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.esa.snap.timeseries.ui.graph.TimeSeriesType;
import org.esa.snap.timeseries.ui.graph.TimeSeriesValidator;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeSeriesValidatorTest {
    private final TimeSeriesDataItem ITEM_NAN = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-11"), Double.NaN);
    private final TimeSeriesDataItem ITEM_0 = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-12"), 0.0);
    private final TimeSeriesDataItem ITEM_3 = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-13"), 3.0);
    private final TimeSeriesDataItem ITEM_4 = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-14."), 4.0);
    private final TimeSeriesDataItem ITEM_7 = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-15"), 7.0);
    private final TimeSeriesDataItem ITEM_24_5 = new TimeSeriesDataItem((RegularTimePeriod)Day.parseDay((String)"2012-01-16"), 24.5);
    private TimeSeriesValidator validator;
    private AxisMapping mapping;

    @Before
    public void setUp() throws Exception {
        this.validator = new TimeSeriesValidator();
        this.mapping = new AxisMapping();
        this.mapping.addRasterName("alias1", "raster1");
        this.mapping.addRasterName("alias2", "raster2");
        this.mapping.addRasterName("alias1", "raster3");
        this.mapping.addInsituName("alias1", "insitu1");
        this.mapping.addInsituName("alias1", "insitu2");
        this.mapping.addInsituName("alias2", "insitu3");
        this.validator.adaptTo((Object)"key1", this.mapping);
    }

    @Test
    public void testValidateWithDefaultExpression() throws Exception {
        TimeSeries unvalidatedTimeSeries = new TimeSeries((Comparable)((Object)"insitu1"));
        unvalidatedTimeSeries.add(this.ITEM_NAN);
        unvalidatedTimeSeries.add(this.ITEM_0);
        unvalidatedTimeSeries.add(this.ITEM_24_5);
        TimeSeries validatedTimeSeries = this.validator.validate(unvalidatedTimeSeries, "insitu1", TimeSeriesType.INSITU);
        Assert.assertSame((Object)unvalidatedTimeSeries, (Object)validatedTimeSeries);
        Assert.assertEquals((long)3L, (long)validatedTimeSeries.getItemCount());
        Assert.assertEquals((Object)this.ITEM_NAN, (Object)validatedTimeSeries.getDataItem(0));
        Assert.assertEquals((Object)this.ITEM_0, (Object)validatedTimeSeries.getDataItem(1));
        Assert.assertEquals((Object)this.ITEM_24_5, (Object)validatedTimeSeries.getDataItem(2));
    }

    @Test
    public void testValidateWithExpression() throws Exception {
        TimeSeries unvalidatedTimeSeries = new TimeSeries((Comparable)((Object)"insitu1"));
        unvalidatedTimeSeries.add(this.ITEM_NAN);
        unvalidatedTimeSeries.add(this.ITEM_0);
        unvalidatedTimeSeries.add(this.ITEM_24_5);
        Assert.assertTrue((boolean)this.validator.setExpression("i.insitu1", "i.insitu1 > 0"));
        TimeSeries validatedTimeSeries = this.validator.validate(unvalidatedTimeSeries, "insitu1", TimeSeriesType.INSITU);
        Assert.assertNotSame((Object)unvalidatedTimeSeries, (Object)validatedTimeSeries);
        Assert.assertEquals((long)1L, (long)validatedTimeSeries.getItemCount());
        Assert.assertEquals((Object)this.ITEM_24_5, (Object)validatedTimeSeries.getDataItem(0));
    }

    @Test
    public void testValidateWithWrongType() throws Exception {
        TimeSeries unvalidatedTimeSeries = new TimeSeries((Comparable)((Object)"raster1"));
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 5"));
        try {
            this.validator.validate(unvalidatedTimeSeries, "raster1", TimeSeriesType.INSITU);
            Assert.fail((String)"ParseException expected");
        }
        catch (ParseException e) {
            Assert.assertEquals((Object)"No variable for identifier 'i.raster1' registered.", (Object)e.getMessage());
        }
    }

    @Test
    public void testValidate() throws Exception {
        TimeSeries unvalidatedTimeSeries = new TimeSeries((Comparable)((Object)"raster1"));
        unvalidatedTimeSeries.add(this.ITEM_0);
        unvalidatedTimeSeries.add(this.ITEM_4);
        unvalidatedTimeSeries.add(this.ITEM_7);
        unvalidatedTimeSeries.add(this.ITEM_24_5);
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 5"));
        TimeSeries validated = this.validator.validate(unvalidatedTimeSeries, "raster1", TimeSeriesType.PIN);
        Assert.assertNotSame((Object)unvalidatedTimeSeries, (Object)validated);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
        Assert.assertEquals((Object)this.ITEM_7, (Object)validated.getDataItem(0));
        Assert.assertEquals((Object)this.ITEM_24_5, (Object)validated.getDataItem(1));
    }

    @Test
    public void testTryToSetInvalidExpression() throws Exception {
        Assert.assertFalse((boolean)this.validator.setExpression("r.raster1", "raster1 groesserAls 5"));
    }

    @Test
    public void testThatValidatorIsCorrectlyInitialized() throws Exception {
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 5"));
        Assert.assertFalse((boolean)this.validator.setExpression("r.raster4", "r.raster4 > 5"));
    }

    @Test
    public void testThatOnlyBooleanExpressionsCanBeSet() throws Exception {
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 5"));
        Assert.assertFalse((boolean)this.validator.setExpression("r.raster1", "r.raster1 + r.raster1"));
    }

    @Test
    public void testRepeatedAdapting() throws Exception {
        TimeSeries series = new TimeSeries((Comparable)((Object)"raster1"));
        series.add(this.ITEM_0);
        series.add(this.ITEM_3);
        series.add(this.ITEM_4);
        series.add(this.ITEM_7);
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 3"));
        TimeSeries validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
        this.validator.adaptTo((Object)"key2", new AxisMapping());
        Assert.assertFalse((boolean)this.validator.setExpression("r.raster1", "r.raster1 > 3"));
        try {
            this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
            Assert.fail();
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"No variable for identifier 'r.raster1' registered.", (Object)expected.getMessage());
        }
        this.validator.adaptTo((Object)"key1", this.mapping);
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 < 5"));
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)3L, (long)validated.getItemCount());
    }

    @Test
    public void testInvalidIfExpressionEqualsSourceName() throws Exception {
        Assert.assertFalse((boolean)this.validator.setExpression("r.raster1", "r.raster1"));
    }

    @Test
    public void testEmptyExpression() throws Exception {
        TimeSeries series = new TimeSeries((Comparable)((Object)"raster1"));
        series.add(this.ITEM_3);
        series.add(this.ITEM_4);
        TimeSeries validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 < 4"));
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)1L, (long)validated.getItemCount());
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", ""));
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "r.raster1 < 4"));
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)1L, (long)validated.getItemCount());
        Assert.assertTrue((boolean)this.validator.setExpression("r.raster1", "true"));
        validated = this.validator.validate(series, "raster1", TimeSeriesType.CURSOR);
        Assert.assertEquals((long)2L, (long)validated.getItemCount());
    }
}

