/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.timeseries.datamodel.DateRangeParser;
import org.junit.Assert;
import org.junit.Test;

public class DateRangeParserTest {
    @Test
    public void testTryToGetDateRangeFromValidDailyProduct() throws Exception {
        ProductData.UTC[] dateRange = DateRangeParser.tryToGetDateRange((String)"20111103_est_wac_wew_1200.dim");
        Assert.assertEquals((long)dateRange.length, (long)2L);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-11-03", (String)"yyyy-MM-dd").getAsDate().getTime(), (long)dateRange[0].getAsDate().getTime());
        Assert.assertEquals((long)dateRange[0].getAsDate().getTime(), (long)dateRange[1].getAsDate().getTime());
    }

    @Test
    public void testTryToGetDateRangeFromValidDailyProductWithLeadingCharacters() throws Exception {
        ProductData.UTC[] dateRange = DateRangeParser.tryToGetDateRange((String)"leading_characters_20111103_est_wac_wew_1200.dim");
        Assert.assertEquals((long)dateRange.length, (long)2L);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-11-03", (String)"yyyy-MM-dd").getAsDate().getTime(), (long)dateRange[0].getAsDate().getTime());
        Assert.assertEquals((long)dateRange[0].getAsDate().getTime(), (long)dateRange[1].getAsDate().getTime());
    }

    @Test
    public void testTryToGetDateRangeFromValidWeeklyProduct() throws Exception {
        ProductData.UTC[] dateRange = DateRangeParser.tryToGetDateRange((String)"20110917_20110923_bas_wac_acr_1200.dim");
        Assert.assertEquals((long)dateRange.length, (long)2L);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-09-17", (String)"yyyy-MM-dd").getAsDate().getTime(), (long)dateRange[0].getAsDate().getTime());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-09-23", (String)"yyyy-MM-dd").getAsDate().getTime(), (long)dateRange[1].getAsDate().getTime());
    }

    @Test
    public void testTryToGetDateRangeFromValidMonthlyProduct() throws Exception {
        ProductData.UTC[] dateRange = DateRangeParser.tryToGetDateRange((String)"201106_bas_wac_acr_1200.dim");
        Assert.assertEquals((long)dateRange.length, (long)2L);
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-06", (String)"yyyy-MM").getAsDate().getTime(), (long)dateRange[0].getAsDate().getTime());
        Assert.assertEquals((long)dateRange[0].getAsDate().getTime(), (long)dateRange[1].getAsDate().getTime());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotMatchAnyPattern() throws Exception {
        DateRangeParser.tryToGetDateRange((String)"doesNotMatchAnyPattern");
    }
}

