/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.timeseries.datamodel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.esa.snap.timeseries.core.timeseries.datamodel.AxisMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AxisMappingTest {
    private AxisMapping axisMapping;

    @Before
    public void setUp() throws Exception {
        this.axisMapping = new AxisMapping();
    }

    @Test
    public void testGetRasterNames() throws Exception {
        this.axisMapping.addRasterName("algal", "algal_1");
        this.axisMapping.addRasterName("algal", "algal_2");
        List rasterNames = this.axisMapping.getRasterNames("algal");
        ArrayList<String> expectedRasterNames = new ArrayList<String>(2);
        expectedRasterNames.add("algal_1");
        expectedRasterNames.add("algal_2");
        Assert.assertEquals(expectedRasterNames, (Object)rasterNames);
    }

    @Test
    public void testGetInsituNames() throws Exception {
        this.axisMapping.addInsituName("chl", "chl_1");
        this.axisMapping.addInsituName("chl", "chl2");
        List insituNames = this.axisMapping.getInsituNames("chl");
        ArrayList<String> expectedInsituNames = new ArrayList<String>(2);
        expectedInsituNames.add("chl2");
        expectedInsituNames.add("chl_1");
        Assert.assertEquals(expectedInsituNames, (Object)insituNames);
    }

    @Test
    public void testRemoveAlias() throws Exception {
        String alias = "chl";
        this.axisMapping.addInsituName("chl", "chl_1");
        this.axisMapping.addInsituName("chl", "chl2");
        this.axisMapping.addRasterName("chl", "chl_a");
        this.axisMapping.addRasterName("chl", "chl_b");
        this.axisMapping.removeAlias("chl");
        Assert.assertTrue((boolean)this.axisMapping.getInsituNames("chl").isEmpty());
        Assert.assertTrue((boolean)this.axisMapping.getRasterNames("chl").isEmpty());
    }

    @Test
    public void testRemoveInsitu() throws Exception {
        this.axisMapping.addInsituName("chl", "chl_1");
        this.axisMapping.addInsituName("chl", "chl2");
        this.axisMapping.removeInsituName("chl", "chl2");
        List insituNames = this.axisMapping.getInsituNames("chl");
        ArrayList<String> expectedInsituNames = new ArrayList<String>(2);
        expectedInsituNames.add("chl_1");
        Assert.assertEquals(expectedInsituNames, (Object)insituNames);
    }

    @Test
    public void testRemoveRaster() throws Exception {
        this.axisMapping.addRasterName("algal", "algal_1");
        this.axisMapping.addRasterName("algal", "algal2");
        this.axisMapping.removeRasterName("algal", "algal2");
        List rasterNames = this.axisMapping.getRasterNames("algal");
        ArrayList<String> expectedRasterNames = new ArrayList<String>(1);
        expectedRasterNames.add("algal_1");
        Assert.assertEquals(expectedRasterNames, (Object)rasterNames);
    }

    @Test
    public void testGetAliasNames() throws Exception {
        this.axisMapping.addRasterName("ra", "rn");
        this.axisMapping.addInsituName("ia", "in");
        Set names = this.axisMapping.getAliasNames();
        Assert.assertTrue((boolean)(names instanceof SortedSet));
        HashSet<String> expectedNames = new HashSet<String>();
        expectedNames.add("ra");
        expectedNames.add("ia");
        Assert.assertEquals(expectedNames, (Object)names);
    }

    @Test
    public void testAddAlias() throws Exception {
        this.axisMapping.addAlias("chl");
        Assert.assertEquals((Object)"chl", this.axisMapping.getAliasNames().iterator().next());
    }

    @Test
    public void testNoAliasNamesAreAddedAsSideEffect() throws Exception {
        this.axisMapping.getRasterNames("alias");
        this.axisMapping.getInsituNames("alias");
        Assert.assertTrue((boolean)this.axisMapping.getAliasNames().isEmpty());
    }

    @Test
    public void testReplaceAlias() throws Exception {
        this.axisMapping.addRasterName("alias", "RName");
        this.axisMapping.addInsituName("alias", "IName");
        this.axisMapping.replaceAlias("alias", "replaced");
        Set aliasNames = this.axisMapping.getAliasNames();
        Assert.assertEquals((long)1L, (long)aliasNames.size());
        Assert.assertEquals((Object)"replaced", aliasNames.iterator().next());
        Assert.assertEquals((Object)"RName", this.axisMapping.getRasterNames("replaced").iterator().next());
        Assert.assertEquals((Object)"IName", this.axisMapping.getInsituNames("replaced").iterator().next());
    }

    @Test
    public void testGetAliasNameForRasterName() {
        this.axisMapping.addRasterName("alias1", "rasterName1");
        this.axisMapping.addRasterName("alias2", "rasterName2");
        Assert.assertEquals((Object)"alias1", (Object)this.axisMapping.getRasterAlias("rasterName1"));
        Assert.assertNull((Object)this.axisMapping.getRasterAlias("rasterName3"));
    }

    @Test
    public void testGetAliasNameForInsituName() {
        this.axisMapping.addInsituName("alias1", "insituName1");
        this.axisMapping.addInsituName("alias2", "insituName2");
        Assert.assertEquals((Object)"alias1", (Object)this.axisMapping.getInsituAlias("insituName1"));
        Assert.assertNull((Object)this.axisMapping.getInsituAlias("insituName3"));
    }

    @Test
    public void testGetRasterCount() throws Exception {
        int rasterCount = this.axisMapping.getRasterCount();
        this.axisMapping.addRasterName("alias", "raster1");
        this.axisMapping.addRasterName("alias", "raster2");
        this.axisMapping.addRasterName("alias1", "raster1_1");
        this.axisMapping.addRasterName("alias1", "raster2");
        int rasterCount2 = this.axisMapping.getRasterCount();
        Assert.assertEquals((long)0L, (long)rasterCount);
        Assert.assertEquals((long)4L, (long)rasterCount2);
    }

    @Test
    public void testGetInsituCount() throws Exception {
        int insituCount = this.axisMapping.getInsituCount();
        this.axisMapping.addInsituName("alias", "insitu1");
        this.axisMapping.addInsituName("alias", "insitu2");
        this.axisMapping.addInsituName("alias1", "insitu1_1");
        this.axisMapping.addInsituName("alias1", "insitu2");
        int insituCount2 = this.axisMapping.getInsituCount();
        Assert.assertEquals((long)0L, (long)insituCount);
        Assert.assertEquals((long)4L, (long)insituCount2);
    }
}

