/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.insitu.csv;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.insitu.Header;
import org.esa.snap.timeseries.core.insitu.Record;
import org.esa.snap.timeseries.core.insitu.csv.CsvRecordSource;
import org.junit.Assert;
import org.junit.Test;

public class CsvRecordSourceTest {
    @Test
    public void testSimpleCsv() throws Exception {
        String CSV = "# Test CSV\nID\tLAT\tLONG\tTIME\tName\tCHL\tFLAG\n16\t53.1\t13.6\t03.04.2003\tName 1\t0.5\t1\n17\t53.3\t13.4\t08.04.2003\tName 2\t0.9\t0\n18\t53.1\t13.5\t11.04.2003\tName 3\t0.4\t1\n";
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd.MM.yyyy");
        CsvRecordSource recordSource = new CsvRecordSource((Reader)new StringReader("# Test CSV\nID\tLAT\tLONG\tTIME\tName\tCHL\tFLAG\n16\t53.1\t13.6\t03.04.2003\tName 1\t0.5\t1\n17\t53.3\t13.4\t08.04.2003\tName 2\t0.9\t0\n18\t53.1\t13.5\t11.04.2003\tName 3\t0.4\t1\n"), dateFormat);
        Header header = recordSource.getHeader();
        Assert.assertNotNull((Object)header);
        Assert.assertNotNull((Object)header.getColumnNames());
        Assert.assertArrayEquals((Object[])new String[]{"ID", "LAT", "LONG", "TIME", "Name", "CHL", "FLAG"}, (Object[])header.getColumnNames());
        Assert.assertEquals((Object)true, (Object)header.hasLocation());
        Assert.assertEquals((Object)true, (Object)header.hasTime());
        Iterable records = recordSource.getRecords();
        Assert.assertNotNull((Object)records);
        Iterator iterator = records.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec1 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec1);
        Assert.assertArrayEquals((Object[])new Object[]{16.0, 53.1, 13.6, dateFormat.parse("03.04.2003"), "Name 1", 0.5, 1.0}, (Object[])rec1.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.1f, (double)13.6f), (Object)rec1.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("03.04.2003"), (Object)rec1.getTime());
        Assert.assertEquals((Object)"Name 1", (Object)rec1.getStationName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec2 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec2);
        Assert.assertArrayEquals((Object[])new Object[]{17.0, 53.3, 13.4, dateFormat.parse("08.04.2003"), "Name 2", 0.9, 0.0}, (Object[])rec2.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.3f, (double)13.4f), (Object)rec2.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("08.04.2003"), (Object)rec2.getTime());
        Assert.assertEquals((Object)"Name 2", (Object)rec2.getStationName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec3 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec3);
        Assert.assertArrayEquals((Object[])new Object[]{18.0, 53.1, 13.5, dateFormat.parse("11.04.2003"), "Name 3", 0.4, 1.0}, (Object[])rec3.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.1f, 13.5), (Object)rec3.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("11.04.2003"), (Object)rec3.getTime());
        Assert.assertEquals((Object)"Name 3", (Object)rec3.getStationName());
    }

    @Test
    public void testSimpleCsvWithMissingValues() throws Exception {
        String CSV = "\n# Test CSV\n\nID\tLAT\tLONG\tTIME\tName\tCHL\tFLAG\n16\t53.1\t13.6\t03.04.2003\t\t0.5\t1\n17\t53.3\t13.4\t08.04.2003\t\t\t\n18\t53.1\t13.5\t11.04.2003\tA\t0.4\t\n";
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"dd.MM.yyyy");
        CsvRecordSource recordSource = new CsvRecordSource((Reader)new StringReader("\n# Test CSV\n\nID\tLAT\tLONG\tTIME\tName\tCHL\tFLAG\n16\t53.1\t13.6\t03.04.2003\t\t0.5\t1\n17\t53.3\t13.4\t08.04.2003\t\t\t\n18\t53.1\t13.5\t11.04.2003\tA\t0.4\t\n"), dateFormat);
        Header header = recordSource.getHeader();
        Assert.assertNotNull((Object)header);
        Assert.assertNotNull((Object)header.getColumnNames());
        Assert.assertArrayEquals((Object[])new String[]{"ID", "LAT", "LONG", "TIME", "Name", "CHL", "FLAG"}, (Object[])header.getColumnNames());
        Assert.assertEquals((Object)true, (Object)header.hasLocation());
        Assert.assertEquals((Object)true, (Object)header.hasTime());
        Iterable records = recordSource.getRecords();
        Assert.assertNotNull((Object)records);
        Iterator iterator = records.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec1 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec1);
        Assert.assertArrayEquals((Object[])new Object[]{16.0, 53.1, 13.6, dateFormat.parse("03.04.2003"), null, 0.5, 1.0}, (Object[])rec1.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.1f, (double)13.6f), (Object)rec1.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("03.04.2003"), (Object)rec1.getTime());
        Assert.assertEquals(null, (Object)rec1.getStationName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec2 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec2);
        Assert.assertArrayEquals((Object[])new Object[]{17.0, 53.3, 13.4, dateFormat.parse("08.04.2003"), null, null, null}, (Object[])rec2.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.3f, (double)13.4f), (Object)rec2.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("08.04.2003"), (Object)rec2.getTime());
        Assert.assertEquals(null, (Object)rec2.getStationName());
        Assert.assertTrue((boolean)iterator.hasNext());
        Record rec3 = (Record)iterator.next();
        Assert.assertNotNull((Object)rec3);
        Assert.assertArrayEquals((Object[])new Object[]{18.0, 53.1, 13.5, dateFormat.parse("11.04.2003"), "A", 0.4, null}, (Object[])rec3.getAttributeValues());
        Assert.assertEquals((Object)new GeoPos((double)53.1f, 13.5), (Object)rec3.getLocation());
        Assert.assertEquals((Object)dateFormat.parse("11.04.2003"), (Object)rec3.getTime());
        Assert.assertEquals((Object)"A", (Object)rec3.getStationName());
    }

    @Test
    public void testRealLifeCsv() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("cc-matchup-test-insitu.csv"));
        CsvRecordSource recordSource = new CsvRecordSource((Reader)reader, ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss"));
        Header header = recordSource.getHeader();
        Assert.assertNotNull((Object)header);
        Object[] headerAttributeNames = header.getColumnNames();
        Assert.assertNotNull((Object)headerAttributeNames);
        Assert.assertEquals((long)8L, (long)headerAttributeNames.length);
        Assert.assertArrayEquals((Object[])new String[]{"ID", "SITE", "FILE_ID", "LAT", "LONG", "TIME", "CONC_CHL", "KD_490"}, (Object[])headerAttributeNames);
        Assert.assertEquals((Object)true, (Object)header.hasLocation());
        Assert.assertEquals((Object)true, (Object)header.hasTime());
        long t0 = System.currentTimeMillis();
        Iterable records = recordSource.getRecords();
        int n = 0;
        for (Record record : records) {
            Object[] dataAttributeValues = record.getAttributeValues();
            Assert.assertEquals((long)8L, (long)dataAttributeValues.length);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[0]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[1]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[2]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[3]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[4]);
            CsvRecordSourceTest.assertType(n, Date.class, dataAttributeValues[5]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[6]);
            CsvRecordSourceTest.assertType(n, Double.class, dataAttributeValues[7]);
            ++n;
        }
        Assert.assertEquals((long)11876L, (long)n);
        System.out.println("CsvRecordSource read " + n + " records, took " + (System.currentTimeMillis() - t0) + " ms");
    }

    private static void assertType(int n, Class<?> expectedType, Object attributeValue) {
        if (attributeValue != null) {
            Assert.assertEquals((String)String.format("Record #%d: value=%s ", n + 1, attributeValue), expectedType, attributeValue.getClass());
        }
    }
}

