/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core.insitu;

import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.esa.snap.framework.datamodel.GeoPos;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.insitu.InsituSource;
import org.esa.snap.timeseries.core.insitu.RecordSource;
import org.esa.snap.timeseries.core.insitu.csv.CsvRecordSource;
import org.esa.snap.timeseries.core.insitu.csv.InsituRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InsituSourceTest {
    private DateFormat dateFormat;
    private InsituSource insituSource;

    @Before
    public void setUp() throws Exception {
        this.dateFormat = ProductData.UTC.createDateFormat((String)"dd.MM.yyyy");
        StringReader csvReader = new StringReader("# Test CSV\nLAT\tLON\tTIME\tStation\tCHL\tys\n10\t30\t08.04.2003\tName 1\t0.9\t20\n20\t40\t02.04.2003\tName 2\t0.5\t30\n20\t40\t05.04.2003\tName 2\t0.6\t40\n20\t50\t11.04.2003\tName 3\t0.4\t50\n");
        CsvRecordSource csvRecordSource = new CsvRecordSource((Reader)csvReader, this.dateFormat);
        this.insituSource = new InsituSource((RecordSource)csvRecordSource);
    }

    @Test
    public void testGetValuesForCHL_TimeOrdered() throws Exception {
        InsituRecord[] chlRecords = this.insituSource.getValuesFor("CHL", null);
        Assert.assertEquals((long)4L, (long)chlRecords.length);
        InsituRecord expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("02.04.2003"), "Name 2", 0.5);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecords[0]);
        expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("05.04.2003"), "Name 2", 0.6);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecords[1]);
        expectedRecord = new InsituRecord(new GeoPos(10.0, 30.0), this.getDate("08.04.2003"), "Name 1", 0.9);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecords[2]);
        expectedRecord = new InsituRecord(new GeoPos(20.0, 50.0), this.getDate("11.04.2003"), "Name 3", 0.4);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecords[3]);
    }

    @Test
    public void testGetValuesForYS_TimeOrdered() throws Exception {
        InsituRecord[] ysRecords = this.insituSource.getValuesFor("ys", null);
        Assert.assertEquals((long)4L, (long)ysRecords.length);
        InsituRecord expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("02.04.2003"), "Name 2", 30.0);
        Assert.assertEquals((Object)expectedRecord, (Object)ysRecords[0]);
        expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("05.04.2003"), "Name 2", 40.0);
        Assert.assertEquals((Object)expectedRecord, (Object)ysRecords[1]);
        expectedRecord = new InsituRecord(new GeoPos(10.0, 30.0), this.getDate("08.04.2003"), "Name 1", 20.0);
        Assert.assertEquals((Object)expectedRecord, (Object)ysRecords[2]);
        expectedRecord = new InsituRecord(new GeoPos(20.0, 50.0), this.getDate("11.04.2003"), "Name 3", 50.0);
        Assert.assertEquals((Object)expectedRecord, (Object)ysRecords[3]);
    }

    @Test
    public void testGetValuesForGeoPos() throws Exception {
        InsituRecord[] chlRecordsPos1 = this.insituSource.getValuesFor("ys", new GeoPos(20.0, 40.0));
        InsituRecord[] chlRecordsPos2 = this.insituSource.getValuesFor("ys", new GeoPos(10.0, 30.0));
        Assert.assertEquals((long)2L, (long)chlRecordsPos1.length);
        Assert.assertEquals((long)1L, (long)chlRecordsPos2.length);
        InsituRecord expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("02.04.2003"), "Name 2", 30.0);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecordsPos1[0]);
        expectedRecord = new InsituRecord(new GeoPos(20.0, 40.0), this.getDate("05.04.2003"), "Name 2", 40.0);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecordsPos1[1]);
        expectedRecord = new InsituRecord(new GeoPos(10.0, 30.0), this.getDate("08.04.2003"), "Name 1", 20.0);
        Assert.assertEquals((Object)expectedRecord, (Object)chlRecordsPos2[0]);
    }

    @Test
    public void testGetParameterNames() throws Exception {
        Object[] parameterNames = this.insituSource.getParameterNames();
        Assert.assertArrayEquals((Object[])new String[]{"CHL", "ys"}, (Object[])parameterNames);
    }

    private Date getDate(String dateString) throws ParseException {
        return this.dateFormat.parse(dateString);
    }
}

