/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.timeseries.core;

import java.io.File;
import org.esa.snap.framework.datamodel.MetadataAttribute;
import org.esa.snap.framework.datamodel.MetadataElement;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductData;
import org.esa.snap.timeseries.core.TimeSeriesModule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeSeriesModuleTest {
    private Product testProduct;
    private String absoluteProductPath1;
    private String absoluteProductPath2;
    private String absOutputPath;

    @Before
    public void setUp() throws Exception {
        this.absOutputPath = "D:/any/non/relative/path";
        this.absoluteProductPath1 = this.absOutputPath + "/and/a/product/file/product1.dim";
        this.absoluteProductPath2 = this.absOutputPath + "/and/a/product/file/product2.dim";
        this.testProduct = new Product("test", "test", 20, 20);
        this.prepareProduct();
    }

    @Test
    public void testAbsToRelPath() {
        File testOutputDir = new File(this.absOutputPath);
        TimeSeriesModule.convertAbsolutPathsToRelative((Product)this.testProduct, (File)testOutputDir);
        Assert.assertEquals((Object)"and/a/product/file/product1.dim", (Object)this.getPathString("PRODUCT_LOCATIONS", 0));
        Assert.assertEquals((Object)"and/a/product/file/product2.dim", (Object)this.getPathString("PRODUCT_LOCATIONS", 1));
        Assert.assertEquals((Object)"and/a/product/file/product1.dim", (Object)this.getPathString("SOURCE_PRODUCT_PATHS", 0));
        Assert.assertEquals((Object)"and/a/product/file/product2.dim", (Object)this.getPathString("SOURCE_PRODUCT_PATHS", 1));
    }

    private String getPathString(String tsMetadataName, int idx) {
        return this.testProduct.getMetadataRoot().getElement("TIME_SERIES").getElement(tsMetadataName).getElement(tsMetadataName + "." + idx).getAttributeString("PATH");
    }

    private void prepareProduct() {
        MetadataElement tsRoot = new MetadataElement("TIME_SERIES");
        this.testProduct.getMetadataRoot().addElement(tsRoot);
        MetadataElement productLocations = new MetadataElement("PRODUCT_LOCATIONS");
        tsRoot.addElement(productLocations);
        MetadataElement sourcePaths = new MetadataElement("SOURCE_PRODUCT_PATHS");
        tsRoot.addElement(sourcePaths);
        this.addProductLocationElements(productLocations);
        this.addSourceProductPathsElemets(sourcePaths);
    }

    private void addProductLocationElements(MetadataElement productLocations) {
        MetadataElement location0 = new MetadataElement("PRODUCT_LOCATIONS.0");
        MetadataElement location1 = new MetadataElement("PRODUCT_LOCATIONS.1");
        productLocations.addElement(location0);
        productLocations.addElement(location1);
        location0.addAttribute(new MetadataAttribute("PATH", ProductData.createInstance((String)this.absoluteProductPath1), true));
        location0.addAttribute(new MetadataAttribute("TYPE", ProductData.createInstance((String)"FILE"), true));
        location1.addAttribute(new MetadataAttribute("PATH", ProductData.createInstance((String)this.absoluteProductPath2), true));
        location1.addAttribute(new MetadataAttribute("TYPE", ProductData.createInstance((String)"FILE"), true));
    }

    private void addSourceProductPathsElemets(MetadataElement sourcePaths) {
        MetadataElement sourcePath1 = new MetadataElement("SOURCE_PRODUCT_PATHS.0");
        MetadataElement sourcePath2 = new MetadataElement("SOURCE_PRODUCT_PATHS.1");
        sourcePaths.addElement(sourcePath1);
        sourcePaths.addElement(sourcePath2);
        sourcePath1.addAttribute(new MetadataAttribute("PATH", ProductData.createInstance((String)this.absoluteProductPath1), true));
        sourcePath2.addAttribute(new MetadataAttribute("PATH", ProductData.createInstance((String)this.absoluteProductPath2), true));
    }
}

