/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.interpolators;

import java.text.MessageFormat;
import org.esa.snap.interpolators.InterpolatingFunction;
import org.esa.snap.interpolators.Interpolator;
import org.esa.snap.interpolators.PolynomialFunction;

public class LinearInterpolator
implements Interpolator {
    private final int minNumPoints = 2;

    @Override
    public int getMinNumPoints() {
        return 2;
    }

    @Override
    public InterpolatingFunction interpolate(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(MessageFormat.format("Dimension mismatch {0} != {1}.", x.length, y.length));
        }
        if (x.length < 2) {
            throw new IllegalArgumentException(MessageFormat.format("{0} points are required, got only {1}.", 2, x.length));
        }
        int n = x.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(x[i] >= x[i + 1])) continue;
            throw new IllegalArgumentException(MessageFormat.format("Points {0} and {1} are not strictly increasing ({2} >= {3}).", i, i + 1, x[i], x[i + 1]));
        }
        double[] m = new double[n];
        for (int i = 0; i < n; ++i) {
            m[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new InterpolatingFunction(x, polynomials);
    }
}

