/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.Date;
import java.util.logging.Logger;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.statistics.percentile.interpolated.ProductValidator;
import org.esa.snap.statistics.percentile.interpolated.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Utils.class})
public class ProductValidatorTest {
    private String sourceBandName;
    private ProductData.UTC _timeRangeStart;
    private ProductData.UTC _timeRangeEnd;
    private Logger S_logger;
    private ProductValidator _productValidator;
    private Product M_product;
    private GeoCoding M_geoCoding;
    private Area _nonIntersectingArea;

    @Before
    public void setUp() throws Exception {
        this.sourceBandName = "sbn";
        this._timeRangeStart = ProductData.UTC.parse((String)"2012-05-21 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        this._timeRangeEnd = ProductData.UTC.parse((String)"2012-07-08 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        Area targetArea = new Area(new Rectangle(9, 51, 20, 15));
        Area intersectingArea = new Area(new Rectangle(3, 45, 20, 15));
        this._nonIntersectingArea = new Area(new Rectangle(3, 45, 2, 1));
        PowerMockito.mockStatic(Utils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)Utils.createProductArea((Product)((Product)Mockito.any(Product.class)))).thenReturn((Object)intersectingArea);
        Logger logger = Logger.getAnonymousLogger();
        this.S_logger = (Logger)PowerMockito.spy((Object)logger);
        this._productValidator = new ProductValidator(this.sourceBandName, null, null, this._timeRangeStart, this._timeRangeEnd, targetArea, this.S_logger);
        this.M_geoCoding = (GeoCoding)PowerMockito.mock(GeoCoding.class);
        PowerMockito.when((Object)this.M_geoCoding.canGetPixelPos()).thenReturn((Object)true);
        ProductData.UTC productStartTime = ProductData.UTC.parse((String)"2012-05-22 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        ProductData.UTC productEndTime = ProductData.UTC.parse((String)"2012-07-07 00:00:00", (String)"yyyy-MM-dd HH:mm:ss");
        this.M_product = (Product)PowerMockito.mock(Product.class);
        PowerMockito.when((Object)this.M_product.getName()).thenReturn((Object)"ProductMock");
        PowerMockito.when((Object)this.M_product.getSceneGeoCoding()).thenReturn((Object)this.M_geoCoding);
        PowerMockito.when((Object)this.M_product.getStartTime()).thenReturn((Object)productStartTime);
        PowerMockito.when((Object)this.M_product.getEndTime()).thenReturn((Object)productEndTime);
        PowerMockito.when((Object)this.M_product.containsBand(this.sourceBandName)).thenReturn((Object)true);
    }

    @Test
    public void testValidProduct() {
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)true, (Object)result);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.S_logger});
    }

    @Test
    public void testThatVerificationFailsIfProductHasNoGeoCoding() {
        PowerMockito.when((Object)this.M_product.getSceneGeoCoding()).thenReturn(null);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' does not contain a geo coding.");
    }

    @Test
    public void testThatVerificationFailsIfTheGeoCodingCanNotGetPixelPositionFromGeoPos() {
        PowerMockito.when((Object)this.M_geoCoding.canGetPixelPos()).thenReturn((Object)false);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The geo-coding of the product 'ProductMock' can not determine the pixel position from a geodetic position.");
    }

    @Test
    public void testThatVerificationFailsIfTheProductDoesNotContainAStartTime() {
        PowerMockito.when((Object)this.M_product.getStartTime()).thenReturn(null);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' must contain start and end time.");
    }

    @Test
    public void testThatVerificationFailsIfTheProductDoesNotContainAnEndTime() {
        PowerMockito.when((Object)this.M_product.getEndTime()).thenReturn(null);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' must contain start and end time.");
    }

    @Test
    public void testThatVerificationFailsIfTheProductCanNotHandleTheBandConfiguration() {
        PowerMockito.when((Object)this.M_product.containsBand(this.sourceBandName)).thenReturn((Object)false);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' does not contain the band 'sbn'.");
    }

    @Test
    public void testThatVerificationFailsIfTheProductStartsBeforeTimeRange() {
        long timeRangeStartTime = this._timeRangeStart.getAsDate().getTime();
        Date beforeTime = new Date(timeRangeStartTime - 1L);
        PowerMockito.when((Object)this.M_product.getStartTime()).thenReturn((Object)ProductData.UTC.create((Date)beforeTime, (long)0L));
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' is not inside the date range from 21-MAY-2012 00:00:00.000000 to 08-JUL-2012 00:00:00.000000");
    }

    @Test
    public void testThatVerificationFailsIfTheProductEndsAfterTimeRange() {
        long timeRangeEndTime = this._timeRangeEnd.getAsDate().getTime();
        Date afterTime = new Date(timeRangeEndTime + 1000L);
        PowerMockito.when((Object)this.M_product.getEndTime()).thenReturn((Object)ProductData.UTC.create((Date)afterTime, (long)0L));
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' is not inside the date range from 21-MAY-2012 00:00:00.000000 to 08-JUL-2012 00:00:00.000000");
    }

    @Test
    public void testThatVerificationFailsIfTheProductDoesNotIntersectTheTargetArea() {
        PowerMockito.when((Object)Utils.createProductArea((Product)((Product)Mockito.any(Product.class)))).thenReturn((Object)this._nonIntersectingArea);
        boolean result = this._productValidator.isValid(this.M_product);
        Assert.assertEquals((Object)false, (Object)result);
        ((Logger)Mockito.verify((Object)this.S_logger, (VerificationMode)Mockito.times((int)1))).info("Product skipped. The product 'ProductMock' does not intersect the target product.");
    }
}

