/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.percentile.interpolated;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.DateTimeUtils;
import org.esa.snap.statistics.percentile.interpolated.Utils;
import org.junit.Assert;
import org.junit.Test;

public class UtilsTest_GroupProductsDaily {
    @Test
    public void testSomething() throws ParseException {
        Product[] products = new Product[]{this.createProduct("2013-03-05 00:00:10"), this.createProduct("2013-03-05 23:59:50"), this.createProduct("2013-03-06 00:00:10"), this.createProduct("2013-03-06 23:59:50")};
        TreeMap longListTreeMap = Utils.groupProductsDaily((Product[])products);
        Assert.assertEquals((long)2L, (long)longListTreeMap.size());
        Long[] mjdKeys = longListTreeMap.keySet().toArray(new Long[2]);
        Assert.assertEquals((String)"means 2013-03-05", (long)56356L, (long)mjdKeys[0]);
        Assert.assertEquals((String)"means 2013-03-06", (long)56357L, (long)mjdKeys[1]);
        Assert.assertEquals((Object)"05-MAR-2013 00:00:00.000000", (Object)ProductData.UTC.create((Date)DateTimeUtils.jdToUTC((double)DateTimeUtils.mjdToJD((double)mjdKeys[0].longValue())), (long)0L).format());
        Assert.assertEquals((Object)"06-MAR-2013 00:00:00.000000", (Object)ProductData.UTC.create((Date)DateTimeUtils.jdToUTC((double)DateTimeUtils.mjdToJD((double)mjdKeys[1].longValue())), (long)0L).format());
        List productList1 = (List)longListTreeMap.get(mjdKeys[0]);
        Assert.assertEquals((long)2L, (long)productList1.size());
        Assert.assertSame(productList1.get(0), (Object)products[0]);
        Assert.assertSame(productList1.get(1), (Object)products[1]);
        List productList2 = (List)longListTreeMap.get(mjdKeys[1]);
        Assert.assertEquals((long)2L, (long)productList2.size());
        Assert.assertSame(productList2.get(0), (Object)products[2]);
        Assert.assertSame(productList2.get(1), (Object)products[3]);
    }

    private Product createProduct(String centerDateString) throws ParseException {
        ProductData.UTC centerUTC = ProductData.UTC.parse((String)centerDateString, (String)"yyyy-MM-dd hh:mm:ss");
        Calendar centerCalendar = centerUTC.getAsCalendar();
        long centerTime = centerCalendar.getTime().getTime();
        ProductData.UTC startTime = ProductData.UTC.create((Date)new Date(centerTime - 20L), (long)0L);
        ProductData.UTC endTime = ProductData.UTC.create((Date)new Date(centerTime + 20L), (long)0L);
        Product product = new Product("n", "t", 2, 2);
        product.setStartTime(startTime);
        product.setEndTime(endTime);
        return product;
    }
}

