/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.interpolators;

import org.esa.snap.interpolators.InterpolatingFunction;
import org.esa.snap.interpolators.QuadraticInterpolator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QuadraticInterpolatorTest {
    private QuadraticInterpolator quadraticInterpolator;

    @Before
    public void setUp() throws Exception {
        this.quadraticInterpolator = new QuadraticInterpolator();
    }

    @Test
    public void testInterpolationOfStraightLine() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        InterpolatingFunction function = this.quadraticInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        Assert.assertEquals((double)1.0, (double)function.value(1.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)function.value(3.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)function.value(5.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)function.value(7.0), (double)0.0);
    }

    @Test
    public void testInterpolationOfFunctionWithPositiveAndNegativeSlope() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{1.0, 3.0, 5.0, 3.0, 1.0};
        InterpolatingFunction function = this.quadraticInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        Assert.assertEquals((double)2.0, (double)function.value(1.0), (double)0.0);
        Assert.assertEquals((double)4.0, (double)function.value(3.0), (double)0.5);
        Assert.assertEquals((double)4.0, (double)function.value(5.0), (double)0.01);
        Assert.assertEquals((double)2.0, (double)function.value(7.0), (double)0.0);
    }

    @Test
    public void testInterpolationOfQuadraticFunction() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        double[] y = new double[]{Math.pow(0.0, 2.0), Math.pow(2.0, 2.0), Math.pow(4.0, 2.0), Math.pow(6.0, 2.0), Math.pow(8.0, 2.0)};
        InterpolatingFunction function = this.quadraticInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        Assert.assertEquals((double)Math.pow(1.0, 2.0), (double)function.value(1.0), (double)0.0);
        Assert.assertEquals((double)Math.pow(3.0, 2.0), (double)function.value(3.0), (double)0.0);
        Assert.assertEquals((double)Math.pow(5.0, 2.0), (double)function.value(5.0), (double)0.0);
        Assert.assertEquals((double)Math.pow(7.0, 2.0), (double)function.value(7.0), (double)0.0);
    }

    @Test
    public void testInterpolationOfSinusFunction() {
        double[] x = new double[]{0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0};
        double[] y = new double[]{Math.sin(0.0), Math.sin(0.39269908169872414), Math.sin(0.7853981633974483), Math.sin(1.1780972450961724), Math.sin(1.5707963267948966), Math.sin(1.9634954084936207), Math.sin(2.356194490192345), Math.sin(2.748893571891069), Math.sin(Math.PI)};
        InterpolatingFunction function = this.quadraticInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        Assert.assertEquals((double)Math.sin(0.19634954084936207), (double)function.value(1.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(0.5890486225480862), (double)function.value(3.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(0.9817477042468103), (double)function.value(5.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(1.3744467859455345), (double)function.value(7.0), (double)0.001);
        Assert.assertEquals((double)Math.sin(1.7671458676442586), (double)function.value(9.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(2.1598449493429825), (double)function.value(11.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(2.552544031041707), (double)function.value(13.0), (double)0.01);
        Assert.assertEquals((double)Math.sin(2.945243112740431), (double)function.value(15.0), (double)0.01);
    }

    @Test
    public void testInterpolationOfRandomValues() {
        double[] x = new double[]{0.0, 4.0, 7.0, 8.0, 10.0, 14.0, 16.0};
        double[] y = new double[]{2.0, 1.0, 8.0, 5.0, 4.0, 1.0, 7.0};
        InterpolatingFunction function = this.quadraticInterpolator.interpolate(x, y);
        this.assertKnownValuesAreAssignedCorrectly(x, y, function);
        Assert.assertEquals((double)0.03, (double)function.value(2.0), (double)0.01);
        Assert.assertEquals((double)7.5, (double)function.value(5.5), (double)0.01);
        Assert.assertEquals((double)6.3, (double)function.value(7.5), (double)0.01);
        Assert.assertEquals((double)4.54, (double)function.value(9.0), (double)0.01);
        Assert.assertEquals((double)0.0, (double)function.value(12.0), (double)0.01);
        Assert.assertEquals((double)3.38, (double)function.value(15.0), (double)0.01);
    }

    private void assertKnownValuesAreAssignedCorrectly(double[] x, double[] y, InterpolatingFunction function) {
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)y[i], (double)function.value(x[i]), (double)1.0E-10);
        }
    }
}

