package org.esa.snap.tango;

import org.openide.util.ImageUtilities;

import javax.swing.ImageIcon;


/**
 * This class has been automatically generated.
 *
 * @author Norman Fomferra
 */
@SuppressWarnings("UnusedDeclaration")
public final class TangoIcons {

    public enum Res {
        R16("16x16"),
        R22("22x22"),
        R32("32x32");

        private final String name;

        Res(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return name;
        }
    }

    public final static Res R16 = Res.R16;
    public final static Res R22 = Res.R22;
    public final static Res R32 = Res.R32;

    public static ImageIcon actions_address_book_new(Res res) { return getIcon("actions/address-book-new.png", res); }
    public static ImageIcon actions_appointment_new(Res res) { return getIcon("actions/appointment-new.png", res); }
    public static ImageIcon actions_bookmark_new(Res res) { return getIcon("actions/bookmark-new.png", res); }
    public static ImageIcon actions_contact_new(Res res) { return getIcon("actions/contact-new.png", res); }
    public static ImageIcon actions_document_new(Res res) { return getIcon("actions/document-new.png", res); }
    public static ImageIcon actions_document_open(Res res) { return getIcon("actions/document-open.png", res); }
    public static ImageIcon actions_document_print_preview(Res res) { return getIcon("actions/document-print-preview.png", res); }
    public static ImageIcon actions_document_print(Res res) { return getIcon("actions/document-print.png", res); }
    public static ImageIcon actions_document_properties(Res res) { return getIcon("actions/document-properties.png", res); }
    public static ImageIcon actions_document_save_as(Res res) { return getIcon("actions/document-save-as.png", res); }
    public static ImageIcon actions_document_save(Res res) { return getIcon("actions/document-save.png", res); }
    public static ImageIcon actions_edit_clear(Res res) { return getIcon("actions/edit-clear.png", res); }
    public static ImageIcon actions_edit_copy(Res res) { return getIcon("actions/edit-copy.png", res); }
    public static ImageIcon actions_edit_cut(Res res) { return getIcon("actions/edit-cut.png", res); }
    public static ImageIcon actions_edit_delete(Res res) { return getIcon("actions/edit-delete.png", res); }
    public static ImageIcon actions_edit_find_replace(Res res) { return getIcon("actions/edit-find-replace.png", res); }
    public static ImageIcon actions_edit_find(Res res) { return getIcon("actions/edit-find.png", res); }
    public static ImageIcon actions_edit_paste(Res res) { return getIcon("actions/edit-paste.png", res); }
    public static ImageIcon actions_edit_redo(Res res) { return getIcon("actions/edit-redo.png", res); }
    public static ImageIcon actions_edit_select_all(Res res) { return getIcon("actions/edit-select-all.png", res); }
    public static ImageIcon actions_edit_undo(Res res) { return getIcon("actions/edit-undo.png", res); }
    public static ImageIcon actions_folder_new(Res res) { return getIcon("actions/folder-new.png", res); }
    public static ImageIcon actions_format_indent_less(Res res) { return getIcon("actions/format-indent-less.png", res); }
    public static ImageIcon actions_format_indent_more(Res res) { return getIcon("actions/format-indent-more.png", res); }
    public static ImageIcon actions_format_justify_center(Res res) { return getIcon("actions/format-justify-center.png", res); }
    public static ImageIcon actions_format_justify_fill(Res res) { return getIcon("actions/format-justify-fill.png", res); }
    public static ImageIcon actions_format_justify_left(Res res) { return getIcon("actions/format-justify-left.png", res); }
    public static ImageIcon actions_format_justify_right(Res res) { return getIcon("actions/format-justify-right.png", res); }
    public static ImageIcon actions_format_text_bold(Res res) { return getIcon("actions/format-text-bold.png", res); }
    public static ImageIcon actions_format_text_italic(Res res) { return getIcon("actions/format-text-italic.png", res); }
    public static ImageIcon actions_format_text_strikethrough(Res res) { return getIcon("actions/format-text-strikethrough.png", res); }
    public static ImageIcon actions_format_text_underline(Res res) { return getIcon("actions/format-text-underline.png", res); }
    public static ImageIcon actions_go_bottom(Res res) { return getIcon("actions/go-bottom.png", res); }
    public static ImageIcon actions_go_down(Res res) { return getIcon("actions/go-down.png", res); }
    public static ImageIcon actions_go_first(Res res) { return getIcon("actions/go-first.png", res); }
    public static ImageIcon actions_go_home(Res res) { return getIcon("actions/go-home.png", res); }
    public static ImageIcon actions_go_jump(Res res) { return getIcon("actions/go-jump.png", res); }
    public static ImageIcon actions_go_last(Res res) { return getIcon("actions/go-last.png", res); }
    public static ImageIcon actions_go_next(Res res) { return getIcon("actions/go-next.png", res); }
    public static ImageIcon actions_go_previous(Res res) { return getIcon("actions/go-previous.png", res); }
    public static ImageIcon actions_go_top(Res res) { return getIcon("actions/go-top.png", res); }
    public static ImageIcon actions_go_up(Res res) { return getIcon("actions/go-up.png", res); }
    public static ImageIcon actions_list_add(Res res) { return getIcon("actions/list-add.png", res); }
    public static ImageIcon actions_list_remove(Res res) { return getIcon("actions/list-remove.png", res); }
    public static ImageIcon actions_mail_forward(Res res) { return getIcon("actions/mail-forward.png", res); }
    public static ImageIcon actions_mail_mark_junk(Res res) { return getIcon("actions/mail-mark-junk.png", res); }
    public static ImageIcon actions_mail_mark_not_junk(Res res) { return getIcon("actions/mail-mark-not-junk.png", res); }
    public static ImageIcon actions_mail_message_new(Res res) { return getIcon("actions/mail-message-new.png", res); }
    public static ImageIcon actions_mail_reply_all(Res res) { return getIcon("actions/mail-reply-all.png", res); }
    public static ImageIcon actions_mail_reply_sender(Res res) { return getIcon("actions/mail-reply-sender.png", res); }
    public static ImageIcon actions_mail_send_receive(Res res) { return getIcon("actions/mail-send-receive.png", res); }
    public static ImageIcon actions_media_eject(Res res) { return getIcon("actions/media-eject.png", res); }
    public static ImageIcon actions_media_playback_pause(Res res) { return getIcon("actions/media-playback-pause.png", res); }
    public static ImageIcon actions_media_playback_start(Res res) { return getIcon("actions/media-playback-start.png", res); }
    public static ImageIcon actions_media_playback_stop(Res res) { return getIcon("actions/media-playback-stop.png", res); }
    public static ImageIcon actions_media_record(Res res) { return getIcon("actions/media-record.png", res); }
    public static ImageIcon actions_media_seek_backward(Res res) { return getIcon("actions/media-seek-backward.png", res); }
    public static ImageIcon actions_media_seek_forward(Res res) { return getIcon("actions/media-seek-forward.png", res); }
    public static ImageIcon actions_media_skip_backward(Res res) { return getIcon("actions/media-skip-backward.png", res); }
    public static ImageIcon actions_media_skip_forward(Res res) { return getIcon("actions/media-skip-forward.png", res); }
    public static ImageIcon actions_process_stop(Res res) { return getIcon("actions/process-stop.png", res); }
    public static ImageIcon actions_system_lock_screen(Res res) { return getIcon("actions/system-lock-screen.png", res); }
    public static ImageIcon actions_system_log_out(Res res) { return getIcon("actions/system-log-out.png", res); }
    public static ImageIcon actions_system_search(Res res) { return getIcon("actions/system-search.png", res); }
    public static ImageIcon actions_system_shutdown(Res res) { return getIcon("actions/system-shutdown.png", res); }
    public static ImageIcon actions_tab_new(Res res) { return getIcon("actions/tab-new.png", res); }
    public static ImageIcon actions_view_fullscreen(Res res) { return getIcon("actions/view-fullscreen.png", res); }
    public static ImageIcon actions_view_refresh(Res res) { return getIcon("actions/view-refresh.png", res); }
    public static ImageIcon actions_window_new(Res res) { return getIcon("actions/window-new.png", res); }
    public static ImageIcon animations_process_working(Res res) { return getIcon("animations/process-working.png", res); }
    public static ImageIcon apps_accessories_calculator(Res res) { return getIcon("apps/accessories-calculator.png", res); }
    public static ImageIcon apps_accessories_character_map(Res res) { return getIcon("apps/accessories-character-map.png", res); }
    public static ImageIcon apps_accessories_text_editor(Res res) { return getIcon("apps/accessories-text-editor.png", res); }
    public static ImageIcon apps_help_browser(Res res) { return getIcon("apps/help-browser.png", res); }
    public static ImageIcon apps_internet_group_chat(Res res) { return getIcon("apps/internet-group-chat.png", res); }
    public static ImageIcon apps_internet_mail(Res res) { return getIcon("apps/internet-mail.png", res); }
    public static ImageIcon apps_internet_news_reader(Res res) { return getIcon("apps/internet-news-reader.png", res); }
    public static ImageIcon apps_internet_web_browser(Res res) { return getIcon("apps/internet-web-browser.png", res); }
    public static ImageIcon apps_office_calendar(Res res) { return getIcon("apps/office-calendar.png", res); }
    public static ImageIcon apps_preferences_desktop_accessibility(Res res) { return getIcon("apps/preferences-desktop-accessibility.png", res); }
    public static ImageIcon apps_preferences_desktop_assistive_technology(Res res) { return getIcon("apps/preferences-desktop-assistive-technology.png", res); }
    public static ImageIcon apps_preferences_desktop_font(Res res) { return getIcon("apps/preferences-desktop-font.png", res); }
    public static ImageIcon apps_preferences_desktop_keyboard_shortcuts(Res res) { return getIcon("apps/preferences-desktop-keyboard-shortcuts.png", res); }
    public static ImageIcon apps_preferences_desktop_locale(Res res) { return getIcon("apps/preferences-desktop-locale.png", res); }
    public static ImageIcon apps_preferences_desktop_multimedia(Res res) { return getIcon("apps/preferences-desktop-multimedia.png", res); }
    public static ImageIcon apps_preferences_desktop_remote_desktop(Res res) { return getIcon("apps/preferences-desktop-remote-desktop.png", res); }
    public static ImageIcon apps_preferences_desktop_screensaver(Res res) { return getIcon("apps/preferences-desktop-screensaver.png", res); }
    public static ImageIcon apps_preferences_desktop_theme(Res res) { return getIcon("apps/preferences-desktop-theme.png", res); }
    public static ImageIcon apps_preferences_desktop_wallpaper(Res res) { return getIcon("apps/preferences-desktop-wallpaper.png", res); }
    public static ImageIcon apps_preferences_system_network_proxy(Res res) { return getIcon("apps/preferences-system-network-proxy.png", res); }
    public static ImageIcon apps_preferences_system_session(Res res) { return getIcon("apps/preferences-system-session.png", res); }
    public static ImageIcon apps_preferences_system_windows(Res res) { return getIcon("apps/preferences-system-windows.png", res); }
    public static ImageIcon apps_system_file_manager(Res res) { return getIcon("apps/system-file-manager.png", res); }
    public static ImageIcon apps_system_installer(Res res) { return getIcon("apps/system-installer.png", res); }
    public static ImageIcon apps_system_software_update(Res res) { return getIcon("apps/system-software-update.png", res); }
    public static ImageIcon apps_system_users(Res res) { return getIcon("apps/system-users.png", res); }
    public static ImageIcon apps_utilities_system_monitor(Res res) { return getIcon("apps/utilities-system-monitor.png", res); }
    public static ImageIcon apps_utilities_terminal(Res res) { return getIcon("apps/utilities-terminal.png", res); }
    public static ImageIcon categories_applications_accessories(Res res) { return getIcon("categories/applications-accessories.png", res); }
    public static ImageIcon categories_applications_development(Res res) { return getIcon("categories/applications-development.png", res); }
    public static ImageIcon categories_applications_games(Res res) { return getIcon("categories/applications-games.png", res); }
    public static ImageIcon categories_applications_graphics(Res res) { return getIcon("categories/applications-graphics.png", res); }
    public static ImageIcon categories_applications_internet(Res res) { return getIcon("categories/applications-internet.png", res); }
    public static ImageIcon categories_applications_multimedia(Res res) { return getIcon("categories/applications-multimedia.png", res); }
    public static ImageIcon categories_applications_office(Res res) { return getIcon("categories/applications-office.png", res); }
    public static ImageIcon categories_applications_other(Res res) { return getIcon("categories/applications-other.png", res); }
    public static ImageIcon categories_applications_system(Res res) { return getIcon("categories/applications-system.png", res); }
    public static ImageIcon categories_preferences_desktop_peripherals(Res res) { return getIcon("categories/preferences-desktop-peripherals.png", res); }
    public static ImageIcon categories_preferences_desktop(Res res) { return getIcon("categories/preferences-desktop.png", res); }
    public static ImageIcon categories_preferences_system(Res res) { return getIcon("categories/preferences-system.png", res); }
    public static ImageIcon devices_audio_card(Res res) { return getIcon("devices/audio-card.png", res); }
    public static ImageIcon devices_audio_input_microphone(Res res) { return getIcon("devices/audio-input-microphone.png", res); }
    public static ImageIcon devices_battery(Res res) { return getIcon("devices/battery.png", res); }
    public static ImageIcon devices_camera_photo(Res res) { return getIcon("devices/camera-photo.png", res); }
    public static ImageIcon devices_camera_video(Res res) { return getIcon("devices/camera-video.png", res); }
    public static ImageIcon devices_computer(Res res) { return getIcon("devices/computer.png", res); }
    public static ImageIcon devices_drive_harddisk(Res res) { return getIcon("devices/drive-harddisk.png", res); }
    public static ImageIcon devices_drive_optical(Res res) { return getIcon("devices/drive-optical.png", res); }
    public static ImageIcon devices_drive_removable_media(Res res) { return getIcon("devices/drive-removable-media.png", res); }
    public static ImageIcon devices_input_gaming(Res res) { return getIcon("devices/input-gaming.png", res); }
    public static ImageIcon devices_input_keyboard(Res res) { return getIcon("devices/input-keyboard.png", res); }
    public static ImageIcon devices_input_mouse(Res res) { return getIcon("devices/input-mouse.png", res); }
    public static ImageIcon devices_media_flash(Res res) { return getIcon("devices/media-flash.png", res); }
    public static ImageIcon devices_media_floppy(Res res) { return getIcon("devices/media-floppy.png", res); }
    public static ImageIcon devices_media_optical(Res res) { return getIcon("devices/media-optical.png", res); }
    public static ImageIcon devices_multimedia_player(Res res) { return getIcon("devices/multimedia-player.png", res); }
    public static ImageIcon devices_network_wired(Res res) { return getIcon("devices/network-wired.png", res); }
    public static ImageIcon devices_network_wireless(Res res) { return getIcon("devices/network-wireless.png", res); }
    public static ImageIcon devices_printer(Res res) { return getIcon("devices/printer.png", res); }
    public static ImageIcon devices_video_display(Res res) { return getIcon("devices/video-display.png", res); }
    public static ImageIcon emblems_emblem_favorite(Res res) { return getIcon("emblems/emblem-favorite.png", res); }
    public static ImageIcon emblems_emblem_important(Res res) { return getIcon("emblems/emblem-important.png", res); }
    public static ImageIcon emblems_emblem_photos(Res res) { return getIcon("emblems/emblem-photos.png", res); }
    public static ImageIcon emblems_emblem_readonly(Res res) { return getIcon("emblems/emblem-readonly.png", res); }
    public static ImageIcon emblems_emblem_symbolic_link(Res res) { return getIcon("emblems/emblem-symbolic-link.png", res); }
    public static ImageIcon emblems_emblem_system(Res res) { return getIcon("emblems/emblem-system.png", res); }
    public static ImageIcon emblems_emblem_unreadable(Res res) { return getIcon("emblems/emblem-unreadable.png", res); }
    public static ImageIcon emotes_face_angel(Res res) { return getIcon("emotes/face-angel.png", res); }
    public static ImageIcon emotes_face_crying(Res res) { return getIcon("emotes/face-crying.png", res); }
    public static ImageIcon emotes_face_devilish(Res res) { return getIcon("emotes/face-devilish.png", res); }
    public static ImageIcon emotes_face_glasses(Res res) { return getIcon("emotes/face-glasses.png", res); }
    public static ImageIcon emotes_face_grin(Res res) { return getIcon("emotes/face-grin.png", res); }
    public static ImageIcon emotes_face_kiss(Res res) { return getIcon("emotes/face-kiss.png", res); }
    public static ImageIcon emotes_face_monkey(Res res) { return getIcon("emotes/face-monkey.png", res); }
    public static ImageIcon emotes_face_plain(Res res) { return getIcon("emotes/face-plain.png", res); }
    public static ImageIcon emotes_face_sad(Res res) { return getIcon("emotes/face-sad.png", res); }
    public static ImageIcon emotes_face_smile_big(Res res) { return getIcon("emotes/face-smile-big.png", res); }
    public static ImageIcon emotes_face_smile(Res res) { return getIcon("emotes/face-smile.png", res); }
    public static ImageIcon emotes_face_surprise(Res res) { return getIcon("emotes/face-surprise.png", res); }
    public static ImageIcon emotes_face_wink(Res res) { return getIcon("emotes/face-wink.png", res); }
    public static ImageIcon mimetypes_application_certificate(Res res) { return getIcon("mimetypes/application-certificate.png", res); }
    public static ImageIcon mimetypes_application_x_executable(Res res) { return getIcon("mimetypes/application-x-executable.png", res); }
    public static ImageIcon mimetypes_audio_x_generic(Res res) { return getIcon("mimetypes/audio-x-generic.png", res); }
    public static ImageIcon mimetypes_font_x_generic(Res res) { return getIcon("mimetypes/font-x-generic.png", res); }
    public static ImageIcon mimetypes_image_x_generic(Res res) { return getIcon("mimetypes/image-x-generic.png", res); }
    public static ImageIcon mimetypes_package_x_generic(Res res) { return getIcon("mimetypes/package-x-generic.png", res); }
    public static ImageIcon mimetypes_text_html(Res res) { return getIcon("mimetypes/text-html.png", res); }
    public static ImageIcon mimetypes_text_x_generic_template(Res res) { return getIcon("mimetypes/text-x-generic-template.png", res); }
    public static ImageIcon mimetypes_text_x_generic(Res res) { return getIcon("mimetypes/text-x-generic.png", res); }
    public static ImageIcon mimetypes_text_x_script(Res res) { return getIcon("mimetypes/text-x-script.png", res); }
    public static ImageIcon mimetypes_video_x_generic(Res res) { return getIcon("mimetypes/video-x-generic.png", res); }
    public static ImageIcon mimetypes_x_office_address_book(Res res) { return getIcon("mimetypes/x-office-address-book.png", res); }
    public static ImageIcon mimetypes_x_office_calendar(Res res) { return getIcon("mimetypes/x-office-calendar.png", res); }
    public static ImageIcon mimetypes_x_office_document_template(Res res) { return getIcon("mimetypes/x-office-document-template.png", res); }
    public static ImageIcon mimetypes_x_office_document(Res res) { return getIcon("mimetypes/x-office-document.png", res); }
    public static ImageIcon mimetypes_x_office_drawing_template(Res res) { return getIcon("mimetypes/x-office-drawing-template.png", res); }
    public static ImageIcon mimetypes_x_office_drawing(Res res) { return getIcon("mimetypes/x-office-drawing.png", res); }
    public static ImageIcon mimetypes_x_office_presentation_template(Res res) { return getIcon("mimetypes/x-office-presentation-template.png", res); }
    public static ImageIcon mimetypes_x_office_presentation(Res res) { return getIcon("mimetypes/x-office-presentation.png", res); }
    public static ImageIcon mimetypes_x_office_spreadsheet_template(Res res) { return getIcon("mimetypes/x-office-spreadsheet-template.png", res); }
    public static ImageIcon mimetypes_x_office_spreadsheet(Res res) { return getIcon("mimetypes/x-office-spreadsheet.png", res); }
    public static ImageIcon places_folder_remote(Res res) { return getIcon("places/folder-remote.png", res); }
    public static ImageIcon places_folder_saved_search(Res res) { return getIcon("places/folder-saved-search.png", res); }
    public static ImageIcon places_folder(Res res) { return getIcon("places/folder.png", res); }
    public static ImageIcon places_network_server(Res res) { return getIcon("places/network-server.png", res); }
    public static ImageIcon places_network_workgroup(Res res) { return getIcon("places/network-workgroup.png", res); }
    public static ImageIcon places_start_here(Res res) { return getIcon("places/start-here.png", res); }
    public static ImageIcon places_user_desktop(Res res) { return getIcon("places/user-desktop.png", res); }
    public static ImageIcon places_user_home(Res res) { return getIcon("places/user-home.png", res); }
    public static ImageIcon places_user_trash(Res res) { return getIcon("places/user-trash.png", res); }
    public static ImageIcon status_audio_volume_high(Res res) { return getIcon("status/audio-volume-high.png", res); }
    public static ImageIcon status_audio_volume_low(Res res) { return getIcon("status/audio-volume-low.png", res); }
    public static ImageIcon status_audio_volume_medium(Res res) { return getIcon("status/audio-volume-medium.png", res); }
    public static ImageIcon status_audio_volume_muted(Res res) { return getIcon("status/audio-volume-muted.png", res); }
    public static ImageIcon status_battery_caution(Res res) { return getIcon("status/battery-caution.png", res); }
    public static ImageIcon status_dialog_error(Res res) { return getIcon("status/dialog-error.png", res); }
    public static ImageIcon status_dialog_information(Res res) { return getIcon("status/dialog-information.png", res); }
    public static ImageIcon status_dialog_warning(Res res) { return getIcon("status/dialog-warning.png", res); }
    public static ImageIcon status_folder_drag_accept(Res res) { return getIcon("status/folder-drag-accept.png", res); }
    public static ImageIcon status_folder_open(Res res) { return getIcon("status/folder-open.png", res); }
    public static ImageIcon status_folder_visiting(Res res) { return getIcon("status/folder-visiting.png", res); }
    public static ImageIcon status_image_loading(Res res) { return getIcon("status/image-loading.png", res); }
    public static ImageIcon status_image_missing(Res res) { return getIcon("status/image-missing.png", res); }
    public static ImageIcon status_mail_attachment(Res res) { return getIcon("status/mail-attachment.png", res); }
    public static ImageIcon status_network_error(Res res) { return getIcon("status/network-error.png", res); }
    public static ImageIcon status_network_idle(Res res) { return getIcon("status/network-idle.png", res); }
    public static ImageIcon status_network_offline(Res res) { return getIcon("status/network-offline.png", res); }
    public static ImageIcon status_network_receive(Res res) { return getIcon("status/network-receive.png", res); }
    public static ImageIcon status_network_transmit_receive(Res res) { return getIcon("status/network-transmit-receive.png", res); }
    public static ImageIcon status_network_transmit(Res res) { return getIcon("status/network-transmit.png", res); }
    public static ImageIcon status_network_wireless_encrypted(Res res) { return getIcon("status/network-wireless-encrypted.png", res); }
    public static ImageIcon status_printer_error(Res res) { return getIcon("status/printer-error.png", res); }
    public static ImageIcon status_software_update_available(Res res) { return getIcon("status/software-update-available.png", res); }
    public static ImageIcon status_software_update_urgent(Res res) { return getIcon("status/software-update-urgent.png", res); }
    public static ImageIcon status_user_trash_full(Res res) { return getIcon("status/user-trash-full.png", res); }
    public static ImageIcon status_weather_clear_night(Res res) { return getIcon("status/weather-clear-night.png", res); }
    public static ImageIcon status_weather_clear(Res res) { return getIcon("status/weather-clear.png", res); }
    public static ImageIcon status_weather_few_clouds_night(Res res) { return getIcon("status/weather-few-clouds-night.png", res); }
    public static ImageIcon status_weather_few_clouds(Res res) { return getIcon("status/weather-few-clouds.png", res); }
    public static ImageIcon status_weather_overcast(Res res) { return getIcon("status/weather-overcast.png", res); }
    public static ImageIcon status_weather_severe_alert(Res res) { return getIcon("status/weather-severe-alert.png", res); }
    public static ImageIcon status_weather_showers_scattered(Res res) { return getIcon("status/weather-showers-scattered.png", res); }
    public static ImageIcon status_weather_showers(Res res) { return getIcon("status/weather-showers.png", res); }
    public static ImageIcon status_weather_snow(Res res) { return getIcon("status/weather-snow.png", res); }
    public static ImageIcon status_weather_storm(Res res) { return getIcon("status/weather-storm.png", res); }


    private TangoIcons() {
    }

    private static ImageIcon getIcon(String name, Res res) {
        String resourceName = "tango/" + res + "/" + name;
        return ImageUtilities.loadImageIcon(resourceName, false);
    }
}