/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.HashMap;
import java.util.Map;
import org.esa.snap.statistics.tools.MapInverter;
import org.junit.Assert;
import org.junit.Test;

public class MapInverterTest {
    @Test
    public void testInverting() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Key1", "Value1");
        map.put("Key2", "Value2");
        map.put("Key3", "Value3");
        Map swappedMap = MapInverter.createInvertedTreeMap(map);
        Assert.assertNotNull((Object)swappedMap);
        Assert.assertEquals((long)3L, (long)swappedMap.size());
        Assert.assertEquals((Object)"Key1", swappedMap.get("Value1"));
        Assert.assertEquals((Object)"Key2", swappedMap.get("Value2"));
        Assert.assertEquals((Object)"Key3", swappedMap.get("Value3"));
    }

    @Test
    public void testIllegalArgumentException_IfMapNotContainsOnlyUniqueValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Key1", "Value1");
        map.put("Key2", "Value");
        map.put("Key3", "Value");
        try {
            MapInverter.createInvertedTreeMap(map);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Throwable e) {
            Assert.fail((String)"IllegalArgumentException expected");
        }
    }
}

