/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.statistics.TestUtil;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.EsriShapeFileWriter;
import org.esa.snap.statistics.output.FeatureStatisticsWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;

public class EsriShapeFileWriterTest {
    static File testdataDir;

    @After
    public void tearDown() throws Exception {
        TestUtil.deleteTreeOnExit(testdataDir);
    }

    @Test
    public void testSingleShape() throws Exception {
        testdataDir = new File("target/statistics-test-io_1");
        File targetShapefile = EsriShapeFileWriterTest.getTestFile("4_pixels_output.shp").getAbsoluteFile();
        List<SimpleFeature> featureWithAdaptedStatistic = this.get4PixelsFeaturesWithAdaptedStatistic();
        EsriShapeFileWriter.write(featureWithAdaptedStatistic, (File)targetShapefile);
        FeatureSource featureSource = FeatureUtils.getFeatureSource((URL)targetShapefile.toURI().toURL());
        FeatureCollection features = featureSource.getFeatures();
        Assert.assertEquals((long)1L, (long)features.size());
        SimpleFeature simpleFeature = (SimpleFeature)features.features().next();
        Assert.assertNotNull((Object)simpleFeature.getProperty("p90_lgl2"));
        Assert.assertNotNull((Object)simpleFeature.getProperty("p95_lgl2"));
        Assert.assertEquals((double)0.1, (double)((Double)simpleFeature.getProperty("p90_lgl2").getValue()), (double)1.0E-6);
        Assert.assertEquals((double)0.195, (double)((Double)simpleFeature.getProperty("p95_lgl2").getValue()), (double)1.0E-6);
    }

    private List<SimpleFeature> get4PixelsFeaturesWithAdaptedStatistic() {
        URL originalShapefile = this.getClass().getResource("../4_pixels.shp");
        FeatureStatisticsWriter featureStatisticsWriter = FeatureStatisticsWriter.createFeatureStatisticsWriter((URL)originalShapefile, null, (BandNameCreator)new BandNameCreator());
        String[] algorithmNames = new String[]{"p90", "p95"};
        featureStatisticsWriter.initialiseOutput(StatisticsOutputContext.create((String[])new String[]{"algal_2"}, (String[])algorithmNames));
        HashMap<String, Double> statistics = new HashMap<String, Double>();
        statistics.put("p90", 0.1);
        featureStatisticsWriter.addToOutput("algal_2", "4_pixels.1", statistics);
        statistics.clear();
        statistics.put("p95", 0.195);
        featureStatisticsWriter.addToOutput("algal_2", "4_pixels.1", statistics);
        return featureStatisticsWriter.getFeatures();
    }

    static File getTestFile(String fileName) {
        testdataDir.mkdirs();
        return new File(testdataDir, fileName);
    }
}

