/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.esa.snap.statistics.tools.GeometryID;

public class DatabaseRecord {
    public final GeometryID geomId;
    public final String geomName;
    private final Map<Date, Map<String, String>> data;

    public DatabaseRecord(GeometryID geomId, String geomName) {
        this.geomId = geomId;
        this.geomName = geomName;
        this.data = new TreeMap<Date, Map<String, String>>();
    }

    public void addStatisticalData(Date date, Map<String, String> statData) {
        if (this.data.containsKey(date)) {
            throw new IllegalStateException("The record already contains data for the day '" + date + "'");
        }
        this.data.put(date, statData);
    }

    public Set<Date> getDataDates() {
        return this.data.keySet();
    }

    public Set<String> getStatDataColumns(Date date) {
        Map<String, String> statData = this.data.get(date);
        if (statData != null) {
            return statData.keySet();
        }
        return null;
    }

    public String getValue(Date date, String statName) {
        if (!this.data.containsKey(date)) {
            return "";
        }
        Map<String, String> statData = this.data.get(date);
        if (!statData.containsKey(statName)) {
            return "";
        }
        return statData.get(statName);
    }
}

