/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.util.TreeSet;
import org.esa.snap.statistics.tools.StatisticalMappingAnalyser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticalMappingAnalyserTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test_OneStatisticalMeasurement_TwoGeophysicalParameter() {
        TreeSet<String> fullNames = new TreeSet<String>();
        fullNames.add("median_CHL");
        fullNames.add("median_YS");
        StatisticalMappingAnalyser mappingAnalyser = new StatisticalMappingAnalyser(fullNames);
        Assert.assertEquals((long)1L, (long)mappingAnalyser.getStatisticalMeasureNames().length);
        Assert.assertEquals((Object)"median", (Object)mappingAnalyser.getStatisticalMeasureNames()[0]);
        Assert.assertEquals((long)2L, (long)mappingAnalyser.getGeophysicalParameterNames().length);
        Assert.assertEquals((Object)"CHL", (Object)mappingAnalyser.getGeophysicalParameterNames()[0]);
        Assert.assertEquals((Object)"YS", (Object)mappingAnalyser.getGeophysicalParameterNames()[1]);
    }

    @Test
    public void test_TwoStatisticalMeasurement_OneGeophysicalParameter() {
        TreeSet<String> fullNames = new TreeSet<String>();
        fullNames.add("median_CHL");
        fullNames.add("minimum_CHL");
        StatisticalMappingAnalyser mappingAnalyser = new StatisticalMappingAnalyser(fullNames);
        Assert.assertEquals((long)2L, (long)mappingAnalyser.getStatisticalMeasureNames().length);
        Assert.assertEquals((Object)"median", (Object)mappingAnalyser.getStatisticalMeasureNames()[0]);
        Assert.assertEquals((Object)"minimum", (Object)mappingAnalyser.getStatisticalMeasureNames()[1]);
        Assert.assertEquals((long)1L, (long)mappingAnalyser.getGeophysicalParameterNames().length);
        Assert.assertEquals((Object)"CHL", (Object)mappingAnalyser.getGeophysicalParameterNames()[0]);
    }

    @Test
    public void testWithManyOfBothSides() {
        TreeSet<String> fullNames = new TreeSet<String>();
        fullNames.add("median_CHL");
        fullNames.add("median_YS");
        fullNames.add("median_TSM");
        fullNames.add("minimum_CHL");
        fullNames.add("minimum_YS");
        fullNames.add("minimum_TSM");
        fullNames.add("max_error_CHL");
        fullNames.add("max_error_YS");
        fullNames.add("max_error_TSM");
        fullNames.add("maximum_CHL");
        fullNames.add("maximum_YS");
        fullNames.add("maximum_TSM");
        fullNames.add("average_CHL");
        fullNames.add("average_YS");
        fullNames.add("average_TSM");
        fullNames.add("sigma_CHL");
        fullNames.add("sigma_YS");
        fullNames.add("sigma_TSM");
        fullNames.add("p90_threshold_CHL");
        fullNames.add("p90_threshold_YS");
        fullNames.add("p90_threshold_TSM");
        StatisticalMappingAnalyser mappingAnalyser = new StatisticalMappingAnalyser(fullNames);
        Assert.assertEquals((long)7L, (long)mappingAnalyser.getStatisticalMeasureNames().length);
        Assert.assertEquals((Object)"average", (Object)mappingAnalyser.getStatisticalMeasureNames()[0]);
        Assert.assertEquals((Object)"max_error", (Object)mappingAnalyser.getStatisticalMeasureNames()[1]);
        Assert.assertEquals((Object)"maximum", (Object)mappingAnalyser.getStatisticalMeasureNames()[2]);
        Assert.assertEquals((Object)"median", (Object)mappingAnalyser.getStatisticalMeasureNames()[3]);
        Assert.assertEquals((Object)"minimum", (Object)mappingAnalyser.getStatisticalMeasureNames()[4]);
        Assert.assertEquals((Object)"p90_threshold", (Object)mappingAnalyser.getStatisticalMeasureNames()[5]);
        Assert.assertEquals((Object)"sigma", (Object)mappingAnalyser.getStatisticalMeasureNames()[6]);
        Assert.assertEquals((long)3L, (long)mappingAnalyser.getGeophysicalParameterNames().length);
        Assert.assertEquals((Object)"CHL", (Object)mappingAnalyser.getGeophysicalParameterNames()[0]);
        Assert.assertEquals((Object)"TSM", (Object)mappingAnalyser.getGeophysicalParameterNames()[1]);
        Assert.assertEquals((Object)"YS", (Object)mappingAnalyser.getGeophysicalParameterNames()[2]);
    }

    @Test
    public void testStingSortingAlongLenth() {
        Object[] strings = new String[]{"1", "22", "333", "4444", "55555"};
        StatisticalMappingAnalyser.sortAlongLength_BiggestFirst((String[])strings);
        Assert.assertArrayEquals((Object[])new String[]{"55555", "4444", "333", "22", "1"}, (Object[])strings);
    }
}

