/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import org.esa.snap.statistics.output.CsvStatisticsWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CsvStatisticsWriterTest {
    private CsvStatisticsWriter csvStatisticsWriter;
    private StringBuilder csvOutput;
    private PrintStream csvStream;

    @Before
    public void setUp() throws Exception {
        this.csvOutput = new StringBuilder();
        this.csvStream = new PrintStream(new StringOutputStream(this.csvOutput));
        this.csvStatisticsWriter = new CsvStatisticsWriter(this.csvStream);
    }

    @Test
    public void testAddToOutput() throws Exception {
        this.addOutput();
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_cow_density_index_(ncdi)").getDataForRegionName("werdohl").getDataForAlgorithmName("p95").doubleValue(), (double)3.0, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_cow_density_index_(ncdi)").getDataForRegionName("werdohl").getDataForAlgorithmName("p90").doubleValue(), (double)2.0, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_pig_density_index_(npdi)").getDataForRegionName("bielefeld").getDataForAlgorithmName("p90").doubleValue(), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_pig_density_index_(npdi)").getDataForRegionName("bielefeld").getDataForAlgorithmName("p95").doubleValue(), (double)2.0, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_pig_density_index_(npdi)").getDataForRegionName("bielefeld").getDataForAlgorithmName("max").doubleValue(), (double)3.0, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_pig_density_index_(npdi)").getDataForRegionName("bielefeld").getDataForAlgorithmName("min").doubleValue(), (double)0.5, (double)1.0E-6);
        Assert.assertEquals((double)this.csvStatisticsWriter.statisticsContainer.getDataForBandName("normalised_cow_density_index_(ncdi)").getDataForRegionName("bielefeld").getDataForAlgorithmName("p90").doubleValue(), (double)1.0, (double)1.0E-6);
    }

    @Test
    public void testFinaliseOutput() throws Exception {
        this.csvStatisticsWriter.initialiseOutput(StatisticsOutputContext.create(null, (String[])new String[]{"p90", "p95", "max", "min"}));
        this.addOutput();
        this.csvStatisticsWriter.finaliseOutput();
        this.csvStream.close();
        String actualOutput = this.csvOutput.toString();
        Assert.assertTrue((boolean)actualOutput.startsWith("# Region\tBand\tmax\tmin\tp90\tp95\n"));
        Assert.assertTrue((boolean)actualOutput.contains("werdohl\tnormalised_cow_density_index_(ncdi)\t\t\t2.0000\t3.0000\n"));
        Assert.assertTrue((boolean)actualOutput.contains("bielefeld\tnormalised_cow_density_index_(ncdi)\t\t\t1.0000\t3.0000\n"));
        Assert.assertTrue((boolean)actualOutput.contains("bielefeld\tnormalised_pig_density_index_(npdi)\t3.0000\t0.5000\t1.0000\t2.0000\n"));
    }

    @Test
    public void testGetValueAsString() throws Exception {
        Assert.assertEquals((Object)"0.0016", (Object)CsvStatisticsWriter.getValueAsString((Number)0.0016));
        Assert.assertEquals((Object)"10.0000", (Object)CsvStatisticsWriter.getValueAsString((Number)10.0));
        Assert.assertEquals((Object)"10", (Object)CsvStatisticsWriter.getValueAsString((Number)10));
    }

    private void addOutput() {
        HashMap<String, Double> statistics = new HashMap<String, Double>();
        statistics.put("p90", 2.0);
        statistics.put("p95", 3.0);
        this.csvStatisticsWriter.addToOutput("normalised_cow_density_index_(ncdi)", "werdohl", statistics);
        statistics.put("p90", 1.0);
        this.csvStatisticsWriter.addToOutput("normalised_cow_density_index_(ncdi)", "bielefeld", statistics);
        statistics.put("p90", 1.0);
        statistics.put("p95", 2.0);
        statistics.put("max", 3.0);
        statistics.put("min", 0.5);
        this.csvStatisticsWriter.addToOutput("normalised_pig_density_index_(npdi)", "bielefeld", statistics);
    }

    static class StringOutputStream
    extends OutputStream {
        StringBuilder builder;

        StringOutputStream(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void write(int b) throws IOException {
            byte b1 = (byte)b;
            this.builder.append(new String(new byte[]{b1}));
        }
    }
}

