/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import java.io.IOException;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.StatisticsOp;
import org.esa.snap.statistics.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticsOpTest_ValidateInputTest {
    private StatisticsOp statisticsOp;

    @Before
    public void setUp() throws Exception {
        this.statisticsOp = new StatisticsOp();
        this.statisticsOp.setParameterDefaultValues();
        this.statisticsOp.startDate = ProductData.UTC.parse((String)"2010-01-31 14:45:23", (String)"yyyy-MM-ss hh:mm:ss");
        this.statisticsOp.endDate = ProductData.UTC.parse((String)"2010-01-31 14:46:23", (String)"yyyy-MM-ss hh:mm:ss");
        this.statisticsOp.accuracy = 0;
        this.statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testValidation_PrecisionLessThanMinPrecision() {
        this.statisticsOp.accuracy = -1;
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertEquals((Object)"Parameter 'accuracy' must be greater than or equal to 0", (Object)expected.getMessage());
        }
    }

    @Test
    public void testValidation_PrecisionGreaterThanMaxPrecision() {
        this.statisticsOp.accuracy = 7;
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertEquals((Object)"Parameter 'accuracy' must be less than or equal to 6", (Object)expected.getMessage());
        }
    }

    @Test
    public void testStartDateHasToBeBeforeEndDate() throws Exception {
        this.statisticsOp.startDate = ProductData.UTC.parse((String)"2010-01-31 14:46:23", (String)"yyyy-MM-ss hh:mm:ss");
        this.statisticsOp.endDate = ProductData.UTC.parse((String)"2010-01-31 14:45:23", (String)"yyyy-MM-ss hh:mm:ss");
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("before start date"));
        }
    }

    @Test
    public void testSourceProductsMustBeGiven() {
        this.statisticsOp.sourceProducts = null;
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("must be given"));
        }
        this.statisticsOp.sourceProducts = new Product[0];
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("must be given"));
        }
    }

    @Test
    public void testInvalidBandConfiguration() throws IOException {
        BandConfiguration configuration = new BandConfiguration();
        this.statisticsOp.bandConfigurations = new BandConfiguration[]{configuration};
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("must contain either a source band name or an expression"));
        }
        configuration.expression = "algal_2 * PI";
        configuration.sourceBandName = "bandname";
        try {
            this.statisticsOp.validateInput();
            Assert.fail();
        }
        catch (OperatorException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("must contain either a source band name or an expression"));
        }
    }

    @Test
    public void testValidBandConfiguration() throws IOException {
        BandConfiguration configuration = new BandConfiguration();
        this.statisticsOp.bandConfigurations = new BandConfiguration[]{configuration};
        configuration.expression = "algal_2 * PI";
        this.statisticsOp.validateInput();
        configuration.expression = null;
        configuration.sourceBandName = "bandname";
        this.statisticsOp.validateInput();
    }
}

