/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.StatisticsOp;
import org.esa.snap.statistics.TestUtil;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatisticsOpTest {
    static final File TESTDATA_DIR = new File("target/statistics-test-io");

    @Before
    public void setUp() throws Exception {
        TESTDATA_DIR.mkdirs();
        if (!TESTDATA_DIR.isDirectory()) {
            Assert.fail((String)("Can't create test I/O directory: " + TESTDATA_DIR));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (!FileUtils.deleteTree((File)TESTDATA_DIR)) {
            System.out.println("Warning: failed to completely delete test I/O directory:" + TESTDATA_DIR);
        }
    }

    @Test
    public void testThatStatisticsOpIsRegistered() throws Exception {
        Assert.assertNotNull((Object)GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi("StatisticsOp"));
    }

    @Test
    public void testStatisticsOp() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.statisticsOutputters.add(outputter);
        statisticsOp.initialize();
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[1], (double)0.001);
    }

    @Test
    public void testStatisticsOp_WithPrecisePercentiles() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        statisticsOp.accuracy = 6;
        MyOutputter outputter = new MyOutputter();
        statisticsOp.statisticsOutputters.add(outputter);
        statisticsOp.initialize();
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)1.0E-6);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)1.0E-6);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)1.0E-6);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)1.0E-6);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)1.0E-6);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[0], (double)1.0E-6);
        Assert.assertEquals((double)0.80447364, (double)outputter.percentiles[1], (double)1.0E-6);
    }

    @Test
    public void testStatisticsOp_WithExpression() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.expression = "algal_2 * PI";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.statisticsOutputters.add(outputter);
        statisticsOp.initialize();
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2_*_PI", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)2.527328, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)2.186098, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)2.354394, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)2.266823, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.155752, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)2.527328, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)2.527328, (double)outputter.percentiles[1], (double)0.001);
    }

    @Test
    public void testStatisticsOp_WithValidExpression() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        bandConfiguration.validPixelExpression = "algal_2 > 0.7";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        MyOutputter outputter = new MyOutputter();
        statisticsOp.statisticsOutputters.add(outputter);
        statisticsOp.initialize();
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)3L, (long)outputter.pixels);
        Assert.assertEquals((double)0.8045, (double)outputter.maximum, (double)1.0E-4);
        Assert.assertEquals((double)0.7216, (double)outputter.minimum, (double)1.0E-4);
        Assert.assertEquals((double)0.7672, (double)outputter.average, (double)1.0E-4);
        Assert.assertEquals((double)0.7758, (double)outputter.median, (double)1.0E-4);
        Assert.assertEquals((double)0.0421, (double)outputter.sigma, (double)1.0E-4);
        Assert.assertEquals((long)2L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.8044, (double)outputter.percentiles[0], (double)1.0E-4);
        Assert.assertEquals((double)0.8044, (double)outputter.percentiles[1], (double)1.0E-4);
    }

    @Test
    public void testGetBand() throws Exception {
        BandConfiguration configuration = new BandConfiguration();
        Product testProduct = TestUtil.getTestProduct();
        configuration.expression = "algal_2 * PI";
        configuration.sourceBandName = null;
        Band virtualBand = StatisticsOp.getBand((BandConfiguration)configuration, (Product)testProduct);
        Assert.assertEquals((Object)"algal_2_*_PI", (Object)virtualBand.getName());
        Assert.assertTrue((boolean)(virtualBand instanceof VirtualBand));
        Assert.assertEquals((Object)"algal_2 * PI", (Object)((VirtualBand)virtualBand).getExpression());
    }

    @Test
    public void testStatisticsOp_WithGPF() throws Exception {
        BandConfiguration bandConfiguration_1 = new BandConfiguration();
        bandConfiguration_1.sourceBandName = "algal_2";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("outputAsciiFile", StatisticsOpTest.getTestFile("statisticsOutput.out"));
        parameters.put("outputShapefile", StatisticsOpTest.getTestFile("statisticsShapefile.shp"));
        parameters.put("doOutputAsciiFile", true);
        parameters.put("doOutputShapefile", true);
        parameters.put("shapefile", new File(this.getClass().getResource("4_pixels.shp").toURI()));
        parameters.put("bandConfigurations", new BandConfiguration[]{bandConfiguration_1});
        GPF.createProduct((String)"StatisticsOp", parameters, (Product)TestUtil.getTestProduct());
        Assert.assertFalse((boolean)StatisticsOpTest.getTestFile("statisticsOutput.put").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsOutput.out").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsOutput_metadata.txt").exists());
        Assert.assertTrue((boolean)StatisticsOpTest.getTestFile("statisticsShapefile.shp").exists());
    }

    @Test
    public void testStatisticsOp_WithDifferentPercentiles() throws Exception {
        StatisticsOp statisticsOp = this.createStatisticsOp();
        BandConfiguration bandConfiguration = new BandConfiguration();
        bandConfiguration.sourceBandName = "algal_2";
        statisticsOp.bandConfigurations = new BandConfiguration[]{bandConfiguration};
        statisticsOp.sourceProducts = new Product[]{TestUtil.getTestProduct()};
        statisticsOp.shapefile = new File(this.getClass().getResource("4_pixels.shp").getFile());
        statisticsOp.percentiles = new int[]{20, 51, 90};
        MyOutputter outputter = new MyOutputter();
        statisticsOp.statisticsOutputters.add(outputter);
        statisticsOp.initialize();
        Assert.assertEquals((Object)"4_pixels.1", (Object)outputter.region);
        Assert.assertEquals((Object)"algal_2", (Object)outputter.bandName);
        Assert.assertEquals((long)4L, (long)outputter.pixels);
        Assert.assertEquals((double)0.804474, (double)outputter.maximum, (double)0.001);
        Assert.assertEquals((double)0.695857, (double)outputter.minimum, (double)0.001);
        Assert.assertEquals((double)0.749427, (double)outputter.average, (double)0.001);
        Assert.assertEquals((double)0.721552, (double)outputter.median, (double)0.001);
        Assert.assertEquals((double)0.049577, (double)outputter.sigma, (double)0.001);
        Assert.assertEquals((long)3L, (long)outputter.percentiles.length);
        Assert.assertEquals((double)0.6958565, (double)outputter.percentiles[0], (double)0.001);
        Assert.assertEquals((double)0.775825, (double)outputter.percentiles[1], (double)0.001);
        Assert.assertEquals((double)0.804474, (double)outputter.percentiles[2], (double)0.001);
    }

    @Test
    public void testUtcConverter() throws Exception {
        StatisticsOp.UtcConverter utcConverter = new StatisticsOp.UtcConverter();
        Assert.assertEquals(ProductData.UTC.class, (Object)utcConverter.getValueType());
        ProductData.UTC actual = utcConverter.parse("2010-01-31 14:46:22");
        long expected = ProductData.UTC.parse((String)"2010-01-31 14:46:22", (String)"yyyy-MM-dd hh:mm:ss").getAsDate().getTime();
        Assert.assertEquals((long)expected, (long)actual.getAsDate().getTime());
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31'T'14:46:22.1234");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-31-01'T'14:46:22.123");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31T14:46:22.123");
        StatisticsOpTest.assertConversionException((Converter)utcConverter, "2010-01-31'T'14.46.22.123");
    }

    @Test
    public void testProductAlreadyOpened() {
        File file = new File("test.file");
        Product product = new Product("name", "type", 20, 40);
        product.setFileLocation(file);
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(product);
        Assert.assertTrue((boolean)StatisticsOp.isProductAlreadyOpened(products, (File)file));
        Assert.assertFalse((boolean)StatisticsOp.isProductAlreadyOpened(products, (File)new File("other.path")));
    }

    private StatisticsOp createStatisticsOp() {
        StatisticsOp statisticsOp = new StatisticsOp();
        statisticsOp.setParameterDefaultValues();
        return statisticsOp;
    }

    private static void assertConversionException(Converter converter, String text) {
        try {
            converter.parse(text);
            Assert.fail();
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    static File getTestFile(String fileName) {
        return new File(TESTDATA_DIR, fileName);
    }

    private static class MyOutputter
    implements StatisticsOutputter {
        int pixels;
        double minimum;
        double maximum;
        double average;
        double median;
        double sigma;
        double[] percentiles = new double[2];
        String region;
        String bandName;

        public void initialiseOutput(StatisticsOutputContext statisticsOutputContext) {
            int numPercentiles = 0;
            for (String algorithmName : statisticsOutputContext.algorithmNames) {
                if (!algorithmName.matches("p\\d\\d_threshold")) continue;
                ++numPercentiles;
            }
            this.percentiles = new double[numPercentiles];
        }

        public void addToOutput(String bandName, String regionId, Map<String, Number> statistics) {
            TreeMap<String, Number> map = new TreeMap<String, Number>();
            map.putAll(statistics);
            this.region = regionId;
            this.bandName = bandName;
            int percentileIndex = 0;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("total")) {
                    this.pixels = ((Number)entry.getValue()).intValue();
                    continue;
                }
                if (key.equalsIgnoreCase("minimum")) {
                    this.minimum = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("maximum")) {
                    this.maximum = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("average")) {
                    this.average = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("median")) {
                    this.median = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (key.equalsIgnoreCase("sigma")) {
                    this.sigma = ((Number)entry.getValue()).doubleValue();
                    continue;
                }
                if (!key.startsWith("p") || !key.endsWith("threshold")) continue;
                this.percentiles[percentileIndex++] = ((Number)entry.getValue()).doubleValue();
            }
        }

        public void finaliseOutput() throws IOException {
        }
    }
}

