/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.StxFactory;
import org.esa.snap.core.datamodel.StxOp;
import org.esa.snap.core.datamodel.SummaryStxOp;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.HistogramExpanderTransmitter;
import org.esa.snap.statistics.output.Util;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class StatisticComputer {
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> features;
    private final FeatureUtils.FeatureCrsProvider crsProvider;
    private final ProgressMonitor pm;
    private final BandConfiguration[] bandConfigurations;
    private final Map<BandConfiguration, StxOpMapping> stxOpMappings;
    private final int initialBinCount;
    private final Logger logger;

    public StatisticComputer(File shapefile, BandConfiguration[] bandConfigurations, int initialBinCount, Logger logger) {
        this.initialBinCount = initialBinCount;
        Logger logger2 = this.logger = logger != null ? logger : SystemUtils.LOG;
        if (shapefile != null) {
            try {
                this.features = FeatureUtils.loadFeatureCollectionFromShapefile((File)shapefile);
            }
            catch (IOException e) {
                throw new OperatorException("Unable to load shapefile '" + shapefile.getAbsolutePath() + "'", (Throwable)e);
            }
        } else {
            this.features = null;
        }
        this.crsProvider = new FeatureUtils.FeatureCrsProvider(){

            public CoordinateReferenceSystem getFeatureCrs(Product targetProduct) {
                if (targetProduct.getSceneCRS() == Product.DEFAULT_IMAGE_CRS) {
                    return Product.DEFAULT_IMAGE_CRS;
                }
                return DefaultGeographicCRS.WGS84;
            }

            public boolean clipToProductBounds() {
                return true;
            }
        };
        this.pm = ProgressMonitor.NULL;
        this.bandConfigurations = bandConfigurations;
        this.stxOpMappings = new HashMap<BandConfiguration, StxOpMapping>();
    }

    public void computeStatistic(Product product) {
        VectorDataNode[] vectorDataNodes = null;
        if (this.features != null) {
            FeatureCollection productFeatures = FeatureUtils.clipFeatureCollectionToProductBounds(this.features, (Product)product, (FeatureUtils.FeatureCrsProvider)this.crsProvider, (ProgressMonitor)this.pm);
            VectorDataNode[] vectorDataNodeArray = vectorDataNodes = this.createVectorDataNodes((FeatureCollection<SimpleFeatureType, SimpleFeature>)productFeatures);
            int n = vectorDataNodeArray.length;
            for (int i = 0; i < n; ++i) {
                VectorDataNode vectorDataNode = vectorDataNodeArray[i];
                product.getVectorDataGroup().add((ProductNode)vectorDataNode);
            }
        }
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            Band band = StatisticComputer.getBand(bandConfiguration, product);
            String newExpression = bandConfiguration.validPixelExpression;
            if (newExpression != null) {
                String oldExpression = band.getValidPixelExpression();
                if (oldExpression != null) {
                    this.logger.info("Replaced old valid pixel expression '" + oldExpression + "' by '" + newExpression + "'.");
                }
                band.setValidPixelExpression(newExpression);
            }
            StxOpMapping stxOpsMapping = this.getStxOpsMapping(bandConfiguration);
            if (this.features != null) {
                for (VectorDataNode vectorDataNode : vectorDataNodes) {
                    String vdnName = vectorDataNode.getName();
                    Mask currentMask = (Mask)product.getMaskGroup().get(vdnName);
                    Shape roiShape = currentMask.getValidShape();
                    MultiLevelImage roiImage = currentMask.getSourceImage();
                    this.computeStatistic(vdnName, stxOpsMapping, band, roiShape, roiImage);
                }
                continue;
            }
            this.computeStatistic("world", stxOpsMapping, band, null, null);
        }
    }

    private void computeStatistic(String regionName, StxOpMapping stxOpsMapping, Band band, Shape roiShape, MultiLevelImage roiImage) {
        SummaryStxOp summaryStxOp = stxOpsMapping.getSummaryOp(regionName);
        StxFactory.accumulate((RasterDataNode)band, (int)0, (RenderedImage)roiImage, (Shape)roiShape, (StxOp)summaryStxOp, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.pm, (int)50));
        double minimum = summaryStxOp.getMinimum();
        double maximum = summaryStxOp.getMaximum();
        HistogramStxOp histogramStxOp = stxOpsMapping.getHistogramOp(regionName, minimum, maximum, band);
        StxFactory.accumulate((RasterDataNode)band, (int)0, (RenderedImage)roiImage, (Shape)roiShape, (StxOp)histogramStxOp, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.pm, (int)50));
    }

    private StxOpMapping getStxOpsMapping(BandConfiguration bandConfiguration) {
        StxOpMapping stxOpMapping = this.stxOpMappings.get(bandConfiguration);
        if (stxOpMapping == null) {
            stxOpMapping = new StxOpMapping(this.initialBinCount);
            this.stxOpMappings.put(bandConfiguration, stxOpMapping);
        }
        return stxOpMapping;
    }

    private VectorDataNode[] createVectorDataNodes(FeatureCollection<SimpleFeatureType, SimpleFeature> productFeatures) {
        FeatureIterator featureIterator = productFeatures.features();
        ArrayList<VectorDataNode> result = new ArrayList<VectorDataNode>();
        while (featureIterator.hasNext()) {
            SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
            DefaultFeatureCollection fc = new DefaultFeatureCollection(simpleFeature.getID(), simpleFeature.getFeatureType());
            fc.add(simpleFeature);
            String name = Util.getFeatureName(simpleFeature);
            result.add(new VectorDataNode(name, (FeatureCollection)fc));
        }
        return result.toArray(new VectorDataNode[result.size()]);
    }

    static Band getBand(BandConfiguration configuration, Product product) {
        Band band;
        if (configuration.sourceBandName != null) {
            band = product.getBand(configuration.sourceBandName);
            band.setNoDataValueUsed(true);
        } else {
            band = product.addBand(configuration.expression.replace(" ", "_"), configuration.expression, 31);
        }
        if (band == null) {
            throw new OperatorException(MessageFormat.format("Band ''{0}'' does not exist in product ''{1}''.", configuration.sourceBandName, product.getName()));
        }
        return band;
    }

    public Map<BandConfiguration, StxOpMapping> getResults() {
        return this.stxOpMappings;
    }

    static class StxOpMapping {
        final Map<String, SummaryStxOp> summaryMap = new HashMap<String, SummaryStxOp>();
        final Map<String, HistogramStxOp> histogramMap = new HashMap<String, HistogramStxOp>();
        private final int initialBinCount;

        StxOpMapping(int initialBinCount) {
            this.initialBinCount = initialBinCount;
        }

        private SummaryStxOp getSummaryOp(String vdnName) {
            SummaryStxOp summaryStxOp = this.summaryMap.get(vdnName);
            if (summaryStxOp == null) {
                summaryStxOp = new SummaryStxOp();
                this.summaryMap.put(vdnName, summaryStxOp);
            }
            return summaryStxOp;
        }

        private HistogramStxOp getHistogramOp(String vdnName, double minimum, double maximum, Band band) {
            boolean intHistogram;
            HistogramStxOp histogramStxOp = this.histogramMap.get(vdnName);
            boolean bl = intHistogram = band.getGeophysicalImage().getSampleModel().getDataType() < 4;
            if (histogramStxOp == null) {
                histogramStxOp = new HistogramStxOp(this.initialBinCount, minimum, maximum, intHistogram, false);
                this.histogramMap.put(vdnName, histogramStxOp);
            } else {
                Histogram oldHistogram = histogramStxOp.getHistogram();
                double oldMin = oldHistogram.getLowValue()[0];
                double oldMax = oldHistogram.getHighValue()[0];
                if (minimum < oldMin || maximum > oldMax) {
                    histogramStxOp = HistogramExpanderTransmitter.createExpandedHistogramOp(oldHistogram, minimum, maximum, intHistogram, this.initialBinCount);
                    this.histogramMap.put(vdnName, histogramStxOp);
                }
            }
            return histogramStxOp;
        }
    }
}

