/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.snap.statistics.tools.SummaryCSVTool;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SummaryCSVToolTest {
    private SummaryCSVTool.ShapeFileReader shapeFileReader;
    private Logger logger;
    private SummaryCSVTool summaryCSVTool;
    private File inputDir;

    @Before
    public void setUp() throws Exception {
        this.shapeFileReader = (SummaryCSVTool.ShapeFileReader)Mockito.mock(SummaryCSVTool.ShapeFileReader.class);
        this.logger = (Logger)Mockito.mock(Logger.class);
        File existingShapeFile = new File(SummaryCSVToolTest.class.getResource("20070504_out_cwbody_desh_gk3.shp").getFile());
        this.inputDir = (File)Mockito.spy((Object)existingShapeFile.getParentFile());
        this.summaryCSVTool = new SummaryCSVTool(this.logger, this.shapeFileReader, "NAME");
    }

    @Test
    public void testThatAnErrorWasLoggedIfAnIOExceptionIsThrownWhileReadingAShapeFile() throws IOException {
        String exceptionMessage = "Unable To read";
        Mockito.when((Object)this.shapeFileReader.read((File)Mockito.any(File.class))).thenThrow(new Throwable[]{new IOException("Unable To read")});
        this.summaryCSVTool.summarize(this.inputDir);
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).log(Level.WARNING, "Unable To read");
    }

    @Test
    public void testThatNoErrorIsLoggedWhenShapeFileNameDoesCorrespondToDatePattern() throws IOException {
        Mockito.when((Object)this.shapeFileReader.read((File)Mockito.any(File.class))).thenReturn(null);
        Mockito.when((Object)this.inputDir.listFiles((FilenameFilter)Mockito.any(FilenameFilter.class))).thenReturn((Object)new File[]{new File("20120509_chl.shp")});
        this.summaryCSVTool.summarize(this.inputDir);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logger});
    }

    @Test
    public void testThatAnErrorIsLoggedWhenShapeFileNameDoesNotCorrespondToDatePattern() {
        Mockito.when((Object)this.inputDir.listFiles((FilenameFilter)Mockito.any(FilenameFilter.class))).thenReturn((Object)new File[]{new File("blah_20120509.shp")});
        this.summaryCSVTool.summarize(this.inputDir);
        String expectedMessage = "The filename 'blah_20120509.shp' does not match the pattern yyyyMMdd_*.shp.";
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).log(Level.WARNING, expectedMessage);
    }
}

