/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import com.bc.ceres.binding.Property;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.operators.tooladapter.DefaultOutputConsumer;
import org.esa.snap.core.gpf.operators.tooladapter.ProcessOutputConsumer;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.utils.PrivilegedAccessor;

@OperatorMetadata(alias="ToolAdapterOp", category="Tools", version="1.0", description="Tool Adapter Operator")
public class ToolAdapterOp
extends Operator {
    private static final String INTERMEDIATE_PRODUCT_NAME = "interimProduct";
    private static final String[] DEFAULT_EXTENSIONS = new String[]{".tif", ".tiff", ".nc", ".hdf", ".pgx", ".png", ".gif", ".jpg", ".bmp", ".pnm", ".pbm", ".pgm", ".ppm", ".jp2"};
    public static final String VELOCITY_LINE_SEPARATOR = "\r\n|\n";
    private ProcessOutputConsumer consumer = null;
    private volatile boolean isStopped;
    private volatile boolean wasCancelled;
    private ToolAdapterOperatorDescriptor descriptor;
    private ProgressMonitor progressMonitor;
    private List<File> intermediateProductFiles;
    private File adapterFolder;
    private OperatorContext accessibleContext;
    private List<String> errorMessages = new ArrayList<String>();
    private VelocityContext lastPostContext;

    public ToolAdapterOp() {
        Logger logger = this.getLogger();
        try {
            this.accessibleContext = (OperatorContext)PrivilegedAccessor.getValue((Object)this, "context");
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
        Velocity.init();
        this.intermediateProductFiles = new ArrayList<File>();
        logger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (Level.SEVERE.equals(record.getLevel())) {
                    ToolAdapterOp.this.errorMessages.add(record.getMessage());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    public void setConsumer(ProcessOutputConsumer consumer) {
        this.consumer = consumer;
        if (consumer != null) {
            this.consumer.setLogger(this.getLogger());
        }
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public void stop() {
        this.isStopped = true;
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    public void setAdapterFolder(File folder) {
        this.adapterFolder = folder;
    }

    public List<String> getErrors() {
        return this.errorMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws OperatorException {
        Date currentTime = new Date();
        try {
            if (this.descriptor == null) {
                this.descriptor = (ToolAdapterOperatorDescriptor)this.accessibleContext.getOperatorSpi().getOperatorDescriptor();
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.beginTask("Executing " + this.descriptor.getName(), 100);
            }
            if (this.consumer == null) {
                this.consumer = new DefaultOutputConsumer(this.descriptor.getProgressPattern(), this.descriptor.getErrorPattern(), this.descriptor.getStepPattern(), this.progressMonitor);
                this.consumer.setLogger(this.getLogger());
            }
            if (this.errorMessages != null) {
                this.errorMessages.clear();
            }
            this.validateDescriptor();
            if (!this.isStopped) {
                this.beforeExecute();
            }
            if (!this.isStopped) {
                this.execute();
            }
            if (this.consumer != null) {
                Date finalDate = new Date();
                this.consumer.consumeOutput("Finished tool execution in " + (finalDate.getTime() - currentTime.getTime()) / 1000L + " seconds");
            }
        }
        finally {
            try {
                if (!this.wasCancelled) {
                    this.postExecute();
                }
            }
            finally {
                if (this.progressMonitor != null) {
                    this.progressMonitor.done();
                }
            }
        }
    }

    public List<String> getExecutionOutput() {
        return this.consumer.getProcessOutput();
    }

    public Product getResult() {
        return this.accessibleContext.isInitialized() ? this.accessibleContext.getTargetProduct() : null;
    }

    private void validateDescriptor() throws OperatorException {
        File toolFile = this.descriptor.resolveVariables(this.descriptor.getMainToolFileLocation());
        if (toolFile == null) {
            throw new OperatorException("Tool file not defined!");
        }
        if (!toolFile.exists() || !toolFile.isFile()) {
            throw new OperatorException(String.format("Invalid tool file: '%s'!", toolFile.getAbsolutePath()));
        }
        ParameterDescriptor[] parameterDescriptors = this.descriptor.getParameterDescriptors();
        if (parameterDescriptors != null && parameterDescriptors.length > 0) {
            for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
                Class dataType = parameterDescriptor.getDataType();
                String defaultValue = parameterDescriptor.getDefaultValue();
                if (!File.class.isAssignableFrom(dataType) || !parameterDescriptor.isNotNull() && !parameterDescriptor.isNotEmpty() || defaultValue != null && !defaultValue.isEmpty() && Files.exists(Paths.get(defaultValue, new String[0]), new LinkOption[0])) continue;
                throw new OperatorException(String.format("Parameter %s is marked as %s, but the value is missing", parameterDescriptor.getName(), parameterDescriptor.isNotNull() ? "NotNull" : "NotEmpty"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeExecute() throws OperatorException {
        String sourceFormatName;
        this.reportProgress("Interpreting pre-execution template");
        this.descriptor.getToolParameterDescriptors().stream().filter(parameter -> parameter.getParameterType().equals("TemplateBeforeExecution")).forEach(parameter -> {
            try {
                this.transformTemplateParameter((TemplateParameterDescriptor)((Object)parameter));
            }
            catch (IOException e) {
                this.getLogger().severe(String.format("Error processing template before execution for parameter [%s]", parameter.getName()));
            }
        });
        if (this.descriptor.shouldWriteBeforeProcessing().booleanValue() && (sourceFormatName = this.descriptor.getProcessingWriter()) != null) {
            this.reportProgress(String.format("Converting source product to %s", sourceFormatName));
            ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
            Iterator writerPlugIns = registry.getWriterPlugIns(sourceFormatName);
            ProductWriterPlugIn writerPlugIn = (ProductWriterPlugIn)writerPlugIns.next();
            Product[] selectedProducts = this.getSourceProducts();
            String sourceDefaultExtension = writerPlugIn.getDefaultFileExtensions()[0];
            for (Product selectedProduct : selectedProducts) {
                File outFile = new File(this.descriptor.resolveVariables(this.descriptor.getWorkingDir()), INTERMEDIATE_PRODUCT_NAME + sourceDefaultExtension);
                boolean hasDeleted = false;
                while (outFile.exists() && !hasDeleted) {
                    hasDeleted = outFile.canWrite() && outFile.delete();
                    if (hasDeleted) continue;
                    this.getLogger().warning(String.format("Could not delete previous temporary image %s", outFile.getName()));
                    outFile = new File(this.descriptor.resolveVariables(this.descriptor.getWorkingDir()), "interimProduct_" + new Date().getTime() + sourceDefaultExtension);
                }
                Product interimProduct = new Product(outFile.getName(), selectedProduct.getProductType(), selectedProduct.getSceneRasterWidth(), selectedProduct.getSceneRasterHeight());
                try {
                    ProductUtils.copyProductNodes((Product)selectedProduct, (Product)interimProduct);
                    for (Band sourceBand : selectedProduct.getBands()) {
                        ProductUtils.copyBand((String)sourceBand.getName(), (Product)selectedProduct, (Product)interimProduct, (boolean)true);
                    }
                    ProductIO.writeProduct((Product)interimProduct, (File)outFile, (String)sourceFormatName, (boolean)true, (ProgressMonitor)SubProgressMonitor.create((ProgressMonitor)this.progressMonitor, (int)50));
                }
                catch (IOException e) {
                    this.getLogger().severe(String.format("Cannot write to %s format", sourceFormatName));
                    this.stop();
                }
                finally {
                    try {
                        interimProduct.closeIO();
                        interimProduct.dispose();
                    }
                    catch (IOException iOException) {}
                    interimProduct = null;
                    this.reportProgress("Product conversion finished");
                }
                if (outFile.exists()) {
                    this.intermediateProductFiles.add(outFile);
                    continue;
                }
                this.stop();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int execute() throws OperatorException {
        Process process = null;
        BufferedReader outReader = null;
        int ret = -1;
        try {
            this.reportProgress("Starting tool execution");
            List<String> cmdLine = this.getCommandLineTokens();
            this.logCommandLine(cmdLine);
            ProcessBuilder pb = new ProcessBuilder(cmdLine);
            pb.redirectErrorStream(true);
            pb.directory(this.descriptor.resolveVariables(this.descriptor.getWorkingDir()));
            pb.environment().putAll(this.descriptor.getVariables().stream().collect(Collectors.toMap(SystemVariable::getKey, SystemVariable::getValue)));
            process = pb.start();
            outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (!this.isStopped()) {
                while (!this.isStopped && outReader.ready()) {
                    String line = outReader.readLine();
                    if (line == null || "".equals(line.trim())) continue;
                    this.consumer.consumeOutput(line);
                }
                if (!process.isAlive()) {
                    this.stop();
                    continue;
                }
                Thread.yield();
            }
            if (process.exitValue() != 0) {
                throw new IOException(String.format("Process exited with value %d", process.exitValue()));
            }
            if (process == null) return ret;
            if (process.isAlive()) {
                process.destroyForcibly();
            }
        }
        catch (IOException e) {
            try {
                this.wasCancelled = true;
                throw new OperatorException(String.format("%s execution was interrupted [%s]", this.descriptor.getName(), e));
            }
            catch (Throwable throwable) {
                if (process == null) throw throwable;
                if (process.isAlive()) {
                    process.destroyForcibly();
                }
                try {
                    ret = process.waitFor();
                }
                catch (InterruptedException e2) {
                    throw new OperatorException(String.format("Error stopping %s [%s]", this.descriptor.getName(), e2));
                }
                this.closeStream(outReader);
                this.closeStream(process.getErrorStream());
                this.closeStream(process.getInputStream());
                this.closeStream(process.getOutputStream());
                throw throwable;
            }
        }
        try {
            ret = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new OperatorException(String.format("Error stopping %s [%s]", this.descriptor.getName(), e));
        }
        this.closeStream(outReader);
        this.closeStream(process.getErrorStream());
        this.closeStream(process.getInputStream());
        this.closeStream(process.getOutputStream());
        return ret;
    }

    private void postExecute() throws OperatorException {
        for (TemplateParameterDescriptor parameter : this.descriptor.getToolParameterDescriptors()) {
            if (!parameter.getParameterType().equals("TemplateAfterExecution")) continue;
            try {
                this.transformTemplateParameter(parameter);
            }
            catch (IOException e) {
                throw new OperatorException("Error processing template after execution for parameter: '" + parameter.getName() + "'");
            }
        }
        this.reportProgress("Trying to open the new product");
        File input = this.descriptor.resolveVariables((File)this.getParameter("targetProductFile"));
        if (input == null) {
            input = this.descriptor.resolveVariables((File)this.lastPostContext.get("targetProductFile"));
        }
        this.lastPostContext = null;
        if (input != null) {
            try {
                this.intermediateProductFiles.stream().filter(intermediateProductFile -> intermediateProductFile != null && intermediateProductFile.exists()).filter(intermediateProductFile -> !intermediateProductFile.canWrite() || !intermediateProductFile.delete()).forEach(intermediateProductFile -> this.getLogger().warning(String.format("Temporary image %s could not be deleted", intermediateProductFile.getName())));
                if (input.isDirectory()) {
                    input = this.selectCandidateRasterFile(input);
                }
                this.getLogger().info(String.format("Trying to open %s", input.getAbsolutePath()));
                Product target = ProductIO.readProduct((File)input);
                this.setTargetProduct(target);
            }
            catch (IOException e) {
                throw new OperatorException("Error reading product '" + input.getPath() + "'");
            }
        }
        if (this.consumer != null && this.consumer instanceof DefaultOutputConsumer) {
            ((DefaultOutputConsumer)this.consumer).close();
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void logCommandLine(List<String> cmdLine) {
        StringBuilder sb = new StringBuilder();
        sb.append("Executing tool '").append(this.descriptor.getName()).append("' with command line: ");
        sb.append('\'').append(cmdLine.get(0));
        for (int i = 1; i < cmdLine.size(); ++i) {
            sb.append(' ').append(cmdLine.get(i));
        }
        sb.append('\'');
        this.getLogger().log(Level.INFO, sb.toString());
    }

    private List<String> getCommandLineTokens() throws OperatorException {
        ArrayList<String> tokens = new ArrayList<String>();
        String templateFile = ((ToolAdapterOperatorDescriptor)this.getSpi().getOperatorDescriptor()).getTemplateFileLocation();
        if (templateFile != null) {
            tokens.add(this.descriptor.resolveVariables(this.descriptor.getMainToolFileLocation()).getAbsolutePath());
            if (templateFile.endsWith("-template.vm")) {
                tokens.addAll(this.transformTemplate(new File(this.adapterFolder, templateFile)));
            } else {
                throw new OperatorException("Invalid Velocity template");
            }
        }
        return tokens;
    }

    private void putParametersToVeloContext(VelocityContext context, boolean transformTemplates) {
        Property[] params;
        for (Property param : params = this.accessibleContext.getParameterSet().getProperties()) {
            boolean foundTemplateParam = false;
            if (transformTemplates) {
                for (TemplateParameterDescriptor paramDescriptor : this.descriptor.getToolParameterDescriptors()) {
                    if (!paramDescriptor.getName().equals(param.getName()) || !paramDescriptor.isTemplateParameter()) continue;
                    foundTemplateParam = true;
                    try {
                        String transformedFile = this.transformTemplateParameter(paramDescriptor);
                        context.put(param.getName(), (Object)transformedFile);
                        break;
                    }
                    catch (IOException ex) {
                        throw new OperatorException("Error on transforming template for parameter '" + paramDescriptor.getName());
                    }
                }
            }
            if (foundTemplateParam) continue;
            String paramName = param.getName();
            Object paramValue = param.getValue();
            if ("targetProductFile".equals(paramName)) {
                paramValue = this.getNextFileName(this.descriptor.resolveVariables((File)paramValue));
            }
            if (param.getType().isArray()) {
                paramValue = StringUtils.arrayToString((Object)paramValue, (String)"\n");
            }
            context.put(paramName, paramValue);
        }
        Product sourceProducts = this.getSourceProducts();
        context.put("sourceProduct", (Object)(((Product[])sourceProducts).length == 1 ? sourceProducts[0] : sourceProducts));
        File[] rasterFiles = new File[((Product)sourceProducts).length];
        for (int i = 0; i < ((Product)sourceProducts).length; ++i) {
            File productFile = this.intermediateProductFiles.size() == ((Product)sourceProducts).length ? this.intermediateProductFiles.get(i) : sourceProducts[i].getFileLocation();
            rasterFiles[i] = productFile.isFile() ? productFile : this.selectCandidateRasterFile(productFile);
        }
        context.put("sourceProductFile", rasterFiles.length == 1 ? rasterFiles[0] : rasterFiles);
    }

    private String transformTemplateParameter(TemplateParameterDescriptor parameter) throws IOException {
        File templateFile = (File)this.accessibleContext.getParameterSet().getProperty(parameter.getName()).getValue();
        templateFile = ToolAdapterIO.ensureLocalCopy(templateFile, this.descriptor.getAlias());
        VelocityEngine veloEngine = new VelocityEngine();
        veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
        for (SystemVariable variable : this.descriptor.getVariables()) {
            veloEngine.addProperty(variable.getKey(), (Object)variable.getValue());
        }
        veloEngine.init();
        Template veloTemplate = veloEngine.getTemplate(templateFile.getName());
        VelocityContext veloContext = new VelocityContext();
        for (ToolParameterDescriptor param : parameter.getToolParameterDescriptors()) {
            veloContext.put(param.getName(), (Object)param.getDefaultValue());
        }
        this.putParametersToVeloContext(veloContext, false);
        StringWriter writer = new StringWriter();
        veloTemplate.merge((Context)veloContext, (Writer)writer);
        String result = writer.toString();
        String separatorChar = "_";
        String dateFormatted = DateFormat.getDateInstance(3, Locale.ENGLISH).format(new Date());
        dateFormatted = dateFormatted + separatorChar + DateFormat.getTimeInstance(2, Locale.ENGLISH).format(new Date()).replace(":", separatorChar);
        dateFormatted = dateFormatted.replace("/", separatorChar).replace(" ", separatorChar);
        String newFileName = templateFile.getName() + "_result_" + dateFormatted;
        ToolAdapterIO.saveFileContent(new File(this.descriptor.resolveVariables(this.descriptor.getWorkingDir()), newFileName), result);
        this.lastPostContext = veloContext;
        return newFileName;
    }

    private List<String> transformTemplate(File templateFile) throws OperatorException {
        VelocityEngine veloEngine = new VelocityEngine();
        veloEngine.setProperty("file.resource.loader.path", (Object)templateFile.getParent());
        List<SystemVariable> variables = this.descriptor.getVariables();
        for (SystemVariable variable : variables) {
            veloEngine.addProperty(variable.getKey(), (Object)variable.getValue());
        }
        veloEngine.init();
        Template veloTemplate = veloEngine.getTemplate(templateFile.getName());
        VelocityContext veloContext = new VelocityContext();
        this.putParametersToVeloContext(veloContext, true);
        for (SystemVariable variable : variables) {
            veloContext.put(variable.getKey(), (Object)variable.getValue());
        }
        StringWriter writer = new StringWriter();
        veloTemplate.merge((Context)veloContext, (Writer)writer);
        String result = writer.toString();
        return Arrays.asList(result.split(VELOCITY_LINE_SEPARATOR));
    }

    private File selectCandidateRasterFile(File folder) {
        File rasterFile = null;
        List<File> candidates = this.getRasterFiles(folder);
        int numFiles = candidates.size() - 1;
        if (numFiles >= 0) {
            candidates.sort(Comparator.comparingLong(File::length));
            rasterFile = candidates.get(numFiles);
            this.getLogger().info(rasterFile.getName() + " was selected as raster file");
        }
        return rasterFile;
    }

    private List<File> getRasterFiles(File folder) {
        File[] subFolders;
        ArrayList<File> rasters = new ArrayList<File>();
        for (String extension : DEFAULT_EXTENSIONS) {
            File[] files = folder.listFiles((dir, name) -> name.endsWith(extension));
            if (files == null) continue;
            rasters.addAll(Arrays.asList(files));
        }
        for (File subFolder : subFolders = folder.listFiles(File::isDirectory)) {
            List<File> subCandidates = this.getRasterFiles(subFolder);
            if (subCandidates == null) continue;
            rasters.addAll(subCandidates);
        }
        return rasters;
    }

    private void reportProgress(String message) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setTaskName(message);
        }
    }

    private File getNextFileName(File file) {
        if (file != null) {
            int counter = 1;
            File initial = file;
            while (file.exists()) {
                file = new File(initial.getParent(), FileUtils.getFilenameWithoutExtension((File)initial) + "_" + String.valueOf(counter++) + FileUtils.getExtension((File)initial));
            }
        }
        return file;
    }
}

