/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterConstants;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOp;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterRegistry;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Config;

public class ToolAdapterIO {
    private static final String[] userSubfolders;
    private static final Logger logger;
    private static final Map<String, String> shellExtensions;
    private static final String osFamily;

    public static void setAdaptersPath(Path path) {
        Preferences preferences = ToolAdapterIO.getPreferences();
        preferences.put("user.module.path", path.toFile().getAbsolutePath());
        try {
            preferences.sync();
        }
        catch (BackingStoreException e) {
            logger.severe("Cannot set adapters path in preferences: " + e.getMessage());
        }
    }

    public static void saveVariable(String name, String value) {
        if (value != null && value.length() > 0) {
            Preferences preferences = ToolAdapterIO.getPreferences();
            preferences.put(name, value);
            try {
                preferences.sync();
            }
            catch (BackingStoreException e) {
                logger.severe(String.format("Cannot set %s value in preferences: %s", name, e.getMessage()));
            }
        }
    }

    public static String getVariableValue(String name, String defaultValue, boolean isShared) {
        Preferences preferences = ToolAdapterIO.getPreferences();
        String retVal = preferences.get(name, null);
        if ((retVal == null || retVal.isEmpty()) && defaultValue != null) {
            if (isShared) {
                ToolAdapterIO.saveVariable(name, defaultValue);
            }
            retVal = defaultValue;
        }
        return retVal;
    }

    public static Collection<ToolAdapterOpSpi> searchAndRegisterAdapters() {
        Logger logger = Logger.getLogger(ToolAdapterOpSpi.class.getName());
        List<File> moduleFolders = null;
        try {
            ToolAdapterRegistry.INSTANCE.clear();
            moduleFolders = ToolAdapterIO.scanForAdapters();
        }
        catch (IOException e) {
            logger.severe("Failed scan for Tools descriptors: I/O problem: " + e.getMessage());
        }
        if (moduleFolders != null) {
            for (File moduleFolder : moduleFolders) {
                try {
                    ToolAdapterIO.registerAdapter(moduleFolder);
                }
                catch (Exception ex) {
                    logger.severe(String.format("Failed to register module %s. Problem: %s", moduleFolder.getName(), ex.getMessage()));
                }
            }
        }
        return Collections.unmodifiableCollection(ToolAdapterRegistry.INSTANCE.getOperatorMap().values());
    }

    public static ToolAdapterOpSpi createOperatorSpi(final File operatorFolder) throws OperatorException {
        File descriptorFile = new File(operatorFolder, ToolAdapterConstants.DESCRIPTOR_FILE);
        if (descriptorFile.exists()) {
            ToolAdapterOperatorDescriptor operatorDescriptor = ToolAdapterOperatorDescriptor.fromXml(descriptorFile, ToolAdapterIO.class.getClassLoader());
            return new ToolAdapterOpSpi(operatorDescriptor){

                public Operator createOperator() throws OperatorException {
                    ToolAdapterOp toolOperator = (ToolAdapterOp)super.createOperator();
                    toolOperator.setAdapterFolder(operatorFolder);
                    toolOperator.setParameterDefaultValues();
                    return toolOperator;
                }
            };
        }
        throw new OperatorException(String.format("Missing operator metadata file '%s'", descriptorFile));
    }

    public static String readOperatorTemplate(String adapterName) throws IOException, OperatorException {
        File file = ToolAdapterIO.getTemplateFile(adapterName);
        byte[] encoded = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        return new String(encoded, Charset.defaultCharset());
    }

    public static void writeOperatorTemplate(String adapterName, String content) throws IOException {
        File file = ToolAdapterIO.getTemplateFile(adapterName);
        ToolAdapterIO.saveFileContent(file, content);
    }

    public static void removeOperator(ToolAdapterOperatorDescriptor operator) {
        ToolAdapterIO.removeOperator(operator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAndRegisterOperator(ToolAdapterOperatorDescriptor operator, String templateContent) throws IOException, URISyntaxException {
        File rootFolder = ToolAdapterIO.getUserAdapterPath();
        final File moduleFolder = new File(rootFolder, operator.getAlias());
        String tempAlias = operator.getAlias() + "_TEMP" + new Random().nextInt(100);
        Path tempPath = moduleFolder.toPath().resolveSibling(tempAlias);
        Files.deleteIfExists(tempPath);
        ToolAdapterIO.copyFolderContent(moduleFolder.toPath(), tempPath, true);
        try {
            ToolAdapterIO.removeOperator(operator, true);
            if (!moduleFolder.exists() && !moduleFolder.mkdir()) {
                throw new OperatorException("Operator folder " + moduleFolder + " could not be created!");
            }
            ToolAdapterOpSpi operatorSpi = new ToolAdapterOpSpi(operator){

                public Operator createOperator() throws OperatorException {
                    ToolAdapterOp toolOperator = (ToolAdapterOp)super.createOperator();
                    toolOperator.setAdapterFolder(moduleFolder);
                    toolOperator.setParameterDefaultValues();
                    return toolOperator;
                }
            };
            File descriptorFile = new File(moduleFolder, ToolAdapterConstants.DESCRIPTOR_FILE);
            if (!descriptorFile.exists()) {
                descriptorFile.getParentFile().mkdirs();
                if (!descriptorFile.createNewFile()) {
                    throw new OperatorException("Operator file " + descriptorFile + " could not be created!");
                }
            }
            String xmlContent = operator.toXml(ToolAdapterIO.class.getClassLoader());
            ToolAdapterIO.saveFileContent(descriptorFile, xmlContent);
            ToolAdapterRegistry.INSTANCE.registerOperator(operatorSpi);
            ToolAdapterIO.writeOperatorTemplate(operator.getName(), templateContent);
            ToolAdapterIO.deleteFolder(tempPath);
        }
        catch (Throwable throwable) {
            if (Files.exists(tempPath, new LinkOption[0]) && !moduleFolder.exists()) {
                Files.move(tempPath, moduleFolder.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            throw throwable;
        }
        if (Files.exists(tempPath, new LinkOption[0]) && !moduleFolder.exists()) {
            Files.move(tempPath, moduleFolder.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
    }

    public static ToolAdapterOpSpi registerAdapter(File adapterFolder) throws OperatorException {
        ToolAdapterOpSpi operatorSpi = ToolAdapterIO.createOperatorSpi(adapterFolder);
        ToolAdapterRegistry.INSTANCE.registerOperator(operatorSpi);
        return operatorSpi;
    }

    public static List<File> scanForAdapters() throws IOException {
        logger.log(Level.INFO, "Loading external tools...");
        ArrayList<File> modules = new ArrayList<File>();
        File userModulesPath = ToolAdapterIO.getUserAdapterPath();
        logger.info("Scanning for external tools adapters: " + userModulesPath.getAbsolutePath());
        modules.addAll(ToolAdapterIO.scanForAdapters(userModulesPath));
        return modules;
    }

    public static File getUserAdapterPath() {
        File userModulePath;
        String userPath = Config.instance().load().preferences().get("user.module.path", null);
        if (userPath == null) {
            userModulePath = SystemUtils.getAuxDataPath().toFile();
            for (String subFolder : userSubfolders) {
                userModulePath = new File(userModulePath, subFolder);
            }
        } else {
            userModulePath = new File(userPath);
        }
        if (!userModulePath.exists() && !userModulePath.mkdirs()) {
            logger.severe("Cannot create user folder for external tool adapter extensions");
        }
        return userModulePath;
    }

    public static void saveFileContent(File file, String content) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
            writer.flush();
            writer.close();
        }
    }

    public static void removeOperator(ToolAdapterOperatorDescriptor operator, boolean removeOperatorFolder) {
        File rootFolder;
        File moduleFolder;
        ToolAdapterRegistry.INSTANCE.removeOperator(operator);
        if (removeOperatorFolder && (moduleFolder = new File(rootFolder = ToolAdapterIO.getUserAdapterPath(), operator.getAlias())).exists() && !FileUtils.deleteTree((File)moduleFolder)) {
            logger.warning(String.format("Folder %s cannot be deleted", moduleFolder.getAbsolutePath()));
        }
    }

    public static File ensureLocalCopy(File file, String adaptorAlias) {
        File newFile = null;
        File path = new File(ToolAdapterIO.getUserAdapterPath(), adaptorAlias);
        if (!path.exists()) {
            path.mkdir();
        }
        if (!file.isAbsolute()) {
            newFile = new File(path, file.getName());
        } else if (file.exists() && !file.getAbsolutePath().startsWith(path.getAbsolutePath())) {
            try {
                newFile = Files.copy(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(path.getAbsolutePath(), file.getName()), StandardCopyOption.REPLACE_EXISTING).toFile();
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
            }
        } else {
            newFile = file;
        }
        return newFile;
    }

    public static String getShellExtension() {
        return shellExtensions.get(osFamily);
    }

    public static String getOsFamily() {
        return osFamily;
    }

    private static List<File> scanForAdapters(File path) throws IOException {
        if (!path.exists() || !path.isDirectory()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        File[] jarFiles = path.listFiles(f -> f.getName().endsWith(".jar"));
        if (jarFiles != null) {
            for (File jarFile : jarFiles) {
                try {
                    ToolAdapterIO.unpackAdapterJar(jarFile, null);
                }
                catch (IOException ioEx) {
                    logger.warning(ioEx.getMessage());
                }
            }
        }
        File[] moduleFolders = path.listFiles();
        ArrayList<File> modules = new ArrayList<File>();
        if (moduleFolders != null) {
            for (File moduleFolder : moduleFolders) {
                File descriptorFile = new File(moduleFolder, ToolAdapterConstants.DESCRIPTOR_FILE);
                if (!descriptorFile.exists()) continue;
                modules.add(moduleFolder);
            }
        }
        return modules;
    }

    private static File getTemplateFile(String adapterName) throws IOException, OperatorException {
        OperatorSpi spi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(adapterName);
        if (spi == null) {
            throw new OperatorException("Cannot find the operator SPI");
        }
        ToolAdapterOperatorDescriptor operatorDescriptor = (ToolAdapterOperatorDescriptor)spi.getOperatorDescriptor();
        if (operatorDescriptor == null) {
            throw new OperatorException("Cannot read the operator template file");
        }
        String templateFile = operatorDescriptor.getTemplateFileLocation();
        return new File(ToolAdapterIO.getUserAdapterPath(), spi.getOperatorAlias() + File.separator + templateFile);
    }

    private static void unpackAdapterJar(File jarFile, File unpackFolder) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        if (unpackFolder == null) {
            unpackFolder = new File(ToolAdapterIO.getUserAdapterPath(), jarFile.getName().replace(".jar", ""));
        }
        if (!unpackFolder.exists() && !unpackFolder.mkdir()) {
            logger.warning(String.format("Cannot create folder %s", unpackFolder.getAbsolutePath()));
        }
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            File f = new File(unpackFolder, file.getName());
            if (file.isDirectory()) {
                if (f.mkdir()) continue;
                logger.warning(String.format("Cannot create folder %s", f.getAbsolutePath()));
                continue;
            }
            if (!f.getParentFile().mkdirs()) {
                logger.warning(String.format("Cannot create folder %s", f.getParentFile().getAbsolutePath()));
            }
            InputStream is = jar.getInputStream(file);
            Throwable throwable = null;
            try {
                try (FileOutputStream fos = new FileOutputStream(f);){
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                    fos.close();
                }
                is.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private static Preferences getPreferences() {
        Path storagePath = Config.instance().storagePath();
        File file = storagePath.toFile();
        if (!file.exists()) {
            try {
                if (!file.getParentFile().mkdirs() || !file.createNewFile()) {
                    logger.warning("Cannot create module preferences");
                }
            }
            catch (IOException e) {
                logger.severe("Error while creating module preferences: " + e.getMessage());
            }
        }
        Config instance = Config.instance().load();
        return instance.preferences();
    }

    private static void copyFolderContent(Path source, Path destination, boolean recursive) throws IOException {
        if (Files.exists(source, new LinkOption[0])) {
            if (!Files.exists(destination, new LinkOption[0])) {
                Files.createDirectory(destination, new FileAttribute[0]);
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(source);){
                for (Path path : directoryStream) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        ToolAdapterIO.copyFolderContent(path, destination.resolve(path.getFileName()), recursive);
                        continue;
                    }
                    Files.copy(path, destination.resolve(path.getFileName()), new CopyOption[0]);
                }
            }
        }
    }

    private static void deleteFolder(Path location) throws IOException {
        if (Files.exists(location, new LinkOption[0])) {
            Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    static {
        logger = Logger.getLogger(ToolAdapterIO.class.getName());
        userSubfolders = new String[]{"tool-adapters"};
        shellExtensions = new HashMap<String, String>();
        shellExtensions.put("windows", ".bat");
        shellExtensions.put("linux", ".sh");
        shellExtensions.put("macosx", ".sh");
        shellExtensions.put("unsupported", "");
        String sysName = System.getProperty("os.name").toLowerCase();
        osFamily = sysName.contains("windows") ? "windows" : (sysName.contains("linux") ? "linux" : (sysName.contains("mac") ? "macosx" : "unsupported"));
    }
}

