/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.gpf.operators.tooladapter.ProcessOutputConsumer;

class DefaultOutputConsumer
implements ProcessOutputConsumer {
    private Pattern error;
    private Pattern progress;
    private Pattern step;
    private Logger logger;
    private ProgressMonitor progressMonitor;
    private List<String> processOutput;
    private static final int MAX_UNITS = 100;

    public DefaultOutputConsumer() {
        this(null, null, null);
    }

    public DefaultOutputConsumer(String progressPattern, ProgressMonitor pm) {
        this(progressPattern, null, null, pm);
    }

    public DefaultOutputConsumer(String progressPattern, String errorPattern, ProgressMonitor pm) {
        this(progressPattern, errorPattern, null, pm);
    }

    public DefaultOutputConsumer(String progressPattern, String errorPattern, String stepPattern, ProgressMonitor pm) {
        this.progressMonitor = pm;
        if (errorPattern != null && errorPattern.trim().length() > 0) {
            this.error = Pattern.compile(errorPattern, 2);
        }
        if (stepPattern != null && stepPattern.trim().length() > 0) {
            this.step = Pattern.compile(stepPattern, 2);
        }
        if (progressPattern != null && progressPattern.trim().length() > 0) {
            this.progress = Pattern.compile(progressPattern, 2);
            this.initializeProgressMonitor();
        }
        this.processOutput = new ArrayList<String>();
    }

    public void setProgressMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
        this.initializeProgressMonitor();
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(DefaultOutputConsumer.class.getName());
        }
        return this.logger;
    }

    @Override
    public void consumeOutput(String line) {
        try {
            Matcher matcher;
            if (this.progress != null && (matcher = this.progress.matcher(line)).find()) {
                int worked;
                try {
                    worked = Integer.parseInt(matcher.group());
                }
                catch (Exception e) {
                    worked = (int)Float.parseFloat(matcher.group());
                }
                this.progressMonitor.worked(Math.min(worked, 100));
                this.progressMonitor.setSubTaskName(line);
            }
            if (this.step != null && (matcher = this.step.matcher(line)).find()) {
                this.progressMonitor.setTaskName(matcher.group());
            }
            if (this.error != null && this.error.matcher(line).find()) {
                this.getLogger().severe(line);
            } else {
                this.getLogger().info(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processOutput.add(line);
    }

    @Override
    public List<String> getProcessOutput() {
        return this.processOutput;
    }

    private void initializeProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = ProgressMonitor.NULL;
            this.progressMonitor.beginTask("Starting", 100);
        }
    }

    public void close() {
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }
}

