/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.StreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.descriptor.DefaultSourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultSourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultTargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultTargetPropertyDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.SystemDependentVariable;
import org.esa.snap.core.gpf.descriptor.SystemVariable;
import org.esa.snap.core.gpf.descriptor.TargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetPropertyDescriptor;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.VariableResolver;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.utils.PrivilegedAccessor;

@XStreamAlias(value="operator")
public class ToolAdapterOperatorDescriptor
implements OperatorDescriptor {
    public static final String SOURCE_PACKAGE = "package";
    public static final String SOURCE_USER = "user";
    public static final Class[] annotatedClasses = new Class[]{ToolAdapterOperatorDescriptor.class, TemplateParameterDescriptor.class, SystemVariable.class, SystemDependentVariable.class};
    private String name;
    private Class<? extends Operator> operatorClass;
    private String alias;
    private String label;
    private String version;
    private String description;
    private String authors;
    private String copyright;
    private Boolean internal;
    private Boolean autoWriteSuppressed;
    private String menuLocation;
    private Boolean preprocessTool = false;
    private String preprocessorExternalTool;
    private Boolean writeForProcessing = false;
    private String processingWriter;
    private File mainToolFileLocation;
    private File workingDir;
    private String templateFileLocation;
    private String progressPattern;
    private String errorPattern;
    private String stepPattern;
    @XStreamAlias(value="variables")
    private List<SystemVariable> variables;
    @XStreamAlias(value="parameters")
    private List<TemplateParameterDescriptor> toolParameterDescriptors = new ArrayList<TemplateParameterDescriptor>();
    private String source;
    private boolean isSystem;
    private boolean isHandlingOutputName;
    private DefaultSourceProductDescriptor[] sourceProductDescriptors = new DefaultSourceProductDescriptor[]{new DefaultSourceProductDescriptor()};
    private DefaultSourceProductsDescriptor sourceProductsDescriptor;
    private DefaultTargetProductDescriptor targetProductDescriptor;
    private DefaultTargetPropertyDescriptor[] targetPropertyDescriptors;
    private int numSourceProducts;

    ToolAdapterOperatorDescriptor() {
        try {
            PrivilegedAccessor.setValue(this.sourceProductDescriptors[0], "name", "sourceProduct");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.variables = new ArrayList<SystemVariable>();
        this.toolParameterDescriptors = new ArrayList<TemplateParameterDescriptor>();
    }

    public ToolAdapterOperatorDescriptor(String name, Class<? extends Operator> operatorClass) {
        this();
        this.name = name;
        this.operatorClass = operatorClass;
    }

    public ToolAdapterOperatorDescriptor(String name, Class<? extends Operator> operatorClass, String alias, String label, String version, String description, String authors, String copyright, String menuLocation) {
        this(name, operatorClass);
        this.alias = alias;
        this.label = label;
        this.version = version;
        this.description = description;
        this.authors = authors;
        this.copyright = copyright;
        this.menuLocation = menuLocation;
    }

    public ToolAdapterOperatorDescriptor(ToolAdapterOperatorDescriptor obj) {
        this(obj.getName(), obj.getOperatorClass(), obj.getAlias(), obj.getLabel(), obj.getVersion(), obj.getDescription(), obj.getAuthors(), obj.getCopyright(), obj.getMenuLocation());
        this.internal = obj.isInternal();
        this.autoWriteSuppressed = obj.isAutoWriteDisabled();
        this.preprocessTool = obj.preprocessTool;
        this.preprocessorExternalTool = obj.preprocessorExternalTool;
        this.writeForProcessing = obj.writeForProcessing;
        this.processingWriter = obj.processingWriter;
        this.mainToolFileLocation = obj.mainToolFileLocation;
        this.workingDir = obj.workingDir;
        this.templateFileLocation = obj.templateFileLocation;
        this.progressPattern = obj.progressPattern;
        this.errorPattern = obj.errorPattern;
        this.stepPattern = obj.stepPattern;
        List<SystemVariable> variableList = obj.getVariables();
        if (variableList != null) {
            this.variables.addAll(variableList.stream().filter(systemVariable -> systemVariable != null).map(SystemVariable::createCopy).collect(Collectors.toList()));
        }
        this.sourceProductDescriptors = new DefaultSourceProductDescriptor[obj.getSourceProductDescriptors().length];
        for (int i = 0; i < obj.getSourceProductDescriptors().length; ++i) {
            this.sourceProductDescriptors[i] = (DefaultSourceProductDescriptor)obj.getSourceProductDescriptors()[i];
        }
        this.sourceProductsDescriptor = (DefaultSourceProductsDescriptor)obj.getSourceProductsDescriptor();
        for (TemplateParameterDescriptor parameter : obj.getToolParameterDescriptors()) {
            this.toolParameterDescriptors.add(new TemplateParameterDescriptor(parameter));
        }
        this.targetProductDescriptor = (DefaultTargetProductDescriptor)obj.getTargetProductDescriptor();
        this.targetPropertyDescriptors = new DefaultTargetPropertyDescriptor[obj.getTargetPropertyDescriptors().length];
        for (int i = 0; i < obj.getTargetPropertyDescriptors().length; ++i) {
            this.targetPropertyDescriptors[i] = (DefaultTargetPropertyDescriptor)obj.getTargetPropertyDescriptors()[i];
        }
        this.isHandlingOutputName = obj.isHandlingOutputName;
    }

    public ToolAdapterOperatorDescriptor(ToolAdapterOperatorDescriptor obj, String newName, String newAlias) {
        this(obj);
        this.name = newName;
        this.alias = newAlias;
    }

    public void removeParamDescriptor(TemplateParameterDescriptor descriptor) {
        this.toolParameterDescriptors.remove((Object)descriptor);
    }

    public void removeParamDescriptors(List<TemplateParameterDescriptor> descriptors) {
        if (descriptors != null && descriptors.size() > 0) {
            descriptors.forEach(this.toolParameterDescriptors::remove);
        }
    }

    public List<TemplateParameterDescriptor> getToolParameterDescriptors() {
        if (this.toolParameterDescriptors == null) {
            this.toolParameterDescriptors = new ArrayList<TemplateParameterDescriptor>();
        }
        return this.toolParameterDescriptors;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void seVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOperatorClass(Class<? extends Operator> operatorClass) {
        this.operatorClass = operatorClass;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public boolean isInternal() {
        return this.internal != null ? this.internal : false;
    }

    public boolean isAutoWriteDisabled() {
        return this.autoWriteSuppressed != null && this.autoWriteSuppressed != false;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMenuLocation() {
        return this.menuLocation;
    }

    public void setMenuLocation(String value) {
        this.menuLocation = value;
    }

    public String getSource() {
        return this.source != null ? this.source : SOURCE_USER;
    }

    public void setSource(String value) {
        this.source = value;
        if (!SOURCE_PACKAGE.equals(this.source) && !SOURCE_USER.equals(this.source)) {
            this.source = SOURCE_USER;
        }
    }

    public boolean isFromPackage() {
        return SOURCE_PACKAGE.equals(this.getSource());
    }

    public boolean isHandlingOutputName() {
        return this.isHandlingOutputName;
    }

    public void setHandlingOutputName(boolean value) {
        this.isHandlingOutputName = value;
    }

    public Class<? extends Operator> getOperatorClass() {
        return this.operatorClass != null ? this.operatorClass : Operator.class;
    }

    public SourceProductDescriptor[] getSourceProductDescriptors() {
        return this.sourceProductDescriptors != null ? this.sourceProductDescriptors : new SourceProductDescriptor[]{};
    }

    public SourceProductsDescriptor getSourceProductsDescriptor() {
        return this.sourceProductsDescriptor;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[]{};
        return this.getToolParameterDescriptors().toArray(result);
    }

    public TargetPropertyDescriptor[] getTargetPropertyDescriptors() {
        return this.targetPropertyDescriptors != null ? this.targetPropertyDescriptors : new TargetPropertyDescriptor[]{};
    }

    public TargetProductDescriptor getTargetProductDescriptor() {
        return this.targetProductDescriptor;
    }

    public String getTemplateFileLocation() {
        return this.templateFileLocation;
    }

    public void setTemplateFileLocation(String templateFileLocation) {
        this.templateFileLocation = templateFileLocation;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getMainToolFileLocation() {
        return this.mainToolFileLocation;
    }

    public void setMainToolFileLocation(File mainToolFileLocation) {
        this.mainToolFileLocation = mainToolFileLocation;
    }

    public File resolveVariables(File location) {
        return VariableResolver.newInstance(this).resolve(location);
    }

    public void setProgressPattern(String pattern) {
        this.progressPattern = pattern;
    }

    public String getProgressPattern() {
        return this.progressPattern;
    }

    public void setErrorPattern(String pattern) {
        this.errorPattern = pattern;
    }

    public String getErrorPattern() {
        return this.errorPattern;
    }

    public void setStepPattern(String pattern) {
        this.stepPattern = pattern;
    }

    public String getStepPattern() {
        return this.stepPattern;
    }

    public String getProcessingWriter() {
        return this.processingWriter;
    }

    public void setProcessingWriter(String processingWriter) {
        this.processingWriter = processingWriter;
    }

    public Boolean shouldWriteBeforeProcessing() {
        return this.writeForProcessing;
    }

    public void writeBeforeProcessing(Boolean writeForProcessing) {
        this.writeForProcessing = writeForProcessing;
    }

    public String getPreprocessorExternalTool() {
        return this.preprocessorExternalTool;
    }

    public void setPreprocessorExternalTool(String preprocessorExternalTool) {
        this.preprocessorExternalTool = preprocessorExternalTool;
    }

    public Boolean getPreprocessTool() {
        return this.preprocessTool;
    }

    public void setPreprocessTool(Boolean preprocessTool) {
        this.preprocessTool = preprocessTool;
    }

    public List<SystemVariable> getVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList<SystemVariable>();
        }
        return this.variables;
    }

    public String getVariableValue(String key) {
        String value = null;
        List variables = this.variables.stream().filter(v -> v.getKey().equals(key)).collect(Collectors.toList());
        if (variables != null && variables.size() == 1) {
            value = ((SystemVariable)variables.get(0)).getValue();
        }
        return value;
    }

    public int getSourceProductCount() {
        return this.numSourceProducts;
    }

    public void setSourceProductCount(int value) {
        this.numSourceProducts = value;
        this.sourceProductDescriptors = this.sourceProductDescriptors == null ? new DefaultSourceProductDescriptor[this.numSourceProducts] : Arrays.copyOf(this.sourceProductDescriptors, this.numSourceProducts);
        for (int i = 0; i < this.numSourceProducts; ++i) {
            if (this.sourceProductDescriptors[i] != null) continue;
            this.sourceProductDescriptors[i] = new DefaultSourceProductDescriptor();
            try {
                PrivilegedAccessor.setValue(this.sourceProductDescriptors[i], "name", "sourceProduct " + String.valueOf(i + 1));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addVariable(SystemVariable variable) {
        this.variables.add(variable);
    }

    public ToolAdapterOperatorDescriptor createCopy() {
        return new ToolAdapterOperatorDescriptor(this, this.name, this.alias);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ToolAdapterOperatorDescriptor fromXml(URL url, ClassLoader classLoader) {
        String resourceName = url.toExternalForm();
        try (InputStreamReader streamReader = new InputStreamReader(url.openStream());){
            ToolAdapterOperatorDescriptor operatorDescriptor;
            ToolAdapterOperatorDescriptor toolAdapterOperatorDescriptor = operatorDescriptor = ToolAdapterOperatorDescriptor.fromXml(streamReader, resourceName, classLoader);
            return toolAdapterOperatorDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(ToolAdapterOperatorDescriptor.formatReadExceptionText(resourceName, e), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ToolAdapterOperatorDescriptor fromXml(File file, ClassLoader classLoader) throws OperatorException {
        String resourceName = file.getPath();
        try (FileReader reader = new FileReader(file);){
            ToolAdapterOperatorDescriptor toolAdapterOperatorDescriptor = ToolAdapterOperatorDescriptor.fromXml(reader, resourceName, classLoader);
            return toolAdapterOperatorDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(ToolAdapterOperatorDescriptor.formatReadExceptionText(resourceName, e), (Throwable)e);
        }
    }

    public static ToolAdapterOperatorDescriptor fromXml(Reader reader, String resourceName, ClassLoader classLoader) throws OperatorException {
        ToolAdapterOperatorDescriptor descriptor = new ToolAdapterOperatorDescriptor();
        try {
            ToolAdapterOperatorDescriptor.createXStream(classLoader).fromXML(reader, (Object)descriptor);
            if (StringUtils.isNullOrEmpty((String)descriptor.getName())) {
                throw new OperatorException(ToolAdapterOperatorDescriptor.formatInvalidExceptionMessage(resourceName, "missing 'name' element"));
            }
            if (StringUtils.isNullOrEmpty((String)descriptor.getAlias())) {
                throw new OperatorException(ToolAdapterOperatorDescriptor.formatInvalidExceptionMessage(resourceName, "missing 'alias' element"));
            }
        }
        catch (StreamException e) {
            throw new OperatorException(ToolAdapterOperatorDescriptor.formatReadExceptionText(resourceName, (Exception)((Object)e)), (Throwable)e);
        }
        return descriptor;
    }

    public String toXml(ClassLoader classLoader) {
        return ToolAdapterOperatorDescriptor.createXStream(classLoader).toXML((Object)this);
    }

    private static XStream createXStream(ClassLoader classLoader) {
        XStream xStream = new XStream();
        xStream.setClassLoader(classLoader);
        xStream.processAnnotations(annotatedClasses);
        return xStream;
    }

    private static String formatReadExceptionText(String resourceName, Exception e) {
        return String.format("Failed to read operator descriptor from '%s':\nError: %s", resourceName, e.getMessage());
    }

    private static String formatInvalidExceptionMessage(String resourceName, String message) {
        return String.format("Invalid operator descriptor in '%s': %s", resourceName, message);
    }
}

