/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.StreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.util.StringUtils;

@XStreamAlias(value="parameter")
public class TemplateParameterDescriptor
extends ToolParameterDescriptor {
    @XStreamAlias(value="toolParameterDescriptors")
    private List<ToolParameterDescriptor> toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();

    public TemplateParameterDescriptor() {
        this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(String name, Class<?> type) {
        super(name, type);
        super.setParameterType("RegularParameter");
        this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(String name, Class<?> type, String parameterType) {
        this(name, type);
        super.setParameterType(parameterType);
    }

    public TemplateParameterDescriptor(DefaultParameterDescriptor object, String parameterType) {
        super(object, parameterType);
        this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(ToolParameterDescriptor object) {
        super(object, object.getParameterType());
        this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(TemplateParameterDescriptor object) {
        super(object, object.getParameterType());
        this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
        this.toolParameterDescriptors.addAll(object.getToolParameterDescriptors().stream().map(TemplateParameterDescriptor::new).collect(Collectors.toList()));
    }

    public void addParameterDescriptor(ToolParameterDescriptor descriptor) {
        this.toolParameterDescriptors.add(descriptor);
    }

    public void removeParameterDescriptor(ToolParameterDescriptor descriptor) {
        this.toolParameterDescriptors.remove((Object)descriptor);
    }

    public List<ToolParameterDescriptor> getToolParameterDescriptors() {
        if (this.toolParameterDescriptors == null) {
            this.toolParameterDescriptors = new ArrayList<ToolParameterDescriptor>();
        }
        return this.toolParameterDescriptors;
    }

    public String toXml(ClassLoader classLoader) {
        return TemplateParameterDescriptor.createXStream(classLoader).toXML((Object)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TemplateParameterDescriptor fromXml(URL url, ClassLoader classLoader) {
        String resourceName = url.toExternalForm();
        try (InputStreamReader streamReader = new InputStreamReader(url.openStream());){
            TemplateParameterDescriptor operatorDescriptor;
            TemplateParameterDescriptor templateParameterDescriptor = operatorDescriptor = TemplateParameterDescriptor.fromXml(streamReader, resourceName, classLoader);
            return templateParameterDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(TemplateParameterDescriptor.formatReadExceptionText(resourceName, e), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TemplateParameterDescriptor fromXml(File file, ClassLoader classLoader) throws OperatorException {
        String resourceName = file.getPath();
        try (FileReader reader = new FileReader(file);){
            TemplateParameterDescriptor templateParameterDescriptor = TemplateParameterDescriptor.fromXml(reader, resourceName, classLoader);
            return templateParameterDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(TemplateParameterDescriptor.formatReadExceptionText(resourceName, e), (Throwable)e);
        }
    }

    public static TemplateParameterDescriptor fromXml(Reader reader, String resourceName, ClassLoader classLoader) throws OperatorException {
        Assert.notNull((Object)reader, (String)"reader");
        Assert.notNull((Object)resourceName, (String)"resourceName");
        TemplateParameterDescriptor descriptor = new TemplateParameterDescriptor("DefaultParameter", String.class);
        try {
            TemplateParameterDescriptor.createXStream(classLoader).fromXML(reader, (Object)descriptor);
            if (StringUtils.isNullOrEmpty((String)descriptor.getName())) {
                throw new OperatorException(TemplateParameterDescriptor.formatInvalidExceptionMessage(resourceName, "missing 'name' element"));
            }
        }
        catch (StreamException e) {
            throw new OperatorException(TemplateParameterDescriptor.formatReadExceptionText(resourceName, (Exception)((Object)e)), (Throwable)e);
        }
        return descriptor;
    }

    private static XStream createXStream(ClassLoader classLoader) {
        XStream xStream = new XStream();
        xStream.setClassLoader(classLoader);
        xStream.processAnnotations(TemplateParameterDescriptor.class);
        return xStream;
    }

    private static String formatReadExceptionText(String resourceName, Exception e) {
        return String.format("Failed to read operator descriptor from '%s':\nError: %s", resourceName, e.getMessage());
    }

    private static String formatInvalidExceptionMessage(String resourceName, String message) {
        return String.format("Invalid operator descriptor in '%s': %s", resourceName, message);
    }
}

