/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator.ui;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.util.List;
import javax.media.jai.JAI;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.common.WriteOp;
import org.esa.snap.core.gpf.internal.OperatorExecutor;
import org.esa.snap.core.gpf.internal.OperatorProductReader;
import org.esa.snap.core.gpf.ui.DefaultSingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.esa.snap.smart.configurator.Benchmark;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.PerformanceParameters;
import org.esa.snap.smart.configurator.ui.PerformancePanel;
import org.esa.snap.ui.AppContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.util.Cancellable;

public class BenchmarkDialog
extends DefaultSingleTargetProductDialog {
    private Benchmark benchmarkModel;
    private PerformancePanel perfPanel;

    public BenchmarkDialog(PerformancePanel perfPanel, String operatorName, Benchmark benchmarkModel, AppContext appContext) {
        super(operatorName, appContext, "Benchmark " + operatorName, null, false);
        this.benchmarkModel = benchmarkModel;
        this.getJDialog().setModal(true);
        this.perfPanel = perfPanel;
    }

    protected void executeOperator(Product targetProduct, ProgressHandleMonitor pm) throws Exception {
        OperatorProductReader opReader;
        Operator operator;
        boolean autoWriteDisabled;
        TargetProductSelectorModel model = this.getTargetProductSelector().getModel();
        Operator execOp = null;
        if (targetProduct.getProductReader() instanceof OperatorProductReader && (autoWriteDisabled = (operator = (opReader = (OperatorProductReader)targetProduct.getProductReader()).getOperatorContext().getOperator()).getSpi().getOperatorDescriptor().isAutoWriteDisabled())) {
            execOp = operator;
        }
        if (execOp == null) {
            WriteOp writeOp = new WriteOp(targetProduct, model.getProductFile(), model.getFormatName());
            writeOp.setDeleteOutputOnFailure(true);
            writeOp.setWriteEntireTileRows(true);
            writeOp.setClearCacheAfterRowWrite(false);
            execOp = writeOp;
        }
        OperatorExecutor executor = OperatorExecutor.create(execOp);
        executor.execute(SubProgressMonitor.create((ProgressMonitor)pm, (int)95));
    }

    protected void onApply() {
        BenchmarkExecutor executor = new BenchmarkExecutor();
        ProgressHandleMonitor pm = ProgressHandleMonitor.create((String)"Running benchmark", (Cancellable)executor);
        executor.setProgressHandleMonitor(pm);
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)executor, (String)"Benchmarking....", (ProgressHandle)pm.getProgressHandle(), (boolean)true, (int)50, (int)1000);
    }

    private class BenchmarkExecutor
    implements Runnable,
    Cancellable {
        ProgressHandleMonitor progressHandleMonitor = null;
        BenchmarkSingleCalculus currentBenchmarkSingleCalcul = null;
        private boolean canceled = false;

        private BenchmarkExecutor() {
        }

        private void setProgressHandleMonitor(ProgressHandleMonitor progressHandleMonitor) {
            this.progressHandleMonitor = progressHandleMonitor;
        }

        public boolean cancel() {
            BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(this.currentBenchmarkSingleCalcul);
            this.canceled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.canceled = false;
            if (this.progressHandleMonitor == null) {
                throw new IllegalStateException("Progress Handle Monitor not set");
            }
            String tmpdirPath = System.getProperty("java.io.tmpdir") + "/snap-benchmark-tmp";
            BenchmarkDialog.this.appContext.getPreferences().setPropertyString("last_product_save_dir", tmpdirPath);
            PerformanceParameters currentPerformanceParameters = ConfigurationOptimizer.getInstance().getActualPerformanceParameters();
            this.currentBenchmarkSingleCalcul = new BenchmarkSingleCalculus(currentPerformanceParameters.getDefaultTileSize(), currentPerformanceParameters.getCacheSize(), currentPerformanceParameters.getNbThreads());
            BenchmarkDialog.this.benchmarkModel.addBenchmarkCalcul(this.currentBenchmarkSingleCalcul);
            try {
                this.progressHandleMonitor.beginTask("Benchmark running... ", BenchmarkDialog.this.benchmarkModel.getBenchmarkCalculus().size() * 100);
                List benchmarkSingleCalculusList = BenchmarkDialog.this.benchmarkModel.getBenchmarkCalculus();
                for (BenchmarkSingleCalculus benchmarkSingleCalcul : benchmarkSingleCalculusList) {
                    Product targetProduct;
                    this.progressHandleMonitor.getProgressHandle().progress(String.format("Benchmarking ( tile size:%d , cache size:%d , nb threads:%d )", benchmarkSingleCalcul.getTileSize(), benchmarkSingleCalcul.getCacheSize(), benchmarkSingleCalcul.getNbThreads()));
                    try {
                        targetProduct = BenchmarkDialog.this.createTargetProduct();
                    }
                    catch (Throwable t) {
                        BenchmarkDialog.this.handleInitialisationError(t);
                        throw t;
                    }
                    if (targetProduct == null) {
                        throw new NullPointerException("Target product is null.");
                    }
                    BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(benchmarkSingleCalcul);
                    long startTime = System.currentTimeMillis();
                    BenchmarkDialog.this.executeOperator(targetProduct, this.progressHandleMonitor);
                    long endTime = System.currentTimeMillis();
                    benchmarkSingleCalcul.setExecutionTime(endTime - startTime);
                    SystemUtils.LOG.fine(String.format("Start time: %d, end time: %d, diff: %d", startTime, endTime, endTime - startTime));
                    JAI.getDefaultInstance().setTileCache(JAI.createTileCache());
                }
                this.progressHandleMonitor.done();
            }
            catch (Exception ex) {
                SystemUtils.LOG.severe("Could not perform benchmark: " + ex.getMessage());
            }
            finally {
                BenchmarkDialog.this.benchmarkModel.loadBenchmarkPerfParams(this.currentBenchmarkSingleCalcul);
                VirtualDir.deleteFileTree((File)new File(tmpdirPath));
            }
            this.managePostBenchmark();
        }

        private void managePostBenchmark() {
            if (!this.canceled) {
                BenchmarkSingleCalculus bestBenchmarkSingleCalcul = BenchmarkDialog.this.benchmarkModel.getFasterBenchmarkSingleCalculus();
                Dialogs.showInformation((String)"Benchmark results", (String)BenchmarkDialog.this.benchmarkModel.toString(), null);
                BenchmarkDialog.this.perfPanel.updatePerformanceParameters(bestBenchmarkSingleCalcul);
            }
            BenchmarkDialog.this.close();
        }
    }
}

